/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.validator.clue;

import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.api.validator.clue.ICluePoolValidator;
import org.ow2.util.pool.impl.enhanced.impl.PoolError;
import org.ow2.util.pool.impl.enhanced.impl.validator.ValidatorPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorCluePool<E, C>
extends ValidatorPool<E>
implements ICluePool<E, C> {
    private ICluePool<E, C> cluePool;
    private ICluePoolValidator<E, C> cluePoolValidator;

    public ValidatorCluePool(ICluePool<E, C> cluePool, ICluePoolValidator<E, C> cluePoolValidator, boolean putValidate) {
        super(cluePool, cluePoolValidator, putValidate);
        this.cluePool = cluePool;
        this.cluePoolValidator = cluePoolValidator;
    }

    @Override
    public E get(C clue, IWaitControl timeout) throws PoolException, InterruptedException {
        E poolItem = this.cluePool.get(clue, timeout);
        while (!this.cluePoolValidator.validate(poolItem, clue)) {
            try {
                this.cluePool.remove(poolItem);
            }
            catch (NotABusyPoolItemException e) {
                throw new PoolError("Delegated pool has a bad behavior");
            }
            if (!timeout.canContinueToWait()) {
                throw new TimeoutPoolException();
            }
            poolItem = this.cluePool.get(timeout);
        }
        return poolItem;
    }
}

