/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Engine;
import fr.dyade.aaa.agent.HAEngine;
import fr.dyade.aaa.agent.JGroups;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.Network;
import fr.dyade.aaa.agent.SCServer;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.ServersHT;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.SimpleNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLCluster;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Timer;
import fr.dyade.aaa.util.ResolverRepository;
import fr.dyade.aaa.util.Transaction;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public final class AgentServer {
    public static final short NULL_ID = -1;
    public static final String ADMIN_DOMAIN = "D0";
    public static final String ADMIN_SERVER = "s0";
    private static short serverId = (short)-1;
    private static Logger logmon = null;
    public static final String CFG_DIR_PROPERTY = "fr.dyade.aaa.agent.A3CONF_DIR";
    public static final String DEFAULT_CFG_DIR = null;
    public static final String CFG_FILE_PROPERTY = "fr.dyade.aaa.agent.A3CONF_FILE";
    public static final String DEFAULT_CFG_FILE = "a3servers.xml";
    public static final String DEFAULT_SER_CFG_FILE = "a3cmlconfig";
    public static final String CFG_NAME_PROPERTY = "fr.dyade.aaa.agent.A3CONF_NAME";
    public static final String DEFAULT_CFG_NAME = "default";
    public static final String A3CMLWRP_PROPERTY = "fr.dyade.aaa.agent.A3CMLWrapper";
    public static final String DEFAULT_A3CMLWRP = "fr.dyade.aaa.agent.conf.A3CMLSaxWrapper";
    static ThreadGroup tgroup = null;
    static Engine engine = null;
    static Transaction transaction = null;
    private static JGroups jgroups = null;
    private static short clusterId = (short)-1;
    private static Hashtable consumers = null;
    private static Timer timer;
    private static A3CMLConfig a3config;
    private static String name;
    static ResolverRepository resolverRepo;
    private static ServersHT servers;
    static Status status;
    public static final String OKSTRING = "OK";
    public static final String ERRORSTRING = "ERROR";
    public static final String ENDSTRING = "END";

    public static ThreadGroup getThreadGroup() {
        return tgroup;
    }

    public static Engine getEngine() {
        return engine;
    }

    public static Transaction getTransaction() {
        return transaction;
    }

    public static boolean isHAServer() {
        return jgroups != null;
    }

    public static boolean isMasterHAServer() {
        if (jgroups != null) {
            return jgroups.isCoordinator();
        }
        return false;
    }

    public static void addConsumer(String domain, MessageConsumer cons) throws Exception {
        if (consumers.containsKey(domain)) {
            throw new Exception("Consumer for domain " + domain + " already exist");
        }
        consumers.put(domain, cons);
        try {
            MXWrapper.registerMBean(cons, "AgentServer", "server=" + AgentServer.getName() + ",cons=" + cons.getName());
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " jmx failed"), (Throwable)exc);
        }
    }

    static Enumeration getConsumers() {
        if (consumers == null) {
            return null;
        }
        return consumers.elements();
    }

    public static MessageConsumer getConsumer(String domain) throws Exception {
        if (!consumers.containsKey(domain)) {
            throw new Exception("Unknown consumer for domain " + domain);
        }
        return (MessageConsumer)consumers.get(domain);
    }

    public static void removeConsumer(String domain) {
        MessageConsumer cons = (MessageConsumer)consumers.remove(domain);
        if (cons != null) {
            cons.stop();
            try {
                MXWrapper.unregisterMBean("AgentServer", "server=" + AgentServer.getName() + ",cons=" + cons.getName());
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " jmx failed"), (Throwable)exc);
            }
        }
    }

    public static final Timer getTimer() {
        if (timer == null) {
            timer = new Timer();
        }
        return timer;
    }

    public static final void setConfig(A3CMLConfig a3config) throws Exception {
        AgentServer.setConfig(a3config, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setConfig(A3CMLConfig a3config, boolean force) throws Exception {
        if (!force) {
            Status status = AgentServer.status;
            synchronized (status) {
                if (AgentServer.status.value != 0) {
                    throw new Exception("cannot set config, bad status: " + AgentServer.getStatusInfo());
                }
            }
        }
        AgentServer.a3config = a3config;
    }

    public static final A3CMLConfig getConfig() throws Exception {
        if (a3config == null) {
            throw new Exception("Server not configured");
        }
        return a3config;
    }

    public static A3CMLConfig getAppConfig(String[] domains) throws Exception {
        return AgentServer.getConfig().getDomainConfig(domains);
    }

    public static final short getServerId() {
        return serverId;
    }

    public static final short getClusterId() {
        return clusterId;
    }

    public static final String getName() {
        return name;
    }

    public static ResolverRepository getResolverRepository() {
        if (resolverRepo == null) {
            resolverRepo = new ResolverRepository();
        }
        return resolverRepo;
    }

    public static short getServerIdByName(String name) throws Exception {
        return AgentServer.getConfig().getServerIdByName(name);
    }

    public static String getProperty(String key) {
        return Configuration.getProperty(key);
    }

    public static String getProperty(String key, String value) {
        return Configuration.getProperty(key, value);
    }

    public static Integer getInteger(String key) {
        return Configuration.getInteger(key);
    }

    public static Integer getInteger(String key, int value) {
        return Configuration.getInteger(key, value);
    }

    public static Long getLong(String key) {
        return Configuration.getLong(key);
    }

    public static Long getLong(String key, long value) {
        return Configuration.getLong(key, value);
    }

    public static boolean getBoolean(String key) {
        return Configuration.getBoolean(key);
    }

    public static void addServerDesc(ServerDesc desc) throws Exception {
        if (desc == null) {
            return;
        }
        servers.put(desc);
    }

    public static ServerDesc removeServerDesc(short sid) throws Exception {
        return servers.remove(sid);
    }

    public static Enumeration elementsServerDesc() {
        return servers.elements();
    }

    public static Enumeration getServersIds() {
        return servers.keys();
    }

    static final int getServerNb() {
        return servers.size();
    }

    public static final ServerDesc getServerDesc(short sid) throws UnknownServerException {
        ServerDesc serverDesc = servers.get(sid);
        if (serverDesc == null) {
            throw new UnknownServerException("Unknow server id. #" + sid);
        }
        return serverDesc;
    }

    static final MessageConsumer getConsumer(short sid) throws UnknownServerException {
        return AgentServer.getServerDesc(sid).getDomain();
    }

    public static final String getHostname(short sid) throws UnknownServerException {
        return AgentServer.getServerDesc(sid).getHostname();
    }

    static final ServiceDesc[] getServices() throws UnknownServerException {
        return AgentServer.getServerDesc((short)AgentServer.getServerId()).services;
    }

    public static final String getServiceArgs(short sid, String classname) throws Exception {
        return AgentServer.getConfig().getServiceArgs(sid, classname);
    }

    public static final String getServiceArgs(String hostname, String classname) throws Exception {
        return AgentServer.getConfig().getServiceArgsHost(hostname, classname);
    }

    private static void configure() throws Exception {
        A3CMLServer root = AgentServer.getConfig().getServer(serverId, clusterId);
        servers = new ServersHT();
        ServerDesc local = new ServerDesc(root.sid, root.name, root.hostname, -1);
        servers.put(local);
        AgentServer.getConfig().configure(root);
        AgentServer.createConsumers(root);
        Enumeration s = AgentServer.getConfig().servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            if (server.sid == root.sid) continue;
            ServerDesc desc = AgentServer.createServerDesc(server);
            AgentServer.addServerDesc(desc);
        }
        Enumeration c = AgentServer.getConfig().clusters.elements();
        while (c.hasMoreElements()) {
            A3CMLCluster cluster = (A3CMLCluster)c.nextElement();
            Enumeration s2 = cluster.servers.elements();
            while (s2.hasMoreElements()) {
                A3CMLServer server = (A3CMLServer)s2.nextElement();
                if (server.sid == root.sid) continue;
                ServerDesc desc = servers.get(server.sid);
                if (desc == null) {
                    desc = AgentServer.createServerDesc(server);
                    AgentServer.addServerDesc(desc);
                    continue;
                }
                desc.addSockAddr(server.hostname, server.port);
            }
        }
        AgentServer.initServices(root, local);
        local.setDomain(engine);
    }

    private static void createConsumers(A3CMLServer root) throws Exception {
        consumers = new Hashtable();
        engine = Engine.newInstance();
        AgentServer.addConsumer("local", engine);
        if (clusterId > -1) {
            jgroups = new JGroups();
            if (engine instanceof HAEngine) {
                jgroups.setEngine((HAEngine)engine);
                ((HAEngine)engine).setJGroups(jgroups);
            } else {
                logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", createConsumers(" + root + ")\n" + "engine [" + engine + "] is not a HAEngine"));
            }
        }
        Enumeration n = root.networks.elements();
        while (n.hasMoreElements()) {
            A3CMLNetwork network = (A3CMLNetwork)n.nextElement();
            A3CMLDomain domain = AgentServer.getConfig().getDomain(network.domain);
            try {
                Network consumer = (Network)Class.forName(domain.network).newInstance();
                consumer.init(domain.name, network.port, domain.getServersId());
                if (consumer instanceof SimpleNetwork && jgroups != null) {
                    ((SimpleNetwork)consumer).setJGroups(jgroups);
                    jgroups.setNetWork((SimpleNetwork)consumer);
                }
                AgentServer.addConsumer(network.domain, consumer);
            }
            catch (ClassNotFoundException exc) {
                throw exc;
            }
            catch (InstantiationException exc) {
                throw exc;
            }
            catch (IllegalAccessException exc) {
                throw exc;
            }
        }
    }

    public static void initServerDesc(ServerDesc desc, A3CMLServer server) throws Exception {
        desc.gateway = server.gateway;
        if (desc.gateway == -1 || desc.gateway == server.sid) {
            desc.gateway = server.sid;
            desc.updateSockAddr(desc.getHostname(), server.port);
            A3CMLServer current = AgentServer.getConfig().getServer(AgentServer.getServerId(), AgentServer.getClusterId());
            if (current.containsNat(server.sid)) {
                A3CMLNat nat = current.getNat(server.sid);
                desc.updateSockAddr(nat.host, nat.port);
                if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " : NAT sDesc = " + desc));
                }
            }
        }
        desc.setDomain(AgentServer.getConsumer(server.domain));
    }

    private static ServerDesc createServerDesc(A3CMLServer server) throws Exception {
        if (!server.visited) {
            throw new Exception(server + " inaccessible");
        }
        ServerDesc desc = new ServerDesc(server.sid, server.name, server.hostname, -1);
        AgentServer.initServerDesc(desc, server);
        AgentServer.initServices(server, desc);
        return desc;
    }

    private static void initServices(A3CMLServer server, ServerDesc desc) {
        if (server.services != null) {
            ServiceDesc[] services = new ServiceDesc[server.services.size()];
            int idx = 0;
            Enumeration x = server.services.elements();
            while (x.hasMoreElements()) {
                A3CMLService service = (A3CMLService)x.nextElement();
                services[idx++] = new ServiceDesc(service.classname, service.args);
            }
            desc.services = services;
        }
    }

    private static void setProperties(short sid, short cid) throws Exception {
        if (a3config == null) {
            return;
        }
        if (AgentServer.a3config.properties != null) {
            Enumeration e = AgentServer.a3config.properties.elements();
            while (e.hasMoreElements()) {
                A3CMLProperty p = (A3CMLProperty)e.nextElement();
                Configuration.putProperty(p.name, p.value);
                if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " : Adds global property: " + p.name + " = " + p.value));
            }
        }
        A3CMLServer server = null;
        if (cid != -1) {
            A3CMLCluster cluster = null;
            cluster = a3config.getCluster(sid);
            if (cluster != null && cluster.properties != null && cluster.properties.size() > 0) {
                Enumeration e = cluster.properties.elements();
                do {
                    A3CMLProperty p = (A3CMLProperty)e.nextElement();
                    Configuration.putProperty(p.name, p.value);
                    if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                    logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " : Adds cluster property: " + p.name + " = " + p.value));
                } while (e.hasMoreElements());
            }
            if (cluster != null) {
                server = cluster.getServer(cid);
            }
        } else {
            server = a3config.getServer(sid);
        }
        if (server != null && server.properties != null) {
            Enumeration e = server.properties.elements();
            do {
                A3CMLProperty p = (A3CMLProperty)e.nextElement();
                Configuration.putProperty(p.name, p.value);
                if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " : Adds server property: " + p.name + " = " + p.value));
            } while (e.hasMoreElements());
        }
    }

    public static int getStatus() {
        return status.value;
    }

    public static String getStatusInfo() {
        return Status.info[status.value];
    }

    public static int init(String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("usage: java <main> sid storage");
        }
        short sid = -1;
        try {
            sid = (short)Integer.parseInt(args[0]);
        }
        catch (NumberFormatException exc) {
            throw new Exception("usage: java <main> sid storage");
        }
        String path = args[1];
        short cid = -1;
        try {
            if (args.length == 3) {
                cid = (short)Integer.parseInt(args[2]);
            }
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        AgentServer.init(sid, path, null, cid);
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(boolean force) {
        if (force) {
            Status status = AgentServer.status;
            synchronized (status) {
                if (AgentServer.status.value != 6) {
                    logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", force status: " + AgentServer.getStatusInfo()));
                }
                AgentServer.status.value = 6;
            }
        }
        AgentServer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Status status = AgentServer.status;
        synchronized (status) {
            if (AgentServer.status.value != 6) {
                logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", cannot reset, bad status: " + AgentServer.getStatusInfo()));
                return;
            }
            AgentServer.status.value = 7;
        }
        Enumeration e = AgentServer.getConsumers();
        if (e != null) {
            while (e.hasMoreElements()) {
                MessageConsumer cons = (MessageConsumer)e.nextElement();
                try {
                    MXWrapper.unregisterMBean("AgentServer", "server=" + AgentServer.getName() + ",cons=" + cons.getName());
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", jmx failed: " + "server=" + AgentServer.getName() + ",cons=" + cons.getName()), (Throwable)exc);
                }
            }
            consumers = null;
        }
        try {
            MXWrapper.unregisterMBean("AgentServer", "server=" + AgentServer.getName() + ",cons=Transaction");
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", jmx failed: " + "server=" + AgentServer.getName() + ",cons=Transaction"), (Throwable)exc);
        }
        if (transaction != null) {
            transaction.close();
        }
        transaction = null;
        try {
            MXWrapper.unregisterMBean("AgentServer", "server=" + AgentServer.getName());
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " jmx failed: " + "server=" + AgentServer.getName()), (Throwable)exc);
        }
        a3config = null;
        Status status2 = AgentServer.status;
        synchronized (status2) {
            AgentServer.status.value = 0;
        }
    }

    public static void init(short sid, String path, LoggerFactory loggerFactory) throws Exception {
        AgentServer.init(sid, path, loggerFactory, (short)-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(short sid, String path, LoggerFactory loggerFactory, short cid) throws Exception {
        name = cid == -1 ? "AgentServer#" + sid : "AgentServer#" + sid + '.' + cid;
        if (loggerFactory != null) {
            Debug.setLoggerFactory(loggerFactory);
        }
        if ((logmon = Debug.getLogger(AgentServer.class.getName() + ".#" + sid)).isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", init()"), (Throwable)new Exception());
        } else {
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", init()"));
        }
        Status status = AgentServer.status;
        synchronized (status) {
            if (AgentServer.status.value == 6) {
                logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", reset configuration"));
                AgentServer.reset();
            }
            if (AgentServer.status.value != 0) {
                throw new Exception("cannot initialize, bad status: " + AgentServer.getStatusInfo());
            }
            AgentServer.status.value = 1;
        }
        try {
            int i;
            File tfc;
            serverId = sid;
            tgroup = new ThreadGroup(AgentServer.getName()){

                public void uncaughtException(Thread t, Throwable e) {
                    if (e instanceof VirtualMachineError) {
                        if (logmon.isLoggable(BasicLevel.FATAL)) {
                            logmon.log(BasicLevel.FATAL, (Object)("Abnormal termination for " + t.getThreadGroup().getName() + "." + t.getName()), e);
                            System.exit(-1);
                        }
                    } else if (logmon.isLoggable(BasicLevel.WARN)) {
                        logmon.log(BasicLevel.WARN, (Object)("Abnormal termination for " + t.getThreadGroup().getName() + "." + t.getName()), e);
                    }
                }
            };
            File dir = new File(path);
            if (dir.exists() && dir.isDirectory() && (tfc = new File(dir, "TFC")).exists()) {
                FilterInputStream dis = null;
                try {
                    dis = new DataInputStream(new FileInputStream(tfc));
                    String tname = ((DataInputStream)dis).readUTF();
                    Class<?> tclass = Class.forName(tname);
                    transaction = (Transaction)tclass.newInstance();
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't instantiate transaction manager"), (Throwable)exc);
                    throw new Exception("Can't instantiate transaction manager");
                }
                finally {
                    if (dis != null) {
                        dis.close();
                    }
                }
                try {
                    transaction.init(path);
                }
                catch (IOException exc) {
                    logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't start transaction manager"), (Throwable)exc);
                    throw new Exception("Can't start transaction manager");
                }
            }
            if (transaction != null) {
                try {
                    a3config = A3CMLConfig.load();
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", config not found"));
                }
            }
            if (a3config == null) {
                try {
                    a3config = A3CMLConfig.getConfig(DEFAULT_SER_CFG_FILE);
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", serialized a3cmlconfig not found"));
                }
                if (a3config == null) {
                    try {
                        a3config = A3CML.getXMLConfig();
                    }
                    catch (Exception exc) {
                        logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", XML configuration file not found"));
                    }
                }
                if (a3config == null) {
                    logmon.log(BasicLevel.WARN, (Object)"Generate default configuration");
                    A3CMLDomain d = new A3CMLDomain(ADMIN_DOMAIN, SimpleNetwork.class.getName());
                    A3CMLServer s = new A3CMLServer(0, ADMIN_SERVER, "localhost");
                    s.networks.addElement(new A3CMLNetwork(ADMIN_DOMAIN, 27300));
                    d.addServer(s);
                    a3config = new A3CMLConfig();
                    a3config.addDomain(d);
                    a3config.addServer(s);
                }
            }
            if (cid > -1) {
                clusterId = cid;
            }
            AgentServer.setProperties(serverId, clusterId);
            try {
                MXWrapper.init();
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.ERROR, (Object)"can't instantiate MXServer.", (Throwable)exc);
            }
            if (transaction == null) {
                try {
                    String tname = AgentServer.getProperty("Transaction", "fr.dyade.aaa.util.NTransaction");
                    transaction = (Transaction)Class.forName(tname).newInstance();
                }
                catch (Exception exc) {
                    logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't instantiate transaction manager"), (Throwable)exc);
                    throw new Exception("Can't instantiate transaction manager");
                }
                try {
                    transaction.init(path);
                }
                catch (IOException exc) {
                    logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't start transaction manager"), (Throwable)exc);
                    throw new Exception("Can't start transaction manager");
                }
            }
            try {
                MXWrapper.registerMBean(transaction, "AgentServer", "server=" + AgentServer.getName() + ",cons=Transaction");
            }
            catch (Exception exc) {
                if (logmon == null) {
                    logmon = Debug.getLogger(AgentServer.class.getName());
                }
                logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " jmx failed"), (Throwable)exc);
            }
            a3config.save();
            try {
                AgentId.init();
            }
            catch (ClassNotFoundException exc) {
                logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't initialize AgentId"), (Throwable)exc);
                throw new Exception("Can't initialize AgentId, bad classpath");
            }
            catch (IOException exc) {
                logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't initialize AgentId"), (Throwable)exc);
                throw new Exception("Can't initialize AgentId, storage problems");
            }
            try {
                AgentServer.configure();
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't configure"), (Throwable)exc);
                throw new Exception("Can't configure server");
            }
            try {
                String[] list = transaction.getList("@");
                for (i = 0; i < list.length; ++i) {
                    Message msg = Message.load(list[i]);
                    if (msg.getSource() == serverId) {
                        try {
                            AgentServer.getServerDesc(msg.getDest()).getDomain().insert(msg);
                        }
                        catch (UnknownServerException exc) {
                            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", discard message to unknown server id#" + msg.getDest()));
                            msg.delete();
                            msg.free();
                        }
                        catch (NullPointerException exc) {
                            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", discard message to unknown server id#" + msg.getDest()));
                            msg.delete();
                            msg.free();
                        }
                        catch (ArrayIndexOutOfBoundsException exc) {
                            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", discard message to unknown server id#" + msg.getDest()));
                            msg.delete();
                            msg.free();
                        }
                        continue;
                    }
                    logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + ", discard undelivered message from server id#" + msg.getDest()));
                    msg.delete();
                }
            }
            catch (ClassNotFoundException exc) {
                logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't restore messages"), (Throwable)exc);
                throw new Exception("Can't restore messages, bad classpath");
            }
            catch (IOException exc) {
                logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't restore messages"), (Throwable)exc);
                throw new Exception("Can't restore messages, storage problems");
            }
            Channel.newInstance();
            try {
                ServiceManager.init();
                logmon.log(BasicLevel.INFO, (Object)(AgentServer.getName() + ", ServiceManager initialized"));
                ServiceDesc[] services = AgentServer.getServices();
                if (services != null) {
                    for (i = 0; i < services.length; ++i) {
                        ServiceManager.register(services[i].getClassName(), services[i].getArguments());
                    }
                }
                ServiceManager.save();
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't initialize services"), (Throwable)exc);
                throw new Exception("Can't initialize services");
            }
            engine.init();
            if (jgroups != null) {
                jgroups.init(sid);
            }
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", initialized at " + new Date()));
            transaction.begin();
            transaction.commit(true);
            try {
                SCServer bean = new SCServer();
                MXWrapper.registerMBean(bean, "AgentServer", "server=" + AgentServer.getName());
            }
            catch (Exception exc) {
                if (logmon == null) {
                    logmon = Debug.getLogger(AgentServer.class.getName());
                }
                logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " jmx failed"), (Throwable)exc);
            }
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + "Cannot initialize"), (Throwable)exc);
            Status status2 = AgentServer.status;
            synchronized (status2) {
                AgentServer.status.value = 0;
            }
            throw exc;
        }
        catch (Throwable t) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + "Cannot initialize"), t);
            Status status3 = AgentServer.status;
            synchronized (status3) {
                AgentServer.status.value = 0;
            }
            throw new Exception(t.getMessage());
        }
        status = AgentServer.status;
        synchronized (status) {
            AgentServer.status.value = 2;
        }
    }

    static String startConsumers() throws Exception {
        StringBuffer errBuf = null;
        if (consumers != null) {
            Enumeration c = AgentServer.getConsumers();
            while (c.hasMoreElements()) {
                MessageConsumer cons = (MessageConsumer)c.nextElement();
                if (cons == null) continue;
                try {
                    if (cons instanceof Engine) continue;
                    cons.start();
                }
                catch (IOException exc) {
                    if (errBuf == null) {
                        errBuf = new StringBuffer();
                    }
                    errBuf.append(cons.getName()).append(": ");
                    errBuf.append(exc.getMessage()).append('\n');
                    logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", problem during " + cons.getName() + " starting"), (Throwable)exc);
                }
            }
        }
        if (errBuf == null) {
            return null;
        }
        return errBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String start() throws Exception {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", start()"), (Throwable)new Exception());
        } else {
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", start()"));
        }
        Status status = AgentServer.status;
        synchronized (status) {
            if (AgentServer.status.value != 2 && AgentServer.status.value != 6) {
                throw new Exception("cannot start, bad status: " + AgentServer.getStatusInfo());
            }
            AgentServer.status.value = 3;
        }
        StringBuffer errBuf = null;
        try {
            try {
                if (jgroups == null) {
                    ServiceManager.start();
                    ServiceManager.save();
                    logmon.log(BasicLevel.INFO, (Object)(AgentServer.getName() + ", ServiceManager started"));
                }
            }
            catch (Exception exc) {
                logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", can't initialize services"), (Throwable)exc);
                throw new Exception("Can't initialize services");
            }
            if (consumers != null) {
                Enumeration c = AgentServer.getConsumers();
                while (c.hasMoreElements()) {
                    MessageConsumer cons = (MessageConsumer)c.nextElement();
                    if (cons == null) continue;
                    try {
                        if (jgroups != null && !(cons instanceof Engine)) continue;
                        cons.start();
                    }
                    catch (IOException exc) {
                        if (errBuf == null) {
                            errBuf = new StringBuffer();
                        }
                        errBuf.append(cons.getName()).append(": ");
                        errBuf.append(exc.getMessage()).append('\n');
                        logmon.log(BasicLevel.FATAL, (Object)(AgentServer.getName() + ", problem during " + cons.getName() + " starting"), (Throwable)exc);
                    }
                }
            }
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", started at " + new Date()));
            transaction.begin();
            transaction.commit(true);
        }
        catch (Exception exc) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + "Cannot start"), (Throwable)exc);
            Status status2 = AgentServer.status;
            synchronized (status2) {
                AgentServer.status.value = 6;
            }
            throw exc;
        }
        catch (Throwable t) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + "Cannot start"), t);
            Status status3 = AgentServer.status;
            synchronized (status3) {
                AgentServer.status.value = 6;
            }
            throw new Exception(t.getMessage());
        }
        Status status4 = AgentServer.status;
        synchronized (status4) {
            AgentServer.status.value = 4;
        }
        if (errBuf == null) {
            return null;
        }
        return errBuf.toString();
    }

    public static void stop(boolean sync) {
        AgentServer.stop(sync, 0L, false);
    }

    public static void stop(boolean sync, long delay, boolean reset) {
        ServerStopper stopper = new ServerStopper(delay, reset);
        if (sync) {
            stopper.run();
        } else {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", stop()"), (Throwable)new Exception());
            }
            Thread t = new Thread(stopper);
            t.setDaemon(false);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", stop()"), (Throwable)new Exception());
        } else {
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", stop()"));
        }
        Status status = AgentServer.status;
        synchronized (status) {
            if (AgentServer.status.value != 4 && AgentServer.status.value != 6) {
                logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + "cannot stop, bad status: " + AgentServer.getStatusInfo()));
                return;
            }
            AgentServer.status.value = 5;
        }
        try {
            int nbt;
            if (timer != null) {
                timer.cancel();
            }
            timer = null;
            if (jgroups != null) {
                jgroups.disconnect();
            }
            if (consumers != null) {
                Enumeration c = AgentServer.getConsumers();
                while (c.hasMoreElements()) {
                    MessageConsumer cons = (MessageConsumer)c.nextElement();
                    if (cons == null) continue;
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", stop " + cons.getName()));
                    }
                    cons.stop();
                    if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                    logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", " + cons.getName() + " stopped"));
                }
            }
            ServiceManager.stop();
            while ((nbt = AgentServer.getThreadGroup().activeCount()) != 0) {
                Thread[] tab = new Thread[nbt];
                AgentServer.getThreadGroup().enumerate(tab);
                if (nbt == 1 && tab[0] == Thread.currentThread()) break;
                for (int j = 0; j < tab.length; ++j) {
                    logmon.log(BasicLevel.DEBUG, (Object)("[" + tab[j].getName() + ":" + (tab[j].isAlive() ? "alive" : "-") + "/" + (tab[j].isDaemon() ? "daemon" : "-") + "," + tab[j]));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (transaction != null) {
                transaction.stop();
            }
            Runtime.getRuntime().gc();
            System.runFinalization();
            logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + ", stopped at " + new Date()));
        }
        catch (Throwable t) {
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + "Cannot stop"), t);
            Status status2 = AgentServer.status;
            synchronized (status2) {
                AgentServer.status.value = 6;
            }
        }
        Status status3 = AgentServer.status;
        synchronized (status3) {
            AgentServer.status.value = 6;
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            AgentServer.init(args);
        }
        catch (Throwable exc) {
            System.out.println(AgentServer.getName() + "initialization failed: " + ERRORSTRING);
            System.out.println(exc.toString());
            System.out.println(ENDSTRING);
            if (logmon == null) {
                logmon = Debug.getLogger(AgentServer.class.getName());
            }
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " initialization failed"), exc);
            System.exit(1);
        }
        try {
            String errStr = AgentServer.start();
            if (errStr == null) {
                System.out.println(AgentServer.getName() + " started: " + OKSTRING);
            } else {
                System.out.println(AgentServer.getName() + " started: " + ERRORSTRING);
                System.out.print(errStr);
                System.out.println(ENDSTRING);
            }
        }
        catch (Throwable exc) {
            System.out.println(AgentServer.getName() + " start failed: " + ERRORSTRING);
            System.out.print(exc.toString());
            System.out.println(ENDSTRING);
            if (logmon == null) {
                logmon = Debug.getLogger(AgentServer.class.getName());
            }
            logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " failed"), exc);
            System.exit(1);
        }
    }

    static {
        a3config = null;
        name = null;
        resolverRepo = null;
        servers = null;
        status = new Status();
    }

    static class ServerStopper
    implements Runnable {
        private long delay;
        private boolean reset;

        ServerStopper(long delay, boolean reset) {
            this.delay = delay;
            this.reset = reset;
        }

        public void run() {
            if (this.delay > 0L) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AgentServer.stop();
            if (this.reset) {
                AgentServer.reset();
            }
        }
    }

    public static class Status {
        public static final int INSTALLED = 0;
        public static final int INITIALIZING = 1;
        public static final int INITIALIZED = 2;
        public static final int STARTING = 3;
        public static final int STARTED = 4;
        public static final int STOPPING = 5;
        public static final int STOPPED = 6;
        public static final int RESETING = 7;
        private int value = 0;
        public static String[] info = new String[]{"installed", "initializing", "initialized", "starting", "started", "stopping", "stopped", "reseting"};
    }
}

