/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.local;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Date;
import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.local.LocalRequestChannelMBean;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.mom.proxies.local.LocalConnections;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class LocalRequestChannel
implements RequestChannel,
LocalRequestChannelMBean {
    public static Logger logger = Debug.getLogger(LocalRequestChannel.class.getName());
    private Identity identity;
    private AgentId proxyId;
    private StandardConnectionContext ctx;
    private Date creationDate;
    private long sentCount;
    private long receivedCount;

    public LocalRequestChannel(Identity identity) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("LocalConnection.<init>(" + identity + ')'));
        }
        this.identity = identity;
    }

    public void setTimer(Timer timer) {
    }

    public void connect() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"LocalConnection.connect()");
        }
        if (!LocalConnections.getCurrentInstance().isActivated()) {
            throw new IllegalStateException("Local connections have been deactivated.");
        }
        if (AgentServer.getStatus() != 4) {
            if (AgentServer.getStatus() != 2 && AgentServer.getStatus() != 6) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)("LocalConnection.connect(), server is not initialized: " + AgentServer.getStatusInfo() + '.'));
                }
                throw new Exception();
            }
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)("LocalConnection.connect(), server is not started: " + AgentServer.getStatusInfo() + '.'));
            }
        }
        GetProxyIdNot gpin = new GetProxyIdNot(this.identity, null);
        try {
            gpin.invoke(AdminTopic.getDefault());
            this.proxyId = gpin.getProxyId();
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            throw new JMSException(exc.getMessage());
        }
        OpenConnectionNot ocn = new OpenConnectionNot(false, 0);
        try {
            ocn.invoke(this.proxyId);
            this.ctx = (StandardConnectionContext)ocn.getConnectionContext();
            this.creationDate = new Date();
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            JMSException jmse = new JMSException(exc.getMessage());
            jmse.setLinkedException(exc);
            throw jmse;
        }
        LocalConnections.getCurrentInstance().addLocalConnection(this);
        try {
            MXWrapper.registerMBean(this, "Joram#" + AgentServer.getServerId(), this.getMBeanName());
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)"registerMBean", (Throwable)e);
        }
    }

    private String getMBeanName() {
        return "type=Connection,mode=local,id=" + this.identity.getUserName() + "[" + this.ctx.getKey() + "]";
    }

    public void send(AbstractJmsRequest request) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("LocalConnection.send(" + request + ')'));
        }
        ConnectionManager.sendToProxy(this.proxyId, this.ctx.getKey(), request, request);
        ++this.sentCount;
    }

    public AbstractJmsReply receive() throws Exception {
        AbstractJmsReply reply = (AbstractJmsReply)this.ctx.getQueue().get();
        this.ctx.getQueue().pop();
        ++this.receivedCount;
        return reply;
    }

    public void close() {
        this.ctx.getQueue().close();
        LocalConnections.getCurrentInstance().removeLocalConnection(this);
        try {
            MXWrapper.unregisterMBean("Joram#" + AgentServer.getServerId(), this.getMBeanName());
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)"unregisterMBean", (Throwable)e);
        }
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public long getReceivedCount() {
        return this.receivedCount;
    }

    public long getSentCount() {
        return this.sentCount;
    }

    public String getUserName() {
        return this.identity.getUserName();
    }

    public void closing() {
    }
}

