/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.AbsArchive;

public class JarArchive
extends AbsArchive {
    private JarFile jar;

    public JarArchive(File jar) throws GenBaseException {
        super(jar);
        try {
            this.jar = new JarFile(jar);
            this.setManifest(this.jar.getManifest());
        }
        catch (IOException ioe) {
            String err = JarArchive.getI18n().getMessage("JarArchive.constr.jar", (Object)jar);
            throw new GenBaseException(err, ioe);
        }
    }

    public InputStream getInputStream(String filename) throws IOException {
        File file = (File)this.getFiles().get(filename);
        if (file == null) {
            ZipEntry ze = this.jar.getEntry(filename);
            if (ze == null) {
                return null;
            }
            return this.jar.getInputStream(ze);
        }
        return new FileInputStream(file);
    }

    public List getContainedFiles() {
        Vector list = new Vector(this.getFiles().keySet());
        Enumeration<JarEntry> e = this.jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            list.add(ze.getName());
        }
        return list;
    }

    public boolean isPacked() {
        return true;
    }

    public void close() {
        super.close();
        try {
            this.jar.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot close file '" + this.jar + "'", ioe);
        }
        this.jar = null;
    }
}

