/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web.xml;

import org.ow2.jonas.deployment.common.xml.AbsEnvironmentElement;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.JndiEnvRefsGroupXml;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.common.xml.TopLevelElement;
import org.ow2.jonas.deployment.web.xml.SecurityConstraint;
import org.ow2.jonas.deployment.web.xml.Servlet;
import org.ow2.jonas.deployment.web.xml.ServletMapping;

public class WebApp
extends AbsEnvironmentElement
implements TopLevelElement,
JndiEnvRefsGroupXml {
    private JLinkedList servletList = new JLinkedList("servlet");
    private JLinkedList servletMappingList = new JLinkedList("servlet-mapping");
    private JLinkedList securityConstraintList = new JLinkedList("security-constraint");
    private JLinkedList securityRoleList = new JLinkedList("security-role");
    private int jspConfigNumber = 0;
    private int loginConfigNumber = 0;
    private int sessionConfigNumber = 0;

    public void addServlet(Servlet servlet) {
        this.servletList.add(servlet);
    }

    public void addServletMapping(ServletMapping servletMapping) {
        this.servletMappingList.add(servletMapping);
    }

    public void setSecurityRoleList(JLinkedList securityRoleList) {
        this.securityRoleList = securityRoleList;
    }

    public void addSecurityRole(SecurityRole securityRole) {
        this.securityRoleList.add(securityRole);
    }

    public void setSecurityConstraintList(JLinkedList securityConstraintList) {
        this.securityConstraintList = securityConstraintList;
    }

    public void addSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraintList.add(securityConstraint);
    }

    public JLinkedList getSecurityConstraintList() {
        return this.securityConstraintList;
    }

    public JLinkedList getSecurityRoleList() {
        return this.securityRoleList;
    }

    public JLinkedList getServletList() {
        return this.servletList;
    }

    public JLinkedList getServletMappingList() {
        return this.servletMappingList;
    }

    public void newJspConfig() {
        ++this.jspConfigNumber;
    }

    public void newLoginConfig() {
        ++this.loginConfigNumber;
    }

    public void newSessionConfig() {
        ++this.sessionConfigNumber;
    }

    public String toXML(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(indent));
        sb.append("<web-app>\n");
        sb.append(this.xmlElement(this.getDisplayName(), "display-name", indent += 2));
        sb.append(this.servletList.toXML(indent));
        sb.append(this.servletMappingList.toXML(indent));
        sb.append(this.securityConstraintList.toXML(indent));
        sb.append(this.securityRoleList.toXML(indent));
        sb.append(this.getResourceEnvRefList().toXML(indent));
        sb.append(this.getResourceRefList().toXML(indent));
        sb.append(this.getEnvEntryList().toXML(indent));
        sb.append(this.getEjbRefList().toXML(indent));
        sb.append(this.getEjbLocalRefList().toXML(indent));
        sb.append(this.getServiceRefList().toXML(indent));
        sb.append(this.getMessageDestinationRefList().toXML(indent));
        sb.append(this.indent(indent -= 2));
        sb.append("</web-app>");
        return sb.toString();
    }

    public int getJspConfigNumber() {
        return this.jspConfigNumber;
    }

    public int getLoginConfigNumber() {
        return this.loginConfigNumber;
    }

    public int getSessionConfigNumber() {
        return this.sessionConfigNumber;
    }
}

