/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic;

import java.math.BigInteger;
import org.ow2.jonas.lib.ejb21.JavaType;

public class VcParamWhere {
    private String mName;
    private String mTypeName;
    private String mSqlTypeName;
    private String mSqlSetMethod;
    private boolean hasNotPrimitiveType;
    private boolean hasBigIntegerType;
    private boolean hasSerializableType;
    private boolean hasJavaLangTypeExceptString;

    VcParamWhere(Class type, int position) {
        this.mName = new String("p" + position);
        this.mTypeName = JavaType.getName((Class)type);
        this.mSqlTypeName = JavaType.getSQLType((Class)type);
        this.mSqlSetMethod = JavaType.getSQLSetMethod((Class)type);
        if (this.mSqlSetMethod == null) {
            throw new Error("Cannot container persistence manage the type '" + type.getName() + "'");
        }
        this.hasNotPrimitiveType = !type.isPrimitive();
        this.hasBigIntegerType = type.equals(BigInteger.class);
        this.hasSerializableType = "setSerializable".equals(this.mSqlSetMethod);
        this.hasJavaLangTypeExceptString = false;
        if (type.getPackage() != null && "java.lang".equals(type.getPackage().getName()) && !String.class.equals((Object)type)) {
            this.hasJavaLangTypeExceptString = true;
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public String getSqlTypeName() {
        return this.mSqlTypeName;
    }

    public String getSqlSetMethod() {
        return this.mSqlSetMethod;
    }

    public boolean hasNotPrimitiveType() {
        return this.hasNotPrimitiveType;
    }

    public boolean hasBigIntegerType() {
        return this.hasBigIntegerType;
    }

    public boolean hasSerializableType() {
        return this.hasSerializableType;
    }

    public boolean hasJavaLangTypeExceptString() {
        return this.hasJavaLangTypeExceptString;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n    Name                 = " + this.getName());
        ret.append("\n    TypeName             = " + this.getTypeName());
        ret.append("\n    SqlTypeName          = " + this.getSqlTypeName());
        ret.append("\n    SqlSetMethod         = " + this.getSqlSetMethod());
        ret.append("\n    hasNotPrimitiveType  = " + this.hasNotPrimitiveType());
        ret.append("\n    hasBigIntegerType    = " + this.hasBigIntegerType());
        ret.append("\n    hasSerializableType  = " + this.hasSerializableType());
        ret.append("\n    hasJavaLangTypeExceptString = " + this.hasJavaLangTypeExceptString());
        return ret.toString();
    }
}

