/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.DepthXMLStreamReader;

public class FragmentStreamReader
extends DepthXMLStreamReader {
    private boolean startDoc;
    private boolean startElement;
    private boolean middle = true;
    private boolean endDoc;
    private int depth;
    private int current = -1;
    private boolean filter = true;
    private boolean advanceAtEnd = true;

    public FragmentStreamReader(XMLStreamReader reader) {
        super(reader);
    }

    public int getEventType() {
        return this.current;
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.startDoc) {
            return true;
        }
        if (this.endDoc) {
            return false;
        }
        return this.reader.hasNext();
    }

    public int next() throws XMLStreamException {
        if (!this.startDoc) {
            this.startDoc = true;
            this.current = 7;
        } else if (!this.startElement) {
            this.depth = this.getDepth();
            this.current = this.reader.getEventType();
            if (this.filter) {
                while (this.current != 1 && this.depth >= this.getDepth() && super.hasNext()) {
                    this.current = super.next();
                }
                this.filter = false;
            }
            this.startElement = true;
            this.current = 1;
        } else if (this.middle) {
            this.current = super.next();
            if (this.current == 2 && this.getDepth() < this.depth) {
                this.middle = false;
            }
        } else if (!this.endDoc) {
            if (this.advanceAtEnd) {
                super.next();
            }
            this.endDoc = true;
            this.current = 8;
        } else {
            throw new XMLStreamException("Already at the end of the document.");
        }
        return this.current;
    }

    public boolean isAdvanceAtEnd() {
        return this.advanceAtEnd;
    }

    public void setAdvanceAtEnd(boolean a) {
        this.advanceAtEnd = a;
    }
}

