/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.Serializable;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;

public class ImRPOAInfo
implements Serializable {
    protected int port;
    protected ImRServerInfo server;
    protected String host;
    protected String name;
    protected boolean active;
    protected long timeout;

    public ImRPOAInfo(String string, String string2, int n, ImRServerInfo imRServerInfo, long l) throws IllegalPOAName {
        if (string == null || string.length() == 0) {
            throw new IllegalPOAName(string);
        }
        this.name = string;
        this.host = string2;
        this.port = n;
        this.server = imRServerInfo;
        this.active = true;
        this.timeout = l;
    }

    public POAInfo toPOAInfo() {
        return new POAInfo(this.name, this.host, this.port, this.server.name, this.active);
    }

    public synchronized void reactivate(String string, int n) {
        this.host = string;
        this.port = n;
        this.active = true;
        this.server.active = true;
        this.server.restarting = false;
        this.notifyAll();
    }

    public synchronized boolean awaitActivation() {
        while (!this.active) {
            try {
                long l = System.currentTimeMillis();
                this.wait(this.timeout);
                if (this.active || System.currentTimeMillis() - l <= this.timeout) continue;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }
}

