/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.management.ObjectName;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminWrapper;
import org.objectweb.joram.client.jms.admin.JoramAdminMBean;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JoramAdmin
implements JoramAdminMBean {
    public static Logger logger = Debug.getLogger(JoramAdmin.class.getName());
    public AdminWrapper wrapper = null;
    protected transient String JMXBaseName = null;

    public JoramAdmin(Connection cnx) throws ConnectException, AdminException, JMSException {
        this(cnx, "JoramClient");
    }

    public JoramAdmin(Connection cnx, String base) throws ConnectException, AdminException, JMSException {
        this.wrapper = new AdminWrapper(cnx);
        this.registerMBean(base);
    }

    public void exit() {
        block5: {
            try {
                String name;
                Iterator mbeans = MXWrapper.queryNames(new ObjectName(this.JMXBaseName + ":type=User,location=*,name=*")).iterator();
                while (mbeans.hasNext()) {
                    name = ((ObjectName)mbeans.next()).getCanonicalName();
                    System.out.println("unregisterMBean: " + name);
                    MXWrapper.unregisterMBean(name);
                }
                mbeans = MXWrapper.queryNames(new ObjectName(this.JMXBaseName + ":type=Queue,location=*,name=*")).iterator();
                while (mbeans.hasNext()) {
                    name = ((ObjectName)mbeans.next()).getCanonicalName();
                    System.out.println("unregisterMBean: " + name);
                    MXWrapper.unregisterMBean(name);
                }
                mbeans = MXWrapper.queryNames(new ObjectName(this.JMXBaseName + ":type=Topic,location=*,name=*")).iterator();
                while (mbeans.hasNext()) {
                    name = ((ObjectName)mbeans.next()).getCanonicalName();
                    System.out.println("unregisterMBean: " + name);
                    MXWrapper.unregisterMBean(name);
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block5;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.unregisterMBean", (Throwable)exc);
            }
        }
        this.unregisterMBean();
        this.wrapper.close();
    }

    public void setTimeOutToAbortRequest(long timeOut) throws ConnectException {
        this.wrapper.setTimeOutToAbortRequest(timeOut);
    }

    public long getTimeOutToAbortRequest() throws ConnectException {
        return this.wrapper.getTimeOutToAbortRequest();
    }

    public void stopServer() throws ConnectException, AdminException {
        this.wrapper.stopServer();
    }

    public void stopServer(int serverId) throws ConnectException, AdminException {
        this.wrapper.stopServer(serverId);
    }

    public void addServer(int sid, String host, String domain, int port, String server) throws ConnectException, AdminException {
        this.wrapper.addServer(sid, host, domain, port, server);
    }

    public void removeServer(int sid) throws ConnectException, AdminException {
        this.wrapper.removeServer(sid);
    }

    public void addDomain(String domain, int sid, int port) throws ConnectException, AdminException {
        this.wrapper.addDomain(domain, sid, port);
    }

    public void addDomain(String domain, String network, int sid, int port) throws ConnectException, AdminException {
        this.wrapper.addDomain(domain, network, sid, port);
    }

    public void removeDomain(String domain) throws ConnectException, AdminException {
        this.wrapper.removeDomain(domain);
    }

    public String getConfiguration() throws ConnectException, AdminException {
        return this.wrapper.getConfiguration();
    }

    public int[] getServersIds() throws ConnectException, AdminException {
        return this.wrapper.getServersIds();
    }

    public int[] getServersIds(String domain) throws ConnectException, AdminException {
        return this.wrapper.getServersIds(domain);
    }

    public String[] getDomainNames(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getDomainNames(serverId);
    }

    public String getDefaultDMQId() throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQId();
    }

    public String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQId(serverId);
    }

    public void setDefaultDMQId(String dmqId) throws ConnectException, AdminException {
        this.wrapper.setDefaultDMQId(dmqId);
    }

    public void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        this.wrapper.setDefaultDMQId(serverId, dmqId);
    }

    public void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        this.wrapper.setDefaultThreshold(threshold);
    }

    public void setDefaultThreshold(int serverId, int threshold) throws ConnectException, AdminException {
        this.wrapper.setDefaultThreshold(serverId, threshold);
    }

    public int getDefaultThreshold() throws ConnectException, AdminException {
        return this.wrapper.getDefaultThreshold();
    }

    public int getDefaultThreshold(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getDefaultThreshold(serverId);
    }

    public void getDestinations() throws ConnectException, AdminException {
        this.wrapDestinations(this.wrapper.getDestinations());
    }

    public void getDestinations(int serverId) throws ConnectException, AdminException {
        this.wrapDestinations(this.wrapper.getDestinations(serverId));
    }

    private final void wrapDestinations(Destination[] destinations) {
        if (destinations == null) {
            return;
        }
        for (int i = 0; i < destinations.length; ++i) {
            this.wrapDestination(destinations[i]);
        }
    }

    public void createQueue(String name) throws AdminException, ConnectException {
        this.createQueue(this.wrapper.getLocalServerId(), name);
    }

    public void createQueue(int serverId, String name) throws AdminException, ConnectException {
        this.wrapDestination(this.wrapper.createQueue(serverId, name));
    }

    public void createTopic(String name) throws AdminException, ConnectException {
        this.createTopic(this.wrapper.getLocalServerId(), name);
    }

    public void createTopic(int serverId, String name) throws AdminException, ConnectException {
        this.wrapDestination(this.wrapper.createTopic(serverId, name));
    }

    private final void wrapDestination(Destination destination) {
        if (destination == null) {
            return;
        }
        destination.setWrapper(this.wrapper);
        destination.registerMBean(this.JMXBaseName);
    }

    public void getUsers() throws ConnectException, AdminException {
        this.getUsers(this.wrapper.getLocalServerId());
    }

    public void getUsers(int serverId) throws ConnectException, AdminException {
        this.wrapUsers(this.wrapper.getUsers(serverId));
    }

    private final void wrapUsers(User[] users) {
        if (users == null) {
            return;
        }
        for (int i = 0; i < users.length; ++i) {
            this.wrapUser(users[i]);
        }
    }

    public void createUser(String name, String password) throws AdminException, ConnectException {
        this.wrapUser(this.wrapper.createUser(name, password));
    }

    public void createUser(String name, String password, String identityClass) throws AdminException, ConnectException {
        this.wrapUser(this.wrapper.createUser(name, password, identityClass));
    }

    public void createUser(String name, String password, int serverId) throws AdminException, ConnectException {
        this.wrapUser(this.wrapper.createUser(name, password, serverId));
    }

    public void createUser(String name, String password, int serverId, String identityClass) throws ConnectException, AdminException {
        this.wrapUser(this.wrapper.createUser(name, password, serverId, identityClass));
    }

    private final void wrapUser(User user) {
        if (user == null) {
            return;
        }
        user.setWrapper(this.wrapper);
        user.registerMBean(this.JMXBaseName);
    }

    public void registerMBean(String base) {
        block3: {
            if (MXWrapper.mxserver == null) {
                return;
            }
            this.JMXBaseName = base;
            try {
                MXWrapper.registerMBean(this, this.JMXBaseName, "type=JoramAdmin");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.registerMBean", (Throwable)e);
            }
        }
    }

    public void unregisterMBean() {
        block2: {
            try {
                MXWrapper.unregisterMBean(this.JMXBaseName, "type=JoramAdmin");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.unregisterMBean", (Throwable)e);
            }
        }
    }

    public static JoramAdmin doCreate(AbstractConnectionFactory cf, String name, String password, String identityClass) throws ConnectException, AdminException {
        Connection cnx = null;
        cf.setIdentityClassName(identityClass);
        try {
            cnx = cf.createConnection(name, password);
            cnx.start();
            return new JoramAdmin(cnx);
        }
        catch (JMSSecurityException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin - error during creation", (Throwable)exc);
            }
            throw new AdminException(exc.getMessage());
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin - error during creation", (Throwable)exc);
            }
            throw new ConnectException("Connecting failed: " + (Object)((Object)exc));
        }
    }

    public void executeXMLAdmin(String cfgDir, String cfgFileName) throws Exception {
        AdminModule.executeXMLAdmin(cfgDir, cfgFileName);
    }

    public void executeXMLAdmin(String path) throws Exception {
        AdminModule.executeXMLAdmin(path);
    }

    public void exportRepositoryToFile(String exportDir, String exportFilename) throws AdminException {
        AdminModule.exportRepositoryToFile(exportDir, exportFilename);
    }
}

