/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLNameIdentifier
extends SAMLObject
implements Cloneable {
    protected String name = null;
    protected String nameQualifier = null;
    protected String format = null;
    public static final String FORMAT_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    public static final String FORMAT_EMAIL = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    public static final String FORMAT_X509 = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    public static final String FORMAT_WINDOWS = "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";

    public SAMLNameIdentifier() {
    }

    public SAMLNameIdentifier(String string, String string2, String string3) throws SAMLException {
        this.name = string;
        this.nameQualifier = string2;
        this.format = string3;
    }

    public SAMLNameIdentifier(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLNameIdentifier(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLNameIdentifier.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier")) {
            throw new MalformedException("SAMLNameIdentifier.fromDOM() requires saml:NameIdentifier at root");
        }
        this.nameQualifier = element.getAttributeNS(null, "NameQualifier");
        this.format = element.getAttributeNS(null, "Format");
        this.name = element.getFirstChild().getNodeValue();
        this.checkValidity();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (this.root != null) {
            this.root.getFirstChild().setNodeValue(string);
        }
        this.name = string;
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public void setNameQualifier(String string) {
        this.nameQualifier = string;
        if (this.root != null) {
            ((Element)this.root).removeAttributeNS(null, "NameQualifier");
            if (!XML.isEmpty(string)) {
                ((Element)this.root).setAttributeNS(null, "NameQualifier", string);
            }
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
        if (this.root != null) {
            ((Element)this.root).removeAttributeNS(null, "Format");
            if (!XML.isEmpty(string)) {
                ((Element)this.root).setAttributeNS(null, "Format", string);
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
        if (!XML.isEmpty(this.nameQualifier)) {
            element.setAttributeNS(null, "NameQualifier", this.nameQualifier);
        }
        if (!XML.isEmpty(this.format)) {
            element.setAttributeNS(null, "Format", this.format);
        }
        element.appendChild(document.createTextNode(this.name));
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name)) {
            throw new MalformedException("NameIdentifier is invalid, requires name");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return (SAMLNameIdentifier)super.clone();
    }
}

