/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.io.File;
import java.rmi.Remote;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.frontend.AbstractServiceFactory;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingConfiguration;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;

public class JaxwsServiceBuilder
extends AbstractServiceFactory {
    final JaxWsServiceFactoryBean serviceFactory = new JaxWsServiceFactoryBean();

    public JaxwsServiceBuilder() {
        this.serviceFactory.setPopulateFromClass(true);
        this.setServiceFactory(this.serviceFactory);
        this.setBindingConfig(new JaxWsSoapBindingConfiguration(this.serviceFactory));
    }

    public void validate() {
        Class clz = this.getServiceClass();
        if (Remote.class.isAssignableFrom(clz)) {
            throw new RuntimeException("JAXWS SEIs may not implement the java.rmi.Remote interface.");
        }
    }

    public File getOutputFile() {
        JaxWsImplementorInfo jaxwsImpl = this.serviceFactory.getJaxWsImplementorInfo();
        String wsdlLocation = jaxwsImpl.getWsdlLocation();
        if (!StringUtils.isEmpty(wsdlLocation)) {
            return new File(wsdlLocation);
        }
        return super.getOutputFile();
    }
}

