/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.reader.plan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlan;
import org.ow2.util.plan.bindings.deploymentplan.maven2.ObjectFactory;
import org.ow2.util.plan.reader.AbsReader;
import org.ow2.util.plan.reader.ReaderException;
import org.ow2.util.plan.reader.plan.IPlanReader;
import org.xml.sax.InputSource;

public class PlanReaderImpl
extends AbsReader
implements IPlanReader {
    private static final String DEPLOYMENT_PLAN_XSD = "deployment-plan-1.0.xsd";
    private static final String MAVEN2_DEPLOYMENT_PLAN_XSD = "maven2-deployment-plan-1.0.xsd";
    private static final String URL_DEPLOYMENT_PLAN_XSD = "url-deployment-plan-1.0.xsd";
    private static final String OBR_DEPLOYMENT_PLAN_XSD = "obr-deployment-plan-1.0.xsd";
    private static final Class[] PLAN_CLASSES = new Class[]{org.ow2.util.plan.bindings.deploymentplan.ObjectFactory.class, ObjectFactory.class, org.ow2.util.plan.bindings.deploymentplan.obr.ObjectFactory.class, org.ow2.util.plan.bindings.deploymentplan.url.ObjectFactory.class};

    protected void initUnmarshallClasses() {
        this.unmarshallClasses = PLAN_CLASSES;
    }

    public synchronized DeploymentPlan readPlan(File file) throws IOException, ReaderException {
        JAXBElement jaxbElement = null;
        try {
            jaxbElement = this.getRootElement(file);
        }
        catch (JAXBException e) {
            throw new ReaderException("Unable to parse the file '" + file + "'", e);
        }
        Object elementValue = jaxbElement.getValue();
        if (elementValue instanceof DeploymentPlan) {
            return (DeploymentPlan)elementValue;
        }
        throw new ReaderException("Bad root element");
    }

    protected void buildUnmarshallerSchema() throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream planSchemaStream = this.schemaStreamFactory.getSchemaStream(DEPLOYMENT_PLAN_XSD);
        InputStream m2SchemaStream = this.schemaStreamFactory.getSchemaStream(MAVEN2_DEPLOYMENT_PLAN_XSD);
        InputStream urlSchemaStream = this.schemaStreamFactory.getSchemaStream(URL_DEPLOYMENT_PLAN_XSD);
        InputStream obrSchemaStream = this.schemaStreamFactory.getSchemaStream(OBR_DEPLOYMENT_PLAN_XSD);
        SAXSource planSchemaSource = new SAXSource(new InputSource(planSchemaStream));
        SAXSource m2SchemaSource = new SAXSource(new InputSource(m2SchemaStream));
        SAXSource urlSchemaSource = new SAXSource(new InputSource(urlSchemaStream));
        SAXSource obrSchemaSource = new SAXSource(new InputSource(obrSchemaStream));
        Source[] sources = new Source[]{planSchemaSource, m2SchemaSource, urlSchemaSource, obrSchemaSource};
        this.unmarshallerSchema = sf.newSchema(sources);
    }
}

