/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp2Desc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.generators.genic.GenICException;
import org.ow2.jonas.generators.genic.VContextFactory;
import org.ow2.jonas.lib.util.Log;

class Source {
    static final int HOME = 0;
    static final int LOCAL_HOME = 1;
    static final int REMOTE = 2;
    static final int LOCAL = 3;
    static final int ENTITY_HANDLE = 4;
    static final int ENTITY_CMP_JDBC = 5;
    static final int ITF_COH_CMP2_ENTITY = 7;
    static final int SERVICE_ENDPOINT = 9;
    static final int SERVICE_ENDPOINT_HOME = 10;
    private BeanDesc dd = null;
    private String srcFileName = null;
    private int srcType;
    private VelocityEngine vEngine = null;
    private VelocityContext vctx = null;
    private Logger logger = null;

    Source(BeanDesc beanDesc, String fileName, int type, VelocityEngine ve, Manager mgr) throws GenICException {
        this.dd = beanDesc;
        this.srcFileName = fileName;
        this.srcType = type;
        this.vctx = VContextFactory.create(this.dd, this.srcType, mgr);
        this.vEngine = ve;
        this.logger = Log.getLogger((String)"org.ow2.jonas.generators.genic");
        Logger vLogger = Log.getLogger((String)"org.ow2.jonas.generators.genic.velocity");
        if (vLogger.getCurrentIntLevel() == BasicLevel.DEBUG) {
            vLogger.log(BasicLevel.DEBUG, (Object)("Source(..,fileName=" + fileName + ", type = " + type + ", ..)"));
            vLogger.log(BasicLevel.DEBUG, (Object)("VELOCITY CONTEXT = \n(" + VContextFactory.toString(this.vctx) + "\n)"));
        }
    }

    void generate() throws GenICException {
        String tmplName = null;
        Template tmpl = null;
        FileWriter fwriter = null;
        switch (this.srcType) {
            case 0: {
                if (this.dd instanceof EntityDesc) {
                    tmplName = "JEntityHome.vm";
                    break;
                }
                if (this.dd instanceof SessionStatefulDesc) {
                    tmplName = "JStatefulHome.vm";
                    break;
                }
                if (!(this.dd instanceof SessionStatelessDesc)) break;
                tmplName = "JStatelessHome.vm";
                break;
            }
            case 1: {
                if (this.dd instanceof EntityDesc) {
                    tmplName = "JEntityLocalHome.vm";
                    break;
                }
                if (this.dd instanceof SessionStatefulDesc) {
                    tmplName = "JStatefulLocalHome.vm";
                    break;
                }
                if (!(this.dd instanceof SessionStatelessDesc)) break;
                tmplName = "JStatelessLocalHome.vm";
                break;
            }
            case 2: {
                if (this.dd instanceof EntityDesc) {
                    tmplName = "JEntityRemote.vm";
                    break;
                }
                if (this.dd instanceof SessionStatefulDesc) {
                    tmplName = "JStatefulRemote.vm";
                    break;
                }
                if (!(this.dd instanceof SessionStatelessDesc)) break;
                tmplName = "JStatelessRemote.vm";
                break;
            }
            case 3: {
                if (this.dd instanceof EntityDesc) {
                    tmplName = "JEntityLocal.vm";
                    break;
                }
                if (this.dd instanceof SessionStatefulDesc) {
                    tmplName = "JStatefulLocal.vm";
                    break;
                }
                if (!(this.dd instanceof SessionStatelessDesc)) break;
                tmplName = "JStatelessLocal.vm";
                break;
            }
            case 9: {
                if (!(this.dd instanceof SessionStatelessDesc)) break;
                tmplName = "JServiceEndpoint.vm";
                break;
            }
            case 10: {
                if (!(this.dd instanceof SessionStatelessDesc)) break;
                tmplName = "JServiceEndpointHome.vm";
                break;
            }
            case 4: {
                if (!(this.dd instanceof EntityDesc)) break;
                tmplName = "JEntityHandle.vm";
                break;
            }
            case 5: {
                if (this.dd instanceof EntityJdbcCmp1Desc) {
                    tmplName = "JEntityCmpJdbc.vm";
                }
                if (!(this.dd instanceof EntityJdbcCmp2Desc)) break;
                tmplName = "JEntityCmp2.vm";
                break;
            }
            case 7: {
                if (!(this.dd instanceof EntityJdbcCmp2Desc)) break;
                tmplName = "JEntityCmp2CoherenceItf.vm";
                break;
            }
        }
        if (tmplName == null) {
            throw new GenICException("No template for  '" + this.srcFileName + " !!!'");
        }
        String name = null;
        try {
            name = this.getClass().getPackage().getName().replace('.', '/') + "/" + tmplName;
            tmpl = this.vEngine.getTemplate(name);
        }
        catch (Exception e) {
            throw new GenICException("Cannot get " + name, e);
        }
        try {
            File fs = new File(this.srcFileName);
            File fdir = fs.getParentFile();
            if (fdir != null && !fdir.exists() && !fdir.mkdirs()) {
                throw new IOException("Cannot create the directory '" + fdir.getPath() + "'");
            }
            fwriter = new FileWriter(this.srcFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new GenICException("Cannot create the '" + this.srcFileName + "' source file", e);
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Generate the file " + this.srcFileName));
        try {
            tmpl.merge(this.vctx, fwriter);
        }
        catch (Exception e) {
            throw new GenICException("Cannot generate the '" + this.srcFileName + "' source from the '" + tmplName + "' template", e);
        }
        try {
            fwriter.flush();
            fwriter.close();
        }
        catch (IOException e) {
            throw new GenICException("Cannot close the '" + this.srcFileName + "' source file", e);
        }
    }
}

