/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.FieldInitLink;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ConstantAttribute;
import javassist.bytecode.Descriptor;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.InnerClassesAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.compiler.AccessorMaker;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;
import javassist.expr.ExprEditor;

class CtClassType
extends CtClass {
    ClassPool classPool;
    boolean wasChanged;
    private boolean wasFrozen;
    boolean wasPruned;
    boolean memberRemoved;
    ClassFile classfile;
    private CtMember fieldsCache;
    private CtMember methodsCache;
    private CtMember constructorsCache;
    private CtConstructor classInitializerCache;
    private AccessorMaker accessors;
    private FieldInitLink fieldInitializers;
    private Hashtable hiddenMethods;
    private int uniqueNumberSeed;
    private boolean doPruning = ClassPool.doPruning;
    int getCounter;
    private static int readCounter = 0;
    private static final int READ_THRESHOLD = 100;

    CtClassType(String name, ClassPool cp) {
        super(name);
        this.classPool = cp;
        this.memberRemoved = false;
        this.wasPruned = false;
        this.wasFrozen = false;
        this.wasChanged = false;
        this.classfile = null;
        this.accessors = null;
        this.fieldInitializers = null;
        this.hiddenMethods = null;
        this.uniqueNumberSeed = 0;
        this.eraseCache();
        this.getCounter = 0;
    }

    CtClassType(InputStream ins, ClassPool cp) throws IOException {
        this((String)null, cp);
        this.classfile = new ClassFile(new DataInputStream(ins));
        this.qualifiedName = this.classfile.getName();
    }

    protected void extendToString(StringBuffer buffer) {
        if (this.wasChanged) {
            buffer.append("changed ");
        }
        if (this.wasFrozen) {
            buffer.append("frozen ");
        }
        if (this.wasPruned) {
            buffer.append("pruned ");
        }
        buffer.append(Modifier.toString(this.getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getName());
        try {
            String name;
            CtClass ext = this.getSuperclass();
            if (ext != null && !(name = ext.getName()).equals("java.lang.Object")) {
                buffer.append(" extends " + ext.getName());
            }
        }
        catch (NotFoundException e) {
            buffer.append(" extends ??");
        }
        try {
            CtClass[] intf = this.getInterfaces();
            if (intf.length > 0) {
                buffer.append(" implements ");
            }
            for (int i = 0; i < intf.length; ++i) {
                buffer.append(intf[i].getName());
                buffer.append(", ");
            }
        }
        catch (NotFoundException e) {
            buffer.append(" extends ??");
        }
        CtMember field = this.getFieldsCache();
        buffer.append(" fields=");
        while (field != null) {
            buffer.append(field);
            buffer.append(", ");
            field = field.next;
        }
        CtMember c = this.getConstructorsCache();
        buffer.append(" constructors=");
        while (c != null) {
            buffer.append(c);
            buffer.append(", ");
            c = c.next;
        }
        CtMember m = this.getMethodsCache();
        buffer.append(" methods=");
        while (m != null) {
            buffer.append(m);
            buffer.append(", ");
            m = m.next;
        }
    }

    protected void eraseCache() {
        this.fieldsCache = null;
        this.constructorsCache = null;
        this.classInitializerCache = null;
        this.methodsCache = null;
    }

    public AccessorMaker getAccessorMaker() {
        if (this.accessors == null) {
            this.accessors = new AccessorMaker(this);
        }
        return this.accessors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassFile getClassFile2() {
        ClassFile classFile;
        if (this.classfile != null) {
            return this.classfile;
        }
        if (readCounter++ > 100 && ClassPool.releaseUnmodifiedClassFile) {
            this.releaseClassFiles();
            readCounter = 0;
        }
        InputStream fin = null;
        try {
            try {
                fin = this.classPool.openClassfile(this.getName());
                if (fin == null) {
                    throw new NotFoundException(this.getName());
                }
                fin = new BufferedInputStream(fin);
                this.classfile = new ClassFile(new DataInputStream(fin));
                if (!this.classfile.getName().equals(this.qualifiedName)) {
                    throw new RuntimeException("cannot find " + this.qualifiedName + ": " + this.classfile.getName() + " found in " + this.qualifiedName.replace('.', '/') + ".class");
                }
                classFile = this.classfile;
                Object var4_5 = null;
                if (fin == null) return classFile;
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (fin == null) throw throwable;
            try {
                fin.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return classFile;
        }
        fin.close();
        return classFile;
    }

    void incGetCounter() {
        ++this.getCounter;
    }

    private void releaseClassFiles() {
        Enumeration e = this.classPool.classes.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof CtClassType)) continue;
            CtClassType cct = (CtClassType)obj;
            if (cct.getCounter < 2 && !cct.isModified()) {
                cct.eraseCache();
                cct.classfile = null;
            }
            cct.getCounter = 0;
        }
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    void setClassPool(ClassPool cp) {
        this.classPool = cp;
    }

    public URL getURL() throws NotFoundException {
        URL url = this.classPool.find(this.getName());
        if (url == null) {
            throw new NotFoundException(this.getName());
        }
        return url;
    }

    public boolean isModified() {
        return this.wasChanged;
    }

    public boolean isFrozen() {
        return this.wasFrozen;
    }

    void freeze() {
        this.wasFrozen = true;
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            String msg = this.getName() + " class is frozen";
            if (this.wasPruned) {
                msg = msg + " and pruned";
            }
            throw new RuntimeException(msg);
        }
        this.wasChanged = true;
    }

    public void defrost() {
        this.checkPruned("defrost");
        this.wasFrozen = false;
    }

    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        int i;
        String cname = clazz.getName();
        if (this == clazz || this.getName().equals(cname)) {
            return true;
        }
        ClassFile file = this.getClassFile2();
        String supername = file.getSuperclass();
        if (supername != null && supername.equals(cname)) {
            return true;
        }
        String[] ifs = file.getInterfaces();
        int num = ifs.length;
        for (i = 0; i < num; ++i) {
            if (!ifs[i].equals(cname)) continue;
            return true;
        }
        if (supername != null && this.classPool.get(supername).subtypeOf(clazz)) {
            return true;
        }
        for (i = 0; i < num; ++i) {
            if (!this.classPool.get(ifs[i]).subtypeOf(clazz)) continue;
            return true;
        }
        return false;
    }

    public void setName(String name) throws RuntimeException {
        String oldname = this.getName();
        if (name.equals(oldname)) {
            return;
        }
        this.classPool.checkNotFrozen(name);
        ClassFile cf = this.getClassFile2();
        super.setName(name);
        cf.setName(name);
        this.eraseCache();
        this.classPool.classNameChanged(oldname, this);
    }

    public void replaceClassName(ClassMap classnames) throws RuntimeException {
        String oldClassName = this.getName();
        String newClassName = (String)classnames.get(Descriptor.toJvmName(oldClassName));
        if (newClassName != null) {
            newClassName = Descriptor.toJavaName(newClassName);
            this.classPool.checkNotFrozen(newClassName);
        }
        super.replaceClassName(classnames);
        ClassFile cf = this.getClassFile2();
        cf.renameClass(classnames);
        this.eraseCache();
        if (newClassName != null) {
            super.setName(newClassName);
            this.classPool.classNameChanged(oldClassName, this);
        }
    }

    public void replaceClassName(String oldname, String newname) throws RuntimeException {
        String thisname = this.getName();
        if (thisname.equals(oldname)) {
            this.setName(newname);
        } else {
            super.replaceClassName(oldname, newname);
            this.getClassFile2().renameClass(oldname, newname);
            this.eraseCache();
        }
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isAnnotation() {
        return Modifier.isAnnotation(this.getModifiers());
    }

    public boolean isEnum() {
        return Modifier.isEnum(this.getModifiers());
    }

    public int getModifiers() {
        ClassFile cf = this.getClassFile2();
        int acc = cf.getAccessFlags();
        acc = AccessFlag.clear(acc, 32);
        int inner = cf.getInnerAccessFlags();
        if (inner != -1 && (inner & 8) != 0) {
            acc |= 8;
        }
        return AccessFlag.toModifier(acc);
    }

    public CtClass[] getNestedClasses() throws NotFoundException {
        ClassFile cf = this.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            return new CtClass[0];
        }
        String thisName = cf.getName();
        int n = ica.tableLength();
        ArrayList<CtClass> list = new ArrayList<CtClass>(n);
        for (int i = 0; i < n; ++i) {
            String inner;
            String outer = ica.outerClass(i);
            if (outer != null && !outer.equals(thisName) || (inner = ica.innerClass(i)) == null) continue;
            list.add(this.classPool.get(inner));
        }
        return list.toArray(new CtClass[list.size()]);
    }

    public void setModifiers(int mod) {
        ClassFile cf = this.getClassFile2();
        if (Modifier.isStatic(mod)) {
            int flags = cf.getInnerAccessFlags();
            if (flags != -1 && (flags & 8) != 0) {
                mod &= 0xFFFFFFF7;
            } else {
                throw new RuntimeException("cannot change " + this.getName() + " into a static class");
            }
        }
        this.checkModify();
        int acc = AccessFlag.of(mod) | 0x20;
        cf.setAccessFlags(acc);
    }

    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected exception ", e);
        }
    }

    private Object[] getAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        ClassFile cf = this.getClassFile2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(ignoreNotFound, this.getClassPool(), ainfo, ainfo2);
    }

    static Object[] toAnnotationType(boolean ignoreNotFound, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) throws ClassNotFoundException {
        int size2;
        Annotation[] anno2;
        int size1;
        Annotation[] anno1;
        if (a1 == null) {
            anno1 = null;
            size1 = 0;
        } else {
            anno1 = a1.getAnnotations();
            size1 = anno1.length;
        }
        if (a2 == null) {
            anno2 = null;
            size2 = 0;
        } else {
            anno2 = a2.getAnnotations();
            size2 = anno2.length;
        }
        if (!ignoreNotFound) {
            Object[] result = new Object[size1 + size2];
            for (int i = 0; i < size1; ++i) {
                result[i] = CtClassType.toAnnoType(anno1[i], cp);
            }
            for (int j = 0; j < size2; ++j) {
                result[j + size1] = CtClassType.toAnnoType(anno2[j], cp);
            }
            return result;
        }
        ArrayList<Object> annotations = new ArrayList<Object>();
        for (int i = 0; i < size1; ++i) {
            try {
                annotations.add(CtClassType.toAnnoType(anno1[i], cp));
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        for (int j = 0; j < size2; ++j) {
            try {
                annotations.add(CtClassType.toAnnoType(anno2[j], cp));
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return annotations.toArray();
    }

    static Object[][] toAnnotationType(boolean ignoreNotFound, ClassPool cp, ParameterAnnotationsAttribute a1, ParameterAnnotationsAttribute a2, MethodInfo minfo) throws ClassNotFoundException {
        int numParameters = 0;
        numParameters = a1 != null ? a1.numParameters() : (a2 != null ? a2.numParameters() : Descriptor.numOfParameters(minfo.getDescriptor()));
        Object[][] result = new Object[numParameters][];
        for (int i = 0; i < numParameters; ++i) {
            int j;
            int size2;
            Annotation[] anno2;
            int size1;
            Annotation[] anno1;
            if (a1 == null) {
                anno1 = null;
                size1 = 0;
            } else {
                anno1 = a1.getAnnotations()[i];
                size1 = anno1.length;
            }
            if (a2 == null) {
                anno2 = null;
                size2 = 0;
            } else {
                anno2 = a2.getAnnotations()[i];
                size2 = anno2.length;
            }
            if (!ignoreNotFound) {
                int j2;
                result[i] = new Object[size1 + size2];
                for (j2 = 0; j2 < size1; ++j2) {
                    result[i][j2] = CtClassType.toAnnoType(anno1[j2], cp);
                }
                for (j2 = 0; j2 < size2; ++j2) {
                    result[i][j2 + size1] = CtClassType.toAnnoType(anno2[j2], cp);
                }
                continue;
            }
            ArrayList<Object> annotations = new ArrayList<Object>();
            for (j = 0; j < size1; ++j) {
                try {
                    annotations.add(CtClassType.toAnnoType(anno1[j], cp));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            for (j = 0; j < size2; ++j) {
                try {
                    annotations.add(CtClassType.toAnnoType(anno2[j], cp));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            result[i] = annotations.toArray();
        }
        return result;
    }

    private static Object toAnnoType(Annotation anno, ClassPool cp) throws ClassNotFoundException {
        try {
            ClassLoader cl = cp.getClassLoader();
            return anno.toAnnotationType(cl, cp);
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl2 = cp.getClass().getClassLoader();
            return anno.toAnnotationType(cl2, cp);
        }
    }

    public boolean subclassOf(CtClass superclass) {
        if (superclass == null) {
            return false;
        }
        String superName = superclass.getName();
        try {
            for (CtClass curr = this; curr != null; curr = ((CtClass)curr).getSuperclass()) {
                if (!curr.getName().equals(superName)) continue;
                return true;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return false;
    }

    public CtClass getSuperclass() throws NotFoundException {
        String supername = this.getClassFile2().getSuperclass();
        if (supername == null) {
            return null;
        }
        return this.classPool.get(supername);
    }

    public void setSuperclass(CtClass clazz) throws CannotCompileException {
        this.checkModify();
        if (this.isInterface()) {
            this.addInterface(clazz);
        } else {
            this.getClassFile2().setSuperclass(clazz.getName());
        }
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        String[] ifs = this.getClassFile2().getInterfaces();
        int num = ifs.length;
        CtClass[] ifc = new CtClass[num];
        for (int i = 0; i < num; ++i) {
            ifc[i] = this.classPool.get(ifs[i]);
        }
        return ifc;
    }

    public void setInterfaces(CtClass[] list) {
        String[] ifs;
        this.checkModify();
        if (list == null) {
            ifs = new String[]{};
        } else {
            int num = list.length;
            ifs = new String[num];
            for (int i = 0; i < num; ++i) {
                ifs[i] = list[i].getName();
            }
        }
        this.getClassFile2().setInterfaces(ifs);
    }

    public void addInterface(CtClass anInterface) {
        this.checkModify();
        if (anInterface != null) {
            this.getClassFile2().addInterface(anInterface.getName());
        }
    }

    public CtClass getDeclaringClass() throws NotFoundException {
        ClassFile cf = this.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            return null;
        }
        String name = this.getName();
        int n = ica.tableLength();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(ica.innerClass(i))) continue;
            String outName = ica.outerClass(i);
            if (outName != null) {
                return this.classPool.get(outName);
            }
            EnclosingMethodAttribute ema = (EnclosingMethodAttribute)cf.getAttribute("EnclosingMethod");
            if (ema == null) continue;
            return this.classPool.get(ema.className());
        }
        return null;
    }

    public CtMethod getEnclosingMethod() throws NotFoundException {
        ClassFile cf = this.getClassFile2();
        EnclosingMethodAttribute ema = (EnclosingMethodAttribute)cf.getAttribute("EnclosingMethod");
        if (ema != null) {
            CtClass enc = this.classPool.get(ema.className());
            return enc.getMethod(ema.methodName(), ema.methodDescriptor());
        }
        return null;
    }

    public CtClass makeNestedClass(String name, boolean isStatic) {
        if (!isStatic) {
            throw new RuntimeException("sorry, only nested static class is supported");
        }
        this.checkModify();
        CtClass c = this.classPool.makeNestedClass(this.getName() + "$" + name);
        ClassFile cf = this.getClassFile2();
        ClassFile cf2 = c.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            ica = new InnerClassesAttribute(cf.getConstPool());
            cf.addAttribute(ica);
        }
        ica.append(c.getName(), this.getName(), name, cf2.getAccessFlags() & 0xFFFFFFDF | 8);
        cf2.addAttribute(ica.copy(cf2.getConstPool(), null));
        return c;
    }

    public CtField[] getFields() {
        ArrayList alist = new ArrayList();
        CtClassType.getFields(alist, this);
        return alist.toArray(new CtField[alist.size()]);
    }

    private static void getFields(ArrayList alist, CtClass cc) {
        if (cc == null) {
            return;
        }
        try {
            CtClassType.getFields(alist, cc.getSuperclass());
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass[] ifs = cc.getInterfaces();
            int num = ifs.length;
            for (int i = 0; i < num; ++i) {
                CtClassType.getFields(alist, ifs[i]);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        CtMember cf = ((CtClassType)cc).getFieldsCache();
        while (cf != null) {
            if (!Modifier.isPrivate(cf.getModifiers())) {
                alist.add(cf);
            }
            cf = cf.next;
        }
    }

    public CtField getField(String name) throws NotFoundException {
        CtField f = this.getField2(name);
        if (f == null) {
            throw new NotFoundException("field: " + name + " in " + this.getName());
        }
        return f;
    }

    CtField getField2(String name) {
        CtField df = this.getDeclaredField2(name);
        if (df != null) {
            return df;
        }
        try {
            CtClass[] ifs = this.getInterfaces();
            int num = ifs.length;
            for (int i = 0; i < num; ++i) {
                CtField f = ifs[i].getField2(name);
                if (f == null) continue;
                return f;
            }
            CtClass s = this.getSuperclass();
            if (s != null) {
                return s.getField2(name);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public CtField[] getDeclaredFields() {
        CtMember cf = this.getFieldsCache();
        int num = CtField.count(cf);
        CtField[] cfs = new CtField[num];
        int i = 0;
        while (cf != null) {
            cfs[i++] = (CtField)cf;
            cf = cf.next;
        }
        return cfs;
    }

    protected CtMember getFieldsCache() {
        if (this.fieldsCache == null) {
            List list = this.getClassFile2().getFields();
            int n = list.size();
            CtMember allFields = null;
            CtField tail = null;
            for (int i = 0; i < n; ++i) {
                FieldInfo finfo = (FieldInfo)list.get(i);
                CtField newTail = new CtField(finfo, (CtClass)this);
                allFields = CtMember.append(allFields, tail, newTail);
                tail = newTail;
            }
            this.fieldsCache = allFields;
        }
        return this.fieldsCache;
    }

    public CtField getDeclaredField(String name) throws NotFoundException {
        CtField f = this.getDeclaredField2(name);
        if (f == null) {
            throw new NotFoundException("field: " + name + " in " + this.getName());
        }
        return f;
    }

    private CtField getDeclaredField2(String name) {
        CtMember cf = this.getFieldsCache();
        while (cf != null) {
            if (cf.getName().equals(name)) {
                return (CtField)cf;
            }
            cf = cf.next;
        }
        return null;
    }

    public CtBehavior[] getDeclaredBehaviors() {
        CtMember cc = this.getConstructorsCache();
        CtMember cm = this.getMethodsCache();
        int num = CtMember.count(cm) + CtMember.count(cc);
        CtBehavior[] cb = new CtBehavior[num];
        int i = 0;
        while (cc != null) {
            cb[i++] = (CtBehavior)cc;
            cc = cc.next;
        }
        while (cm != null) {
            cb[i++] = (CtBehavior)cm;
            cm = cm.next;
        }
        return cb;
    }

    public CtConstructor[] getConstructors() {
        CtConstructor[] cons = this.getDeclaredConstructors();
        if (cons.length == 0) {
            return cons;
        }
        int n = 0;
        int i = cons.length;
        while (--i >= 0) {
            if (Modifier.isPrivate(cons[i].getModifiers())) continue;
            ++n;
        }
        CtConstructor[] result = new CtConstructor[n];
        n = 0;
        i = cons.length;
        while (--i >= 0) {
            CtConstructor c = cons[i];
            if (Modifier.isPrivate(c.getModifiers())) continue;
            result[n++] = c;
        }
        return result;
    }

    public CtConstructor getConstructor(String desc) throws NotFoundException {
        CtConstructor cc = (CtConstructor)this.getConstructorsCache();
        while (cc != null) {
            if (cc.getMethodInfo2().getDescriptor().equals(desc)) {
                return cc;
            }
            cc = (CtConstructor)cc.next;
        }
        return super.getConstructor(desc);
    }

    public CtConstructor[] getDeclaredConstructors() {
        CtMember cc = this.getConstructorsCache();
        int num = CtMember.count(cc);
        CtConstructor[] ccs = new CtConstructor[num];
        int i = 0;
        while (cc != null) {
            ccs[i++] = (CtConstructor)cc;
            cc = cc.next;
        }
        return ccs;
    }

    protected CtMember getConstructorsCache() {
        if (this.constructorsCache == null) {
            List list = this.getClassFile2().getMethods();
            int n = list.size();
            CtMember allConstructors = null;
            CtConstructor tail = null;
            for (int i = 0; i < n; ++i) {
                MethodInfo minfo = (MethodInfo)list.get(i);
                if (!minfo.isConstructor()) continue;
                CtConstructor newTail = new CtConstructor(minfo, (CtClass)this);
                allConstructors = CtMember.append(allConstructors, tail, newTail);
                tail = newTail;
            }
            this.constructorsCache = allConstructors;
        }
        return this.constructorsCache;
    }

    public CtConstructor getClassInitializer() {
        MethodInfo minfo;
        if (this.classInitializerCache == null && (minfo = this.getClassFile2().getStaticInitializer()) != null) {
            this.classInitializerCache = new CtConstructor(minfo, (CtClass)this);
        }
        return this.classInitializerCache;
    }

    public CtMethod[] getMethods() {
        HashMap h = new HashMap();
        CtClassType.getMethods0(h, this);
        return h.values().toArray(new CtMethod[h.size()]);
    }

    private static void getMethods0(HashMap h, CtClass cc) {
        try {
            CtClass[] ifs = cc.getInterfaces();
            int size = ifs.length;
            for (int i = 0; i < size; ++i) {
                CtClassType.getMethods0(h, ifs[i]);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass s = cc.getSuperclass();
            if (s != null) {
                CtClassType.getMethods0(h, s);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        if (cc instanceof CtClassType) {
            CtMember cm = ((CtClassType)cc).getMethodsCache();
            while (cm != null) {
                if (!Modifier.isPrivate(cm.getModifiers())) {
                    h.put(((CtMethod)cm).getStringRep(), cm);
                }
                cm = cm.next;
            }
        }
    }

    public CtMethod getMethod(String name, String desc) throws NotFoundException {
        CtMethod m = CtClassType.getMethod0(this, name, desc);
        if (m != null) {
            return m;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    private static CtMethod getMethod0(CtClass cc, String name, String desc) {
        if (cc instanceof CtClassType) {
            CtMethod cm = (CtMethod)((CtClassType)cc).getMethodsCache();
            while (cm != null) {
                if (cm.getName().equals(name) && cm.getMethodInfo2().getDescriptor().equals(desc)) {
                    return cm;
                }
                cm = (CtMethod)cm.next;
            }
        }
        try {
            CtMethod m;
            CtClass s = cc.getSuperclass();
            if (s != null && (m = CtClassType.getMethod0(s, name, desc)) != null) {
                return m;
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass[] ifs = cc.getInterfaces();
            int size = ifs.length;
            for (int i = 0; i < size; ++i) {
                CtMethod m = CtClassType.getMethod0(ifs[i], name, desc);
                if (m == null) continue;
                return m;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public CtMethod[] getDeclaredMethods() {
        CtMember cm = this.getMethodsCache();
        int num = CtMember.count(cm);
        CtMethod[] cms = new CtMethod[num];
        int i = 0;
        while (cm != null) {
            cms[i++] = (CtMethod)cm;
            cm = cm.next;
        }
        return cms;
    }

    public CtMethod getDeclaredMethod(String name) throws NotFoundException {
        CtMember m = this.getMethodsCache();
        while (m != null) {
            if (m.getName().equals(name)) {
                return (CtMethod)m;
            }
            m = m.next;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    public CtMethod getDeclaredMethod(String name, CtClass[] params) throws NotFoundException {
        String desc = Descriptor.ofParameters(params);
        CtMethod m = (CtMethod)this.getMethodsCache();
        while (m != null) {
            if (m.getName().equals(name) && m.getMethodInfo2().getDescriptor().startsWith(desc)) {
                return m;
            }
            m = (CtMethod)m.next;
        }
        throw new NotFoundException(name + "(..) is not found in " + this.getName());
    }

    protected CtMember getMethodsCache() {
        if (this.methodsCache == null) {
            List list = this.getClassFile2().getMethods();
            int n = list.size();
            CtMember allMethods = null;
            CtMethod tail = null;
            for (int i = 0; i < n; ++i) {
                MethodInfo minfo = (MethodInfo)list.get(i);
                if (!minfo.isMethod()) continue;
                CtMethod newTail = new CtMethod(minfo, this);
                allMethods = CtMember.append(allMethods, tail, newTail);
                tail = newTail;
            }
            this.methodsCache = allMethods;
        }
        return this.methodsCache;
    }

    public void addField(CtField f, String init) throws CannotCompileException {
        this.addField(f, CtField.Initializer.byExpr(init));
    }

    public void addField(CtField f, CtField.Initializer init) throws CannotCompileException {
        int mod;
        this.checkModify();
        if (f.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        if (init == null) {
            init = f.getInit();
        }
        if (init != null && Modifier.isStatic(mod = f.getModifiers()) && Modifier.isFinal(mod)) {
            try {
                ConstPool cp = this.getClassFile2().getConstPool();
                int index = init.getConstantValue(cp, f.getType());
                if (index != 0) {
                    f.getFieldInfo2().addAttribute(new ConstantAttribute(cp, index));
                    init = null;
                }
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
        this.getFieldsCache();
        this.fieldsCache = CtField.append(this.fieldsCache, f);
        this.getClassFile2().addField(f.getFieldInfo2());
        if (init != null) {
            FieldInitLink fil = new FieldInitLink(f, init);
            FieldInitLink link = this.fieldInitializers;
            if (link == null) {
                this.fieldInitializers = fil;
            } else {
                while (link.next != null) {
                    link = link.next;
                }
                link.next = fil;
            }
        }
    }

    public void removeField(CtField f) throws NotFoundException {
        this.checkModify();
        FieldInfo fi = f.getFieldInfo2();
        ClassFile cf = this.getClassFile2();
        if (!cf.getFields().remove(fi)) {
            throw new NotFoundException(f.toString());
        }
        this.fieldsCache = CtMember.remove(this.fieldsCache, f);
        this.memberRemoved = true;
    }

    public CtConstructor makeClassInitializer() throws CannotCompileException {
        CtConstructor clinit = this.getClassInitializer();
        if (clinit != null) {
            return clinit;
        }
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        this.modifyClassConstructor(cf, code, 0, 0);
        return this.getClassInitializer();
    }

    public void addConstructor(CtConstructor c) throws CannotCompileException {
        this.checkModify();
        if (c.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getConstructorsCache();
        this.constructorsCache = (CtConstructor)CtMember.append(this.constructorsCache, c);
        this.getClassFile2().addMethod(c.getMethodInfo2());
    }

    public void removeConstructor(CtConstructor m) throws NotFoundException {
        this.checkModify();
        MethodInfo mi = m.getMethodInfo2();
        ClassFile cf = this.getClassFile2();
        if (!cf.getMethods().remove(mi)) {
            throw new NotFoundException(m.toString());
        }
        this.constructorsCache = CtMember.remove(this.constructorsCache, m);
        this.memberRemoved = true;
    }

    public void addMethod(CtMethod m) throws CannotCompileException {
        this.checkModify();
        if (m.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMethodsCache();
        this.methodsCache = CtMember.append(this.methodsCache, m);
        this.getClassFile2().addMethod(m.getMethodInfo2());
        if ((m.getModifiers() & 0x400) != 0) {
            this.setModifiers(this.getModifiers() | 0x400);
        }
    }

    public void removeMethod(CtMethod m) throws NotFoundException {
        this.checkModify();
        MethodInfo mi = m.getMethodInfo2();
        ClassFile cf = this.getClassFile2();
        if (!cf.getMethods().remove(mi)) {
            throw new NotFoundException(m.toString());
        }
        this.methodsCache = CtMember.remove(this.methodsCache, m);
        this.memberRemoved = true;
    }

    public byte[] getAttribute(String name) {
        AttributeInfo ai = this.getClassFile2().getAttribute(name);
        if (ai == null) {
            return null;
        }
        return ai.get();
    }

    public void setAttribute(String name, byte[] data) {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        cf.addAttribute(new AttributeInfo(cf.getConstPool(), name, data));
    }

    public void instrument(CodeConverter converter) throws CannotCompileException {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        ConstPool cp = cf.getConstPool();
        List list = cf.getMethods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            converter.doit(this, minfo, cp);
        }
    }

    public void instrument(ExprEditor editor) throws CannotCompileException {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        List list = cf.getMethods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            editor.doit(this, minfo);
        }
    }

    public void prune() {
        if (this.wasPruned) {
            return;
        }
        this.wasFrozen = true;
        this.wasPruned = true;
        this.getClassFile2().prune();
    }

    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        try {
            if (this.isModified()) {
                this.checkPruned("toBytecode");
                ClassFile cf = this.getClassFile2();
                if (this.memberRemoved) {
                    cf.compact();
                    this.memberRemoved = false;
                }
                this.modifyClassConstructor(cf);
                this.modifyConstructors(cf);
                cf.write(out);
                out.flush();
                this.fieldInitializers = null;
                if (this.doPruning) {
                    cf.prune();
                    this.wasPruned = true;
                }
            } else {
                this.classPool.writeClassfile(this.getName(), out);
                this.eraseCache();
                this.classfile = null;
            }
            this.wasFrozen = true;
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (IOException e) {
            throw new CannotCompileException(e);
        }
    }

    private void checkPruned(String method) {
        if (this.wasPruned) {
            throw new RuntimeException(method + "(): " + this.getName() + " was pruned.");
        }
    }

    public boolean stopPruning(boolean stop) {
        boolean prev = !this.doPruning;
        this.doPruning = !stop;
        return prev;
    }

    private void modifyClassConstructor(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        Javac jv = new Javac(code, this);
        int stacksize = 0;
        boolean doInit = false;
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            CtField f = fi.field;
            if (Modifier.isStatic(f.getModifiers())) {
                doInit = true;
                int s = fi.init.compileIfStatic(f.getType(), f.getName(), code, jv);
                if (stacksize < s) {
                    stacksize = s;
                }
            }
            fi = fi.next;
        }
        if (doInit) {
            this.modifyClassConstructor(cf, code, stacksize, 0);
        }
    }

    private void modifyClassConstructor(ClassFile cf, Bytecode code, int stacksize, int localsize) throws CannotCompileException {
        MethodInfo m = cf.getStaticInitializer();
        if (m == null) {
            code.add(177);
            code.setMaxStack(stacksize);
            code.setMaxLocals(localsize);
            m = new MethodInfo(cf.getConstPool(), "<clinit>", "()V");
            m.setAccessFlags(8);
            m.setCodeAttribute(code.toCodeAttribute());
            cf.addMethod(m);
        } else {
            CodeAttribute codeAttr = m.getCodeAttribute();
            if (codeAttr == null) {
                throw new CannotCompileException("empty <clinit>");
            }
            try {
                int maxlocals;
                CodeIterator it = codeAttr.iterator();
                int pos = it.insertEx(code.get());
                it.insert(code.getExceptionTable(), pos);
                int maxstack = codeAttr.getMaxStack();
                if (maxstack < stacksize) {
                    codeAttr.setMaxStack(stacksize);
                }
                if ((maxlocals = codeAttr.getMaxLocals()) < localsize) {
                    codeAttr.setMaxLocals(localsize);
                }
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
    }

    private void modifyConstructors(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        ConstPool cp = cf.getConstPool();
        List list = cf.getMethods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CodeAttribute codeAttr;
            MethodInfo minfo = (MethodInfo)list.get(i);
            if (!minfo.isConstructor() || (codeAttr = minfo.getCodeAttribute()) == null) continue;
            try {
                Bytecode init = new Bytecode(cp, 0, codeAttr.getMaxLocals());
                CtClass[] params = Descriptor.getParameterTypes(minfo.getDescriptor(), this.classPool);
                int stacksize = this.makeFieldInitializer(init, params);
                CtClassType.insertAuxInitializer(codeAttr, init, stacksize);
                continue;
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
    }

    private static void insertAuxInitializer(CodeAttribute codeAttr, Bytecode initializer, int stacksize) throws BadBytecode {
        CodeIterator it = codeAttr.iterator();
        int index = it.skipSuperConstructor();
        if (index < 0 && (index = it.skipThisConstructor()) >= 0) {
            return;
        }
        int pos = it.insertEx(initializer.get());
        it.insert(initializer.getExceptionTable(), pos);
        int maxstack = codeAttr.getMaxStack();
        if (maxstack < stacksize) {
            codeAttr.setMaxStack(stacksize);
        }
    }

    private int makeFieldInitializer(Bytecode code, CtClass[] parameters) throws CannotCompileException, NotFoundException {
        int stacksize = 0;
        Javac jv = new Javac(code, this);
        try {
            jv.recordParams(parameters, false);
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            int s;
            CtField f = fi.field;
            if (!Modifier.isStatic(f.getModifiers()) && stacksize < (s = fi.init.compile(f.getType(), f.getName(), code, parameters, jv))) {
                stacksize = s;
            }
            fi = fi.next;
        }
        return stacksize;
    }

    Hashtable getHiddenMethods() {
        if (this.hiddenMethods == null) {
            this.hiddenMethods = new Hashtable();
        }
        return this.hiddenMethods;
    }

    int getUniqueNumber() {
        return this.uniqueNumberSeed++;
    }

    public String makeUniqueName(String prefix) {
        String name;
        HashMap table = new HashMap();
        this.makeMemberList(table);
        Set keys = table.keySet();
        String[] methods = new String[keys.size()];
        keys.toArray(methods);
        if (CtClassType.notFindInArray(prefix, methods)) {
            return prefix;
        }
        int i = 100;
        do {
            if (i <= 999) continue;
            throw new RuntimeException("too many unique name");
        } while (!CtClassType.notFindInArray(name = prefix + i++, methods));
        return name;
    }

    private static boolean notFindInArray(String prefix, String[] values) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (!values[i].startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private void makeMemberList(HashMap table) {
        int i;
        int mod = this.getModifiers();
        if (Modifier.isAbstract(mod) || Modifier.isInterface(mod)) {
            try {
                CtClass[] ifs = this.getInterfaces();
                int size = ifs.length;
                for (i = 0; i < size; ++i) {
                    CtClass ic = ifs[i];
                    if (ic == null || !(ic instanceof CtClassType)) continue;
                    ((CtClassType)ic).makeMemberList(table);
                }
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
        try {
            CtClass s = this.getSuperclass();
            if (s != null && s instanceof CtClassType) {
                ((CtClassType)s).makeMemberList(table);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        List list = this.getClassFile2().getMethods();
        int n = list.size();
        for (i = 0; i < n; ++i) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            table.put(minfo.getName(), this);
        }
        list = this.getClassFile2().getFields();
        n = list.size();
        for (i = 0; i < n; ++i) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            table.put(finfo.getName(), this);
        }
    }
}

