/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.helper.listener;

import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.deployment.helper.listener.AbstractExtensionListener;
import org.ow2.easybeans.event.naming.EnvNamingEvent;
import org.ow2.util.ee.metadata.common.api.struct.IEnvEntry;
import org.ow2.util.event.api.IEvent;

public class EnvEntriesExtensionListener
extends AbstractExtensionListener {
    public boolean accept(IEvent event) {
        EnvNamingEvent namingEvent;
        return event instanceof EnvNamingEvent && "comp/env".equals((namingEvent = (EnvNamingEvent)event).getEventProviderId());
    }

    public void handle(IEvent event) {
        EnvNamingEvent ene = (EnvNamingEvent)event;
        Context envCtx = ene.getContext();
        for (IEnvEntry envEntry : ene.getBeanMetadata().getEnvEntryCollection()) {
            String name = envEntry.getName();
            Object value = this.getEnvEntryValue(envEntry, ene);
            if (value == null) continue;
            try {
                envCtx.rebind(name, value);
            }
            catch (NamingException e) {
                this.throwException(ene, new IllegalStateException("Cannot bind element '" + name + "'.", e));
            }
        }
    }

    private Object getEnvEntryValue(IEnvEntry envEntry, EnvNamingEvent event) {
        String type = envEntry.getType();
        String value = envEntry.getValue();
        Object returnedValue = null;
        if (type.equals(Boolean.class.getName())) {
            if ("true".equalsIgnoreCase(value)) {
                returnedValue = Boolean.TRUE;
            } else if ("false".equalsIgnoreCase(value)) {
                returnedValue = Boolean.FALSE;
            }
        } else if (type.equals(String.class.getName())) {
            returnedValue = value;
        } else if (type.equals(Integer.class.getName())) {
            if (value != null) {
                returnedValue = new Integer(value);
            }
        } else if (type.equals(Character.class.getName())) {
            if (value != null) {
                if (value.length() != 1) {
                    this.throwException(event, new IllegalStateException("The value '" + value + "' is not a valid value for env-entry of type java.lang.Character."));
                }
                returnedValue = Character.valueOf(value.charAt(0));
            }
        } else if (type.equals(Double.class.getName())) {
            if (value != null) {
                returnedValue = new Double(value);
            }
        } else if (type.equals(Byte.class.getName())) {
            if (value != null) {
                returnedValue = new Byte(value);
            }
        } else if (type.equals(Short.class.getName())) {
            if (value != null) {
                returnedValue = new Short(value);
            }
        } else if (type.equals(Long.class.getName())) {
            if (value != null) {
                returnedValue = new Long(value);
            }
        } else if (type.equals(Float.class.getName())) {
            if (value != null) {
                returnedValue = new Float(value);
            }
        } else {
            this.throwException(event, new IllegalStateException(type + " is not a valid type for env-entry."));
        }
        return returnedValue;
    }
}

