/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.generator;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.generator.lib.CommonHelper;
import org.objectweb.jorm.mapper.rdb.adapter.RdbAdapterFactory;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenColumn;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenInfos;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenJoin;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenRef;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class RdbCommonHelper
extends CommonHelper {
    private Map rdbAdapters = new HashMap();

    public RdbCommonHelper() {
    }

    public RdbCommonHelper(Logger logger) {
        this.setLogger(logger);
    }

    protected RdbAdapter getRdbAdapter(String mappername) throws PException {
        RdbAdapter res = (RdbAdapter)this.rdbAdapters.get(mappername);
        if (res != null) {
            return res;
        }
        String dbn = mappername.indexOf(".") == -1 ? "jdbc" : mappername.substring(mappername.indexOf(".") + 1);
        try {
            res = RdbAdapterFactory.getTypeConverter((String)dbn);
        }
        catch (RdbAdapterException e) {
            throw new PException((Exception)((Object)e), "");
        }
        this.rdbAdapters.put(mappername, res);
        return res;
    }

    public String getSqlType(RdbPrimitiveElementMapping pem, String adapter, boolean usedInPk) throws PException {
        String userSQLType = pem.getType();
        if (userSQLType == null || userSQLType.length() == 0) {
            StringBuffer sb = new StringBuffer(adapter);
            sb.append(".getSqlType(");
            PrimitiveElement pe = (PrimitiveElement)pem.getLinkedMO();
            sb.append(pe.getType().getProgName());
            sb.append(".getTypeCode(), ");
            sb.append(usedInPk);
            sb.append(", ");
            if (pe.getSize() == -1) {
                sb.append("RdbAdapter.NOSIZE");
            } else {
                sb.append(pe.getSize());
            }
            sb.append(", ");
            if (pe.getScale() == -1) {
                sb.append("RdbAdapter.NOSIZE");
            } else {
                sb.append(pe.getScale());
            }
            sb.append(")");
            return sb.toString();
        }
        return "\"" + userSQLType + "\"";
    }

    RdbGenInfos getRdbGenInfos(Class clazz, String projectName, String mapperName) throws PException {
        RdbMapping mapping = (RdbMapping)clazz.getClassProject(projectName).getMapping(mapperName);
        return this.createRdbGenInfosContext(mapping, clazz, new HashMap());
    }

    RdbGenInfos createRdbGenInfosContext(RdbMapping mapping, Class constantHolderClass, Map ctx) throws PException {
        Class clazz = (Class)mapping.getClassMapping().getLinkedMO();
        this.debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        RdbGenInfos rgi = new RdbGenInfos();
        rgi.mapping = mapping;
        rgi.logger = this.logger;
        rgi.debug = this.debug;
        RdbClassMultiMapping classMapping = (RdbClassMultiMapping)mapping.getClassMapping();
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("mapping.getClassMapping() " + classMapping));
            this.logger.log(BasicLevel.DEBUG, (Object)("Creating the generation MI for the class = " + ((Class)classMapping.getLinkedMO()).getFQName()));
        }
        this.getInheritedData((RdbClassMapping)classMapping, rgi, constantHolderClass, ctx);
        if (rgi.mainTable == null) {
            if (classMapping.getRdbTable() == null) {
                this.logger.log(BasicLevel.WARN, (Object)"No main table defined by this hierachy: abort generation.");
                return rgi;
            }
            RdbTable mainRdbTable = classMapping.getRdbTable();
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Main table: " + mainRdbTable.getName()));
            }
            rgi.mainTable = new RdbGenTable(mainRdbTable, constantHolderClass, rgi);
        } else if (classMapping.getRdbTable() != null) {
            rgi.mainTable.constructFromTable(classMapping.getRdbTable(), constantHolderClass, rgi);
        }
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Inherited columns:");
            this.printColumns(rgi.readableColumns);
        }
        rgi.tables.put(rgi.mainTable.aliasTableName, rgi.mainTable);
        this.addColumnUnique(rgi.mainTable.columns, rgi.readableColumns, false);
        Iterator it = classMapping.getExternalTables().iterator();
        while (it.hasNext()) {
            RdbExternalTable extTable = (RdbExternalTable)it.next();
            RdbGenTable genTable = new RdbGenTable(extTable, rgi.mainTable, constantHolderClass, rgi);
            rgi.tables.put(genTable.aliasTableName, genTable);
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("ext table -- name = " + genTable.getTableName()));
            }
            for (int i = 0; i < genTable.columns.size(); ++i) {
                RdbGenColumn genColumn = (RdbGenColumn)genTable.columns.get(i);
                if (genColumn.joinCol != null) continue;
                rgi.readableColumns.add(genColumn);
            }
        }
        NameDef nd = classMapping.getIdentifierMapping().getNameDef();
        Integer ndIdInteger = (Integer)ctx.get("ndid");
        int ndId = ndIdInteger == null ? 0 : ndIdInteger;
        rgi.genId = this.defineGenRef(nd, null, ndId++, (RdbClassMapping)classMapping, rgi);
        if (this.debug) {
            Iterator iter = clazz.getAllFields().iterator();
            while (iter.hasNext()) {
                TypedElement typedElem = (TypedElement)iter.next();
                if (!(typedElem instanceof Reference)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("current class: " + clazz.getName() + "current reference field " + typedElem.getName()));
                this.logger.log(BasicLevel.DEBUG, (Object)("classMapping.getReferenceMapping(typedElem.getName()) " + classMapping.getReferenceMapping(typedElem.getName())));
                NameDef namedef = (NameDef)classMapping.getReferenceMapping(typedElem.getName()).getLinkedMO();
                this.logger.log(BasicLevel.DEBUG, (Object)("current reference field " + typedElem.getName() + " namedef " + namedef));
            }
        }
        Iterator<Object> it2 = classMapping.getReferenceMappings().iterator();
        while (it2.hasNext()) {
            nd = (NameDef)((ReferenceMapping)it2.next()).getLinkedMO();
            String fn = ((Reference)nd.getParent()).getName();
            rgi.genRefs.put(fn, this.defineGenRef(nd, fn, ndId++, (RdbClassMapping)classMapping, rgi));
        }
        ctx.put("ndid", new Integer(ndId));
        it2 = rgi.tables.values().iterator();
        while (it2.hasNext()) {
            RdbGenTable rgt = (RdbGenTable)it2.next();
            rgt.fixMustGenerateUpdate();
            if (this.logger == null || !this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("GenerateUpdate for table " + rgt.tableName + ": " + rgt.mustGenerateUpdate));
            if (rgt.mustGenerateUpdate) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("columns=" + rgt.columns));
        }
        Collections.sort(rgi.readableColumns, new RGCComparator());
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)"ReadableColumn: ");
            for (int i = 0; i < rgi.readableColumns.size(); ++i) {
                RdbGenColumn col = (RdbGenColumn)rgi.readableColumns.get(i);
                if (col.joins == null) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("\tCOL=" + col.columnName + " / TABLE=" + col.table.tableName + " / COL_IDX=" + rgi.getColumnPosition(col) + " rgc=" + col));
                    continue;
                }
                this.logger.log(BasicLevel.DEBUG, (Object)("\tCOL=" + col.columnName + " / TABLE=" + col.table.tableName + " rgc=" + col));
                for (int j = 0; j < col.joins.size(); ++j) {
                    RdbGenJoin join = (RdbGenJoin)col.joins.get(j);
                    this.logger.log(BasicLevel.DEBUG, (Object)("\t\tJOIN_IDX=" + join.getJoinIdx() + " / COL_IDX=" + rgi.getColumnPosition(col, join)));
                }
            }
            this.logger.log(BasicLevel.DEBUG, (Object)("End of createClassGenerationContext for class " + clazz.getFQName()));
        }
        rgi.filterExpr = rgi.getFilterExpression();
        return rgi;
    }

    private void addColumnUnique(List source, List dest, boolean addInHead) {
        int pos = addInHead ? 0 : dest.size();
        for (int i = 0; i < source.size(); ++i) {
            boolean found = false;
            RdbGenColumn rgcToAdd = (RdbGenColumn)source.get(i);
            for (int j = 0; j < dest.size() && !found; ++j) {
                RdbGenColumn col = (RdbGenColumn)dest.get(j);
                found = col.table.aliasTableName.equals(rgcToAdd.table.aliasTableName) && col.columnName.equals(rgcToAdd.columnName);
            }
            if (found) continue;
            dest.add(pos++, rgcToAdd);
        }
    }

    private RdbGenRef defineGenRef(NameDef nd, String fn, int cnid, RdbClassMapping cm, RdbGenInfos rgi) throws PException {
        RdbGenRef rgr = new RdbGenRef();
        rgr.nd = nd;
        rgr.fieldName = fn;
        if (nd.isFieldName()) {
            RdbGenTable rgt;
            RdbPrimitiveElementMapping pem = (RdbPrimitiveElementMapping)cm.getPrimitiveElementMapping(nd.getFieldName(), true);
            if (pem == null) {
                throw new PException("Unable to find the mapping of the field " + nd.getFieldName());
            }
            RdbTable table = (RdbTable)pem.getParent();
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("nd(" + fn + ") FieldName, field=" + nd.getFieldName() + " / column name=" + pem.getName() + " in the table: " + table.getName() + "with alias:" + table.getAliasName()));
            }
            if ((rgt = (RdbGenTable)rgi.tables.get(table.getAliasName())) == null) {
                Iterator it = rgi.tables.values().iterator();
                while (it.hasNext()) {
                    RdbGenTable rdbgt = (RdbGenTable)it.next();
                    if (!rdbgt.tableName.equals(table.getName())) continue;
                    rgt = rdbgt;
                }
            }
            if (rgt == null) {
                throw new NullPointerException("No table " + table.getName() + " with alias:" + table.getAliasName() + " found among: " + rgi.tables);
            }
            rgr.refColumn = rgt.getColumn(pem.getName());
            if (rgt.joins != null) {
                this.getJoin(rgt, pem, nd.getFieldName(), rgr);
            }
        } else {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("nd(" + fn + ") CommpositeName, cnId=" + cnid));
            }
            rgr.cnId = cnid;
            rgr.cnName = nd.getNameRef().getCompositeName().getName();
            rgr.cnPackage = ((Package)nd.getNameRef().getCompositeName().getParent()).getName();
            rgr.cnFieldColumns = new TreeMap();
            Iterator itp = nd.getNameRef().getProjection().entrySet().iterator();
            RdbPrimitiveElementMapping pem = null;
            while (itp.hasNext()) {
                RdbGenTable rgt;
                Map.Entry me = itp.next();
                String cnfield = (String)me.getKey();
                String clafn = (String)me.getValue();
                pem = (RdbPrimitiveElementMapping)cm.getPrimitiveElementMapping(clafn, true);
                if (pem == null) {
                    throw new PException("Unable to find the mapping of the field " + nd.getFieldName());
                }
                RdbTable table = (RdbTable)pem.getParent();
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("nd(" + fn + ") composite field name=" + cnfield + " /  class field name=" + clafn + " / column name=" + pem.getName() + " in the table: " + table.getName() + "with alias:" + table.getAliasName()));
                }
                if ((rgt = (RdbGenTable)rgi.tables.get(table.getAliasName())) == null) {
                    Iterator it = rgi.tables.values().iterator();
                    while (it.hasNext()) {
                        RdbGenTable rdbgt = (RdbGenTable)it.next();
                        if (!rdbgt.tableName.equals(table.getName())) continue;
                        rgt = rdbgt;
                    }
                }
                if (rgt == null) {
                    throw new PException("Cannot find gen table " + table.getName() + " with alias " + table.getAliasName());
                }
                RdbGenColumn c = rgt.getColumn(pem.getName());
                rgr.cnFieldColumns.put(cnfield, c);
                if (rgr.join != null || rgt.joins == null) continue;
                this.getJoin(rgt, pem, clafn, rgr);
            }
        }
        return rgr;
    }

    private void getJoin(RdbGenTable rgt, RdbPrimitiveElementMapping pem, String fn, RdbGenRef rgr) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getJoin: fn: " + rgr.fieldName + " / col: " + pem.getName() + " / rgt: " + rgt.tableName));
        }
        if (rgt.joins.size() == 1) {
            rgr.join = (RdbGenJoin)rgt.joins.get(0);
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("return: fn: " + rgr.fieldName + " / col: " + pem.getName() + " / join: " + rgr.join.joinIdx));
            }
        }
        Iterator it = pem.getPrimitiveElementByRdbJoin().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me2 = it.next();
            PrimitiveElement pe = (PrimitiveElement)me2.getValue();
            if (!pe.getName().equals(fn)) continue;
            rgr.join = (RdbGenJoin)rgt.jn2join.get(((RdbJoin)me2.getKey()).getName());
            if (!this.debug) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("return fn: " + rgr.fieldName + " / col: " + pem.getName() + " / joinName: " + ((RdbJoin)me2.getKey()).getName() + " / join: " + rgr.join.joinIdx));
        }
    }

    private void getInheritedData(RdbClassMapping cm, RdbGenInfos rgi, Class constantHolderClass, Map ctx) throws PException {
        Iterator pcmit = cm.getParentClassMappings().iterator();
        while (pcmit.hasNext()) {
            RdbClassMapping superClassMapping;
            ParentClassMapping pcm = (ParentClassMapping)pcmit.next();
            if (!cm.inheritsStructures(pcm)) continue;
            Class superClass = pcm.getMOClass();
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("rule-name = " + pcm.getRuleName() + "=<" + superClass.getFQName() + ">" + " abstract =<" + superClass.isAbstract() + ">"));
            }
            if ((superClassMapping = (RdbClassMapping)superClass.getClassMapping(cm.getProjectName(), cm.getMapperName())).getMainRdbTable() == null) continue;
            RdbGenInfos superGenInfos = this.createRdbGenInfosContext((RdbMapping)superClassMapping.getParent(), constantHolderClass, ctx);
            if (rgi.mainTable == null) {
                rgi.mainTable = superGenInfos.mainTable;
            }
            this.addColumnUnique(superGenInfos.readableColumns, rgi.readableColumns, true);
            rgi.genRefs.putAll(superGenInfos.genRefs);
            rgi.tables.putAll(superGenInfos.tables);
        }
    }

    private void printColumns(List columns) {
        RdbGenColumn rgc = null;
        for (int i = 0; i < columns.size(); ++i) {
            rgc = (RdbGenColumn)columns.get(i);
            this.logger.log(BasicLevel.DEBUG, (Object)("\tcolumn : " + rgc.columnName + " isHiddenField: " + rgc.isHiddenField() + " isConstantField: " + (rgc.constant != null)));
        }
    }

    private class RGCComparator
    implements Comparator {
        private RGCComparator() {
        }

        public int compare(Object o1, Object o2) {
            RdbGenColumn rgc1 = (RdbGenColumn)o1;
            RdbGenColumn rgc2 = (RdbGenColumn)o2;
            return rgc1.columnName.compareTo(rgc2.columnName);
        }
    }
}

