/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.util;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisService2WSDL11;
import org.apache.axis2.description.AxisService2WSDL20;
import org.apache.axis2.description.java2wsdl.DefaultNamespaceGenerator;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.description.java2wsdl.Java2WSDLUtils;
import org.apache.axis2.description.java2wsdl.NamespaceGenerator;
import org.apache.axis2.description.java2wsdl.SchemaGenerator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.ws.java2wsdl.Java2WSDLBuilder;

public class Axis2Java2WSDLBuilder
extends Java2WSDLBuilder {
    public static final String ALL = "all";
    private OutputStream out;
    private String className;
    private ClassLoader classLoader;
    private String serviceName = null;
    private String targetNamespace = null;
    private String targetNamespacePrefix = null;
    private String style = "document";
    private String use = "literal";
    private String nsGenClassName = null;
    private String wsdlVersion = "1.1";
    private String schemaGenClassName = null;
    private boolean generateDocLitBare = false;
    private AxisConfiguration axisConfig;
    private String epr = null;

    public Axis2Java2WSDLBuilder(String epr, OutputStream out, String className, ClassLoader classLoader) {
        super(out, className, classLoader);
        try {
            ConfigurationContext configCtx = ConfigurationContextFactory.createDefaultConfigurationContext();
            this.axisConfig = configCtx.getAxisConfiguration();
            this.out = out;
            this.className = className;
            this.classLoader = classLoader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.epr = epr;
    }

    public void generateWSDL() throws Exception {
        SchemaGenerator schemaGenerator = this.resolveSchemaGen(this.classLoader, this.className, this.getSchemaTargetNamespace(), this.getSchemaTargetNamespacePrefix());
        ArrayList excludedOperation = new ArrayList();
        Utils.addExcludeMethods(excludedOperation);
        schemaGenerator.setExcludeMethods(excludedOperation);
        schemaGenerator.setAttrFormDefault(this.getAttrFormDefault());
        schemaGenerator.setElementFormDefault(this.getElementFormDefault());
        schemaGenerator.setExtraClasses(this.getExtraClasses());
        schemaGenerator.setNsGen(this.resolveNSGen());
        schemaGenerator.setPkg2nsmap(this.getPkg2nsMap());
        if (this.getPkg2nsMap() != null && !this.getPkg2nsMap().isEmpty() && (this.getPkg2nsMap().containsKey(ALL) || this.getPkg2nsMap().containsKey(ALL.toUpperCase()))) {
            schemaGenerator.setUseWSDLTypesNamespace(true);
        }
        HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
        Class inOnlyMessageReceiver = Loader.loadClass((String)"org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
        MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
        Class inoutMessageReceiver = Loader.loadClass((String)"org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
        AxisService service = new AxisService();
        schemaGenerator.setAxisService(service);
        AxisService axisService = AxisService.createService((String)this.className, (String)(this.serviceName == null ? Java2WSDLUtils.getSimpleClassName((String)this.className) : this.serviceName), (AxisConfiguration)this.axisConfig, messageReciverMap, (String)(this.targetNamespace == null ? Java2WSDLUtils.namespaceFromClassName((String)this.className, (ClassLoader)this.classLoader, (NamespaceGenerator)this.resolveNSGen()).toString() : this.targetNamespace), (ClassLoader)this.classLoader, (SchemaGenerator)schemaGenerator, (AxisService)service);
        schemaGenerator.setAxisService(axisService);
        axisService.setTargetNamespacePrefix(this.targetNamespacePrefix);
        axisService.setSchemaTargetNamespace(this.getSchemaTargetNamespace());
        axisService.setSchematargetNamespacePrefix(this.getSchemaTargetNamespacePrefix());
        axisService.setEPRs(new String[]{this.epr});
        this.axisConfig.addService(axisService);
        if ("1.1".equals(this.wsdlVersion)) {
            AxisService2WSDL11 g = new AxisService2WSDL11(axisService);
            g.setStyle(this.style);
            g.setUse(this.use);
            OMElement wsdlElement = g.generateOM();
            if (!this.isPretty()) {
                wsdlElement.serialize(this.out);
            } else {
                XMLPrettyPrinter.prettify((OMElement)wsdlElement, (OutputStream)this.out);
            }
        } else {
            AxisService2WSDL20 g = new AxisService2WSDL20(axisService);
            OMElement wsdlElement = g.generateOM();
            if (!this.isPretty()) {
                wsdlElement.serialize(this.out);
            } else {
                XMLPrettyPrinter.prettify((OMElement)wsdlElement, (OutputStream)this.out);
            }
        }
        this.out.flush();
        this.out.close();
    }

    private NamespaceGenerator resolveNSGen() {
        DefaultNamespaceGenerator nsGen;
        if (this.nsGenClassName == null) {
            nsGen = new DefaultNamespaceGenerator();
        } else {
            try {
                nsGen = (NamespaceGenerator)Class.forName(this.nsGenClassName).newInstance();
            }
            catch (Exception e) {
                nsGen = new DefaultNamespaceGenerator();
            }
        }
        return nsGen;
    }

    private SchemaGenerator resolveSchemaGen(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) throws Exception {
        Object schemaGen;
        if (this.schemaGenClassName == null) {
            schemaGen = this.generateDocLitBare ? new DocLitBareSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null) : new DefaultSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null);
        } else {
            try {
                Class<?> clazz = Class.forName(this.schemaGenClassName);
                Constructor<?> constructor = clazz.getConstructor(ClassLoader.class, String.class, String.class, String.class);
                schemaGen = (SchemaGenerator)constructor.newInstance(loader, className, schematargetNamespace, schematargetNamespacePrefix);
            }
            catch (Exception e) {
                schemaGen = this.generateDocLitBare ? new DocLitBareSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null) : new DefaultSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null);
            }
        }
        return schemaGen;
    }
}

