/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.security.SecurityClassLoad;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class JspRuntimeContext {
    private Log log = LogFactory.getLog(JspRuntimeContext.class);
    private int jspReloadCount;
    private ServletContext context;
    private Options options;
    private URLClassLoader parentClassLoader;
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String classpath;
    private long lastCheck = -1L;
    private Map<String, JspServletWrapper> jsps = new ConcurrentHashMap<String, JspServletWrapper>();

    public JspRuntimeContext(ServletContext context, Options options) {
        this.context = context;
        this.options = options;
        this.parentClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        }
        if (this.log.isDebugEnabled()) {
            if (this.parentClassLoader != null) {
                this.log.debug(Localizer.getMessage("jsp.message.parent_class_loader_is", this.parentClassLoader.toString()));
            } else {
                this.log.debug(Localizer.getMessage("jsp.message.parent_class_loader_is", "<none>"));
            }
        }
        this.initClassPath();
        if (context instanceof JspCServletContext) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            this.initSecurity();
        }
        String appBase = context.getRealPath("/");
        if (!options.getDevelopment() && appBase != null && options.getCheckInterval() > 0) {
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return this.jsps.get(jspUri);
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public URLClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        Iterator<JspServletWrapper> servlets = this.jsps.values().iterator();
        while (servlets.hasNext()) {
            servlets.next().destroy();
        }
    }

    public synchronized void incrementJspReloadCount() {
        ++this.jspReloadCount;
    }

    public synchronized void setJspReloadCount(int count) {
        this.jspReloadCount = count;
    }

    public int getJspReloadCount() {
        return this.jspReloadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCompile() {
        if (this.lastCheck < 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now <= this.lastCheck + (long)this.options.getCheckInterval() * 1000L) {
            return;
        }
        this.lastCheck = now;
        Object[] wrappers = this.jsps.values().toArray();
        for (int i = 0; i < wrappers.length; ++i) {
            JspServletWrapper jsw = (JspServletWrapper)wrappers[i];
            JspCompilationContext ctxt = jsw.getJspEngineContext();
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                try {
                    ctxt.compile();
                }
                catch (FileNotFoundException ex) {
                    ctxt.incrementRemoved();
                }
                catch (Throwable t) {
                    jsw.getServletContext().log("Background compile failed", t);
                }
                continue;
            }
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    private void initClassPath() {
        URL[] urls = this.parentClassLoader.getURLs();
        StringBuffer cpath = new StringBuffer();
        String sep = System.getProperty("path.separator");
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].getProtocol().equals("file")) continue;
            cpath.append(urls[i].getFile() + sep);
        }
        cpath.append(this.options.getScratchDir() + sep);
        String cp = (String)this.context.getAttribute(Constants.SERVLET_CLASSPATH);
        if (cp == null || cp.equals("")) {
            cp = this.options.getClassPath();
        }
        this.classpath = cpath.toString() + cp;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compilation classpath initialized: " + this.getClassPath());
        }
    }

    private void initSecurity() {
        Policy policy = Policy.getPolicy();
        if (policy != null) {
            try {
                String codeBase;
                String docBase = this.context.getRealPath("/");
                if (docBase == null) {
                    docBase = this.options.getScratchDir().toString();
                }
                if (!(codeBase = docBase).endsWith(File.separator)) {
                    codeBase = codeBase + File.separator;
                }
                File contextDir = new File(codeBase);
                URL url = contextDir.getCanonicalFile().toURL();
                this.codeSource = new CodeSource(url, (Certificate[])null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                if (!docBase.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(docBase, "read"));
                    docBase = docBase + File.separator;
                } else {
                    this.permissionCollection.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                }
                docBase = docBase + "-";
                this.permissionCollection.add(new FilePermission(docBase, "read"));
                String workDir = this.options.getScratchDir().toString();
                if (!workDir.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(workDir, "read,write"));
                    workDir = workDir + File.separator;
                }
                workDir = workDir + "-";
                this.permissionCollection.add(new FilePermission(workDir, "read,write,delete"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = this.parentClassLoader.getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    for (int i = 0; i < urls.length; ++i) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl != null || !urls[i].toString().startsWith("jar:jndi:")) continue;
                        jarUrl = urls[i].toString();
                        jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                        jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                    }
                    if (jarUrl != null) {
                        this.permissionCollection.add(new FilePermission(jarUrl, "read"));
                        this.permissionCollection.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        this.permissionCollection.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (Exception e) {
                this.context.log("Security Init for context failed", (Throwable)e);
            }
        }
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(((Object)((Object)factory)).getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.jasper.";
            try {
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        JspFactory.setDefaultFactory((JspFactory)factory);
    }
}

