/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader = null;

    public ClassLoaderObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return Class.forName(desc.getName(), false, this.classLoader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfacesName) throws IOException, ClassNotFoundException {
        Class[] interfaces = new Class[interfacesName.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = Class.forName(interfacesName[i], false, this.classLoader);
        }
        try {
            return Proxy.getProxyClass(this.classLoader, interfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

