/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class JAXBTypesafeEnumConverter
implements Converter {
    String enumClassName;
    Class enumClass;
    Method fromStringMethod;

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return objectValue;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        Object result = null;
        try {
            result = this.fromStringMethod.invoke((Object)this.enumClass, dataValue);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingFromStringMethod(ex, this.enumClass.getName());
        }
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        if (this.getEnumClass() == null) {
            if (this.getEnumClassName() == null) {
                throw XMLMarshalException.enumClassNotSpecified();
            }
            try {
                this.enumClass = session.getDatasourcePlatform().getConversionManager().getLoader().loadClass(this.enumClassName);
            }
            catch (Exception e) {
                throw XMLMarshalException.invalidEnumClassSpecified(e, this.enumClassName);
            }
        }
        try {
            this.fromStringMethod = this.enumClass.getMethod("fromString", String.class);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingFromStringMethod(ex, this.enumClass.getName());
        }
    }

    public String getEnumClassName() {
        return this.enumClassName;
    }

    public void setEnumClassName(String newClassName) {
        this.enumClassName = newClassName;
    }

    public void setEnumClass(Class enumClass) {
        this.enumClass = enumClass;
    }

    public Class getEnumClass() {
        return this.enumClass;
    }
}

