/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.metadata.structures;

import java.io.Serializable;
import java.util.Arrays;

public final class JClass
implements Serializable {
    private static final long serialVersionUID = -977433124031808986L;
    private int version;
    private int access;
    private String name;
    private String signature;
    private String superName;
    private String[] interfaces;

    public JClass(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.version = version;
        this.access = access;
        if (name == null) {
            throw new IllegalArgumentException("Name argument of JClass constructor can not be null");
        }
        this.name = name;
        this.signature = signature;
        if (superName == null) {
            throw new IllegalArgumentException("SuperName argument of JClass constructor can not be null");
        }
        this.superName = superName;
        String[] tmpInterfaces = interfaces;
        this.interfaces = tmpInterfaces != null ? (String[])tmpInterfaces.clone() : null;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAccess() {
        return this.access;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String[] getInterfaces() {
        if (this.interfaces != null) {
            return (String[])this.interfaces.clone();
        }
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JClass)) {
            return false;
        }
        JClass jClass = (JClass)obj;
        return this.version == jClass.version && this.access == jClass.access && this.name.equals(jClass.name) && this.superName.equals(jClass.superName) && Arrays.deepEquals(this.interfaces, jClass.interfaces);
    }

    public String toString() {
        return this.name.replace('/', '.');
    }
}

