/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlanFragment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherFactoryException;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.plan.repository.impl.CustomRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsResourceFetcherFactoryImpl
implements IResourceFetcherFactory {
    private Class<? extends IResourceFetcher> fetcherClass = null;
    private IRepositoryManager repositoryManager = null;
    protected File localRepositoriesBaseDir = null;
    protected List<IResourceFetcher> resourceFetchers = new ArrayList<IResourceFetcher>();

    public IResourceFetcher getResourceFetcher(DeploymentPlanFragment fragment) throws FetcherFactoryException {
        Class<?> fragmentClass = fragment.getClass();
        if (fragmentClass != this.getSupportedClass()) {
            throw new FetcherFactoryException("This Repository Fetcher Factory can't create fetchers for repository type " + fragmentClass);
        }
        String repository = fragment.getRepositoryRef();
        IResourceFetcher fetcher = null;
        try {
            Constructor<? extends IResourceFetcher> constructor = this.fetcherClass.getConstructor(new Class[0]);
            fetcher = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FetcherFactoryException((Throwable)e);
        }
        if (repository == null) {
            fetcher.setRepositoryManager(this.repositoryManager);
        } else {
            Repository rep = this.repositoryManager.getRepositoryById(repository);
            if (rep == null) {
                throw new FetcherFactoryException("There is no repository with id {0}" + repository);
            }
            CustomRepositoryManager newManager = new CustomRepositoryManager(rep);
            fetcher.setRepositoryManager((IRepositoryManager)newManager);
        }
        fetcher.setLocalRepositoriesBaseDir(this.localRepositoriesBaseDir);
        try {
            fetcher.setDeployment(fragment);
        }
        catch (InvalidDeploymentException e) {
            throw new FetcherFactoryException((Throwable)e);
        }
        this.resourceFetchers.add(fetcher);
        return fetcher;
    }

    public void setFetcherConcreteClass(Class<? extends IResourceFetcher> clazz) {
        this.fetcherClass = clazz;
    }

    public Class<? extends IResourceFetcher> getFetcherConcreteClass() {
        return this.fetcherClass;
    }

    public void setRepositoryManager(IRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public IRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setLocalRepositoriesBaseDir(File localRepositoriesBaseDir) {
        for (IResourceFetcher resourceFetcher : this.resourceFetchers) {
            resourceFetcher.setLocalRepositoriesBaseDir(localRepositoriesBaseDir);
        }
        this.localRepositoriesBaseDir = localRepositoriesBaseDir;
    }
}

