/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ant.extensions;

import java.io.File;
import java.io.IOException;
import org.apache.cxf.ant.extensions.CxfAntTask;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.java2wsdl.JavaToWSDL;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Java2WSDLTask
extends CxfAntTask {
    private Path classpath;
    private File wsdlDir;
    private String protocol;
    private String className;

    public void setGenwsdl(boolean gw) {
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path c) {
        if (this.classpath == null) {
            this.classpath = c;
        } else {
            this.classpath.append(c);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setProtocol(String p) {
        this.protocol = p;
    }

    public void setResourcedestdir(File f) {
        this.wsdlDir = f;
    }

    public void setSei(String clz) {
        this.className = clz;
    }

    public void execute() throws BuildException {
        this.buildCommandLine();
        LogStreamHandler log = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)log);
        exe.setAntRun(this.getProject());
        exe.setCommandline(this.cmd.getCommandline());
        try {
            int rc = exe.execute();
            if (exe.killedProcess() || rc != 0) {
                throw new BuildException("java2wsdl failed", this.getLocation());
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public void buildCommandLine() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Path runCp = new Path(this.getProject());
        if (loader instanceof AntClassLoader) {
            runCp = new Path(this.getProject(), ((AntClassLoader)loader).getClasspath());
        }
        this.cmd.createClasspath(this.getProject()).append(runCp);
        this.cmd.createVmArgument().setLine("-Djava.util.logging.config.file=");
        this.cmd.setClassname(JavaToWSDL.class.getName());
        if (this.classpath != null && !this.classpath.toString().equals("")) {
            this.cmd.createArgument().setValue("-cp");
            this.cmd.createArgument().setPath(this.classpath);
        }
        if (null != this.classesDir && !StringUtils.isEmpty((String)this.classesDir.getName())) {
            this.cmd.createArgument().setValue("-classdir");
            this.cmd.createArgument().setFile(this.classesDir);
        }
        if (null != this.sourcesDir && !StringUtils.isEmpty((String)this.sourcesDir.getName())) {
            this.cmd.createArgument().setValue("-s");
            this.cmd.createArgument().setFile(this.sourcesDir);
        }
        if (this.verbose) {
            this.cmd.createArgument().setValue("-verbose");
        }
        if ("Xsoap1.2".equals(this.protocol)) {
            this.cmd.createArgument().setValue("-soap12");
        }
        this.cmd.createArgument().setValue("-createxsdimports");
        if (null != this.wsdlDir && !StringUtils.isEmpty((String)this.wsdlDir.getName())) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.wsdlDir);
        }
        if (!StringUtils.isEmpty((String)this.className)) {
            this.cmd.createArgument().setValue(this.className);
        }
    }
}

