/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix.util;

import java.io.File;
import java.net.MalformedURLException;
import org.ow2.jonas.launcher.felix.util.IOUtils;

public final class Maven2Utils {
    private static final String PROP_M2_REPOSITORY = "m2.repository";
    private static final String PATH_DEFAULT_REPOSITORY = ".m2/repository";

    private Maven2Utils() {
    }

    public static String getBundleMaven2Location(String repository, String groupId, String artifactId, String version, String classifier) throws MalformedURLException {
        String appendedClassifier = "";
        if (classifier != null) {
            appendedClassifier = appendedClassifier.concat("-").concat(classifier);
        }
        String path = Maven2Utils.constructDirectoryPath(groupId, artifactId, version);
        File bundle = new File(repository, path.concat(File.separator).concat(artifactId).concat("-").concat(version).concat(appendedClassifier).concat(".jar"));
        return bundle.toURI().toURL().toExternalForm();
    }

    public static File getMaven2Repository() {
        File myRepository = null;
        String m2Repository = System.getProperty(PROP_M2_REPOSITORY);
        if (m2Repository == null) {
            String userHome = System.getProperty("user.home");
            myRepository = IOUtils.getSystemFile(new File(userHome), PATH_DEFAULT_REPOSITORY);
        } else {
            myRepository = new File(m2Repository);
        }
        return myRepository;
    }

    private static String constructDirectoryPath(String groupId, String artifactId, String version) {
        String transformed = groupId.replace('.', File.separatorChar);
        return transformed.concat(File.separator).concat(artifactId).concat(File.separator).concat(version);
    }
}

