/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.reference;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.reference.CMIProxyHandle;
import org.ow2.cmi.rpc.CMIInvocationHandler;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class CMIProxySerializer {
    private static final Log LOGGER = LogFactory.getLog(CMIProxySerializer.class);
    private static ClusterViewManager clusterViewManager = null;

    private CMIProxySerializer() {
    }

    public static byte[] serialize(CMIProxy object) {
        ByteArrayOutputStream bOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bOutputStream);
            objectOutputStream.writeObject(Proxy.getInvocationHandler(object));
            objectOutputStream.flush();
            return bOutputStream.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Cannot serialize the object {0}", new Object[]{object, e});
            return null;
        }
    }

    public static CMIProxy unserialize(CMIProxyHandle proxyHandle) {
        Class<?> interf;
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (clusterViewManager == null) {
            clusterViewManager = ClusterViewManagerFactory.getFactory().getClusterViewManager();
        }
        String objectName = proxyHandle.getObjectName();
        try {
            clusterViewManager.addObjectToWatch(objectName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot retrieve the object for name {0}", new Object[]{objectName, e});
            return null;
        }
        String classname = proxyHandle.getInterfaceName();
        try {
            interf = Class.forName(classname, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot load the interface with name {0}", new Object[]{classname, e});
            return null;
        }
        try {
            ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(proxyHandle.getSerializedCMIInvocationHandler())){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    return Class.forName(name, false, classLoader);
                }
            };
            CMIInvocationHandler invocationHandler = (CMIInvocationHandler)stream.readObject();
            invocationHandler.setCmiProxyHandle(proxyHandle);
            return (CMIProxy)Proxy.newProxyInstance(classLoader, new Class[]{interf, CMIProxy.class}, (InvocationHandler)invocationHandler);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot unserialize", new Object[]{e});
            return null;
        }
    }
}

