/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.filter.rdb.lib;

import org.objectweb.medor.expression.api.CalculatedParameterOperand;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.AbstractCalculatedParameterOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;

public class Like2SQLStringConverter
extends AbstractCalculatedParameterOperand
implements CalculatedParameterOperand {
    private static final long serialVersionUID = 1L;
    CalculatedParameterOperand cpo;

    public Like2SQLStringConverter() {
    }

    public Like2SQLStringConverter(BasicParameterOperand po) {
        super(po);
        if (po instanceof CalculatedParameterOperand) {
            this.cpo = (CalculatedParameterOperand)((Object)po);
        }
    }

    public static String convert(String str) {
        str = Like2SQLStringConverter.replaceString(".*", "%", str);
        str = Like2SQLStringConverter.replaceString(".", "_", str);
        return str;
    }

    public void evaluate(ParameterOperand[] pos) throws ExpressionException {
        ParameterOperand po = this.getPO(pos);
        if (po == null) {
            throw new ExpressionException("Impossible to evaluate this parameter wihtout the parameter " + this.name);
        }
        if (this.cpo == null) {
            this.setValue(Like2SQLStringConverter.convert(po.getString()));
        } else {
            this.cpo.evaluate(pos);
            this.setValue(Like2SQLStringConverter.convert(this.cpo.getString()));
        }
    }

    public static String replaceString(String old, String neo, String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int oldSize = old.length();
        int neoSize = neo.length();
        StringBuffer sb = new StringBuffer(str);
        int begin = 0;
        int idx = sb.indexOf(old, begin);
        while (idx != -1) {
            sb.delete(idx, idx + oldSize);
            sb.insert(idx, neo);
            begin = idx + neoSize;
            if (begin < sb.length()) {
                idx = sb.indexOf(old, begin);
                continue;
            }
            idx = -1;
        }
        return sb.toString();
    }
}

