/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.notifications;

import fr.dyade.aaa.agent.AgentId;
import java.util.Iterator;
import java.util.Vector;
import org.objectweb.joram.mom.notifications.AbstractRequest;
import org.objectweb.joram.shared.messages.Message;

public class ClientMessages
extends AbstractRequest {
    private static final long serialVersionUID = 1L;
    private Message message = null;
    private Vector messages = null;
    private boolean asyncSend;

    public ClientMessages(int clientContext, int requestId) {
        super(clientContext, requestId);
    }

    public ClientMessages(int clientContext, int requestId, Message message) {
        super(clientContext, requestId);
        this.message = message;
        this.setExpiration(message.expiration);
        this.setPriority(message.priority);
    }

    public ClientMessages(int clientContext, int requestId, Vector messages) {
        super(clientContext, requestId);
        if (messages.size() == 1) {
            this.message = (Message)messages.get(0);
            this.setExpiration(this.message.expiration);
            this.setPriority(this.message.priority);
        } else {
            long newExpiration = -1L;
            int newPriority = 0;
            Iterator iterator = messages.iterator();
            while (iterator.hasNext()) {
                Message msg = (Message)iterator.next();
                if (newExpiration != 0L && (msg.expiration > newExpiration || msg.expiration == 0L)) {
                    newExpiration = msg.expiration;
                }
                if (msg.priority <= newPriority) continue;
                newPriority = msg.priority;
            }
            this.messages = messages;
            this.setExpiration(newExpiration);
            this.setPriority(newPriority);
        }
    }

    public ClientMessages() {
    }

    public void addMessage(Message msg) {
        if (this.message == null && this.messages == null) {
            this.message = msg;
            this.setExpiration(this.message.expiration);
            this.setPriority(this.message.priority);
        } else {
            if (this.messages == null) {
                this.messages = new Vector();
                this.messages.add(this.message);
                this.message = null;
            }
            if (this.getExpiration() != 0L && (msg.expiration > this.getExpiration() || msg.expiration == 0L)) {
                this.setExpiration(msg.expiration);
            }
            if (msg.priority > this.getPriority()) {
                this.setPriority(msg.priority);
            }
            this.messages.add(msg);
        }
    }

    public void setDMQId(AgentId dmqId) {
        this.setDeadNotificationAgentId(dmqId);
    }

    public Vector getMessages() {
        if (this.messages == null) {
            this.messages = new Vector();
            if (this.message != null) {
                this.messages.add(this.message);
            }
        }
        return this.messages;
    }

    public void setAsyncSend(boolean b) {
        this.asyncSend = b;
    }

    public final boolean getAsyncSend() {
        return this.asyncSend;
    }

    public AgentId getDMQId() {
        return this.getDeadNotificationAgentId();
    }

    public StringBuffer toString(StringBuffer output) {
        output.append('(');
        super.toString(output);
        output.append(",message=").append(this.message);
        output.append(",messages=").append(this.messages);
        output.append(",asyncSend=").append(this.asyncSend);
        output.append(')');
        return output;
    }
}

