/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PPrefetchTupleCollection;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.lib.PClassMappingDecoder;
import org.objectweb.jorm.mapper.rdb.lib.PMapperRdb;
import org.objectweb.jorm.mapper.rdb.lib.RdbPPolymorphicClass;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.eval.prefetch.api.PrefetchBufferFactory;
import org.objectweb.medor.eval.prefetch.api.PrefetchBufferHolder;
import org.objectweb.medor.eval.prefetch.lib.IntermediaryPrefetchBufferImpl;
import org.objectweb.medor.eval.prefetch.lib.PrefetchBufferFactoryImpl;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class RdbTupleCollection
implements PPrefetchTupleCollection,
Tuple,
PrefetchBufferHolder {
    private ResultSet resultSet;
    private PreparedStatement preparedStatement;
    private int pnameIndex;
    private RdbAdapter rdbAdapter;
    private PrefetchBuffer prefetchBuffer;
    private PClassMapping pclassMapping;
    private Object pnameGetter;
    private static PrefetchBufferFactory pbf = new PrefetchBufferFactoryImpl();
    private int pos = 0;
    private Logger logger;

    public RdbTupleCollection(Object txctx, ResultSet rs, PreparedStatement ps, int pi, Logger l, PClassMapping pcm, boolean withSubType, Object png) throws MedorException, SQLException {
        this.logger = l;
        this.logger.log(BasicLevel.DEBUG, (Object)"TupleCollection creation");
        this.resultSet = rs;
        this.preparedStatement = ps;
        this.pnameIndex = pi;
        this.rdbAdapter = ((PMapperRdb)pcm.getPMapper()).getRdbAdapter();
        this.pclassMapping = pcm;
        this.pnameGetter = png;
        boolean isPolymorphic = pcm instanceof RdbPPolymorphicClass && withSubType;
        this.prefetchBuffer = pcm.getPMapper().getPrefetchCache().createPrefetchBuffer(pbf, pcm, txctx, pi, !isPolymorphic);
        this.prefetchBuffer.setTupleCollection(this);
        if (isPolymorphic) {
            IntermediaryPrefetchBufferImpl ipb = new IntermediaryPrefetchBufferImpl(this.prefetchBuffer, pcm.getIndexesTable(pcm));
            if (!pcm.getPMapper().getPrefetchCache().registerPrefetchBuffer(ipb, pcm, txctx)) {
                throw new MedorException("No prefetch buffer registered for the pcm " + pcm.getClassName() + ".");
            }
            try {
                PClassMapping[] subPCMs = pcm.getSubPCMs();
                if (subPCMs != null) {
                    for (int i = 0; i < subPCMs.length; ++i) {
                        IntermediaryPrefetchBufferImpl intermediaryPb = new IntermediaryPrefetchBufferImpl(this.prefetchBuffer, subPCMs[i].getIndexesTable(pcm));
                        if (subPCMs[i].getPMapper().getPrefetchCache().registerPrefetchBuffer(intermediaryPb, subPCMs[i], txctx)) continue;
                        throw new MedorException("No prefetch buffer registered for the pcm " + subPCMs[i].getClassName() + ".");
                    }
                }
            }
            catch (Exception e) {
                throw new MedorException("Error while trying to register the prefetchBuffer with the subclasses. ", e);
            }
        }
    }

    public PrefetchBuffer getPrefetchBuffer() {
        return this.prefetchBuffer;
    }

    public int getPNameIndex() {
        return this.pnameIndex;
    }

    public TupleStructure getMetaData() throws MedorException {
        return null;
    }

    public boolean isLast() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.resultSet.isLast();
        }
        catch (SQLException sqlex) {
            throw new MedorException(sqlex);
        }
    }

    public void close() throws MedorException {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
                this.preparedStatement.close();
            }
            catch (SQLException e) {
                throw new MedorException("Impossible to close the result set: ", e);
            }
            finally {
                this.resultSet = null;
                this.preparedStatement = null;
            }
        }
    }

    public boolean next() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            if (this.resultSet.next()) {
                ++this.pos;
                this.logger.log(BasicLevel.DEBUG, (Object)"resultset.next()=true");
                return true;
            }
            this.pos = this.resultSet.getRow();
            this.logger.log(BasicLevel.DEBUG, (Object)"resultset.next()=false");
            return false;
        }
        catch (SQLException sqlex) {
            throw new MedorException(sqlex);
        }
    }

    public void first() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            if (!this.resultSet.first()) {
                throw new MedorException("can't move the cursor to the first row");
            }
            this.pos = 1;
            this.logger.log(BasicLevel.DEBUG, (Object)"resultset.previous()=true");
        }
        catch (SQLException ex) {
            throw new MedorException(ex);
        }
    }

    public int getRow() throws MedorException {
        return this.pos;
    }

    public Tuple getTuple() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        return this;
    }

    public Tuple getTuple(int row) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.row(row);
        return this;
    }

    public boolean isEmpty() throws MedorException {
        throw new MedorException("No need to support it here!!");
    }

    public boolean row(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        try {
            this.logger.log(BasicLevel.DEBUG, (Object)("resultSet.absolute(" + i + ")"));
            if (this.pos == i) {
                return true;
            }
            if (i == 1) {
                this.first();
                return true;
            }
            if (this.pos == i - 1) {
                return this.next();
            }
            if (this.resultSet.absolute(i)) {
                this.pos = i;
                return true;
            }
            return false;
        }
        catch (SQLException sqlex) {
            throw new MedorException(sqlex);
        }
    }

    public int getSize() {
        try {
            return this.resultSet.getMetaData().getColumnCount() + 1;
        }
        catch (SQLException e) {
            return -1;
        }
    }

    public Operand[] toOperandArray() {
        return null;
    }

    public boolean getBoolean(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getBoolean(this.resultSet, i >= this.pnameIndex ? i - 1 : i, false);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public byte getByte(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getByte(this.resultSet, i >= this.pnameIndex ? i - 1 : i, (byte)0);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public byte[] getByteArray(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getByteArray(this.resultSet, i >= this.pnameIndex ? i - 1 : i, null);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public char getChar(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getChar(this.resultSet, i >= this.pnameIndex ? i - 1 : i, '\u0000');
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public char[] getCharArray(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getCharArray(this.resultSet, i >= this.pnameIndex ? i - 1 : i, null);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public Date getDate(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getDate(this.resultSet, i >= this.pnameIndex ? i - 1 : i, null);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public double getDouble(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getDouble(this.resultSet, i >= this.pnameIndex ? i - 1 : i, 0.0);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public float getFloat(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getFloat(this.resultSet, i >= this.pnameIndex ? i - 1 : i, 0.0f);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public int getInt(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getInt(this.resultSet, i >= this.pnameIndex ? i - 1 : i, -1);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public Operand getLikeOperand(int i) throws MedorException {
        return null;
    }

    public long getLong(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getLong(this.resultSet, i >= this.pnameIndex ? i - 1 : i, -1L);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public Object getObject(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            if (i == this.pnameIndex) {
                return ((PClassMappingDecoder)((Object)this.pclassMapping)).decode(this.resultSet, this.pnameIndex, this.pnameGetter);
            }
            Object o = this.resultSet.getObject(i >= this.pnameIndex ? i - 1 : i);
            return this.resultSet.wasNull() ? null : o;
        }
        catch (SQLException sqlex) {
            throw new MedorException(sqlex);
        }
        catch (Exception e) {
            throw new MedorException("Invalid field index " + i, e);
        }
    }

    public short getShort(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getShort(this.resultSet, i >= this.pnameIndex ? i - 1 : i, (short)-1);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public BigDecimal getBigDecimal(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getBigDecimal(this.resultSet, i >= this.pnameIndex ? i - 1 : i, null);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public BigInteger getBigInteger(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            BigDecimal bd = this.rdbAdapter.getBigDecimal(this.resultSet, i >= this.pnameIndex ? i - 1 : i, null);
            return bd == null ? null : bd.toBigInteger();
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public String getString(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("numColumn=" + i));
        try {
            return this.rdbAdapter.getString(this.resultSet, i >= this.pnameIndex ? i - 1 : i, null);
        }
        catch (SQLException e) {
            throw new MedorException(e);
        }
    }

    public TupleCollection getTupleCollection(int i) throws MedorException {
        return this;
    }

    public boolean isDefined(int i) {
        try {
            return !this.resultSet.wasNull();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void invalidatePrefetchBuffer() throws MedorException {
        this.logger.log(BasicLevel.DEBUG, (Object)("Invalidating PrefetchBuffer " + this.prefetchBuffer + " for " + this));
        if (this.prefetchBuffer != null) {
            this.close();
            this.prefetchBuffer = null;
        } else {
            this.logger.log(BasicLevel.DEBUG, (Object)"The tupleCollection was closed earlier: closing it for real");
        }
    }
}

