/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.actionscheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureTaskReallyCancellable<E>
implements Runnable,
Future<E> {
    private Object mutex = new Object();
    private boolean cancelled;
    private boolean runned;
    private boolean runEnded;
    private Callable<E> callable;
    private E result;
    private ExecutionException exception;

    public FutureTaskReallyCancellable(Callable<E> callable) {
        this.callable = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean paramBoolean) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.cancelled || this.runned) {
                return false;
            }
            this.cancelled = true;
            this.mutex.notifyAll();
        }
        this.done();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.cancelled || this.runned) {
                return;
            }
            this.runned = true;
        }
        try {
            E result = this.callable.call();
            Object object2 = this.mutex;
            synchronized (object2) {
                this.runEnded = true;
                this.result = result;
                this.mutex.notifyAll();
            }
            this.done();
        }
        catch (Exception e) {
            Object object3 = this.mutex;
            synchronized (object3) {
                this.runEnded = true;
                this.exception = new ExecutionException(e);
                this.mutex.notifyAll();
            }
            this.done();
        }
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get() throws InterruptedException, ExecutionException {
        Object object = this.mutex;
        synchronized (object) {
            while (!this.cancelled && !this.runEnded) {
                this.mutex.wait();
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(long paramLong, TimeUnit paramTimeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeToWait = paramTimeUnit.toMillis(paramLong);
        if (timeToWait < 0L) {
            throw new IllegalArgumentException();
        }
        if (timeToWait == 0L) {
            Object object = this.mutex;
            synchronized (object) {
                if (!this.cancelled && !this.runEnded) {
                    throw new TimeoutException();
                }
            }
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.cancelled && !this.runEnded) {
                this.mutex.wait(timeToWait);
            }
            if (!this.cancelled && !this.runEnded) {
                throw new TimeoutException();
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mutex;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.cancelled && !this.runEnded) {
                return false;
            }
        }
        return true;
    }
}

