/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property.jmx;

import org.jboss.logging.Logger;
import org.jboss.util.property.jmx.SystemPropertyClassValueMBean;

public class SystemPropertyClassValue
implements SystemPropertyClassValueMBean {
    public static final Logger log = Logger.getLogger(SystemPropertyClassValue.class);
    protected String property;
    protected String className;

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void create() {
        Throwable error = SystemPropertyClassValue.setSystemPropertyClassValue(this.property, this.className);
        if (error != null) {
            log.trace("Error loading class " + this.className + " property " + this.property + " not set.", error);
        }
    }

    public static Throwable setSystemPropertyClassValue(String property, String className) {
        if (property == null || property.trim().length() == 0) {
            throw new IllegalArgumentException("Null or empty property");
        }
        if (className == null || className.trim().length() == 0) {
            throw new IllegalArgumentException("Null or empty class name");
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable problem) {
            return problem;
        }
        System.setProperty(property, className);
        return null;
    }
}

