/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.resolver;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.resolver.CommonJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBJNDIData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationJNDIResolver
extends CommonJNDIResolver
implements EZBApplicationJNDIResolver {
    private Map<URL, EZBContainerJNDIResolver> containersMap = new HashMap<URL, EZBContainerJNDIResolver>();

    public void addContainerJNDIResolver(EZBContainerJNDIResolver containerJNDIResolver) {
        this.containersMap.put(containerJNDIResolver.getURL(), containerJNDIResolver);
    }

    public List<EZBJNDIBeanData> getEJBJNDINames(String interfaceName) {
        return this.getEJBJNDINames(interfaceName, null);
    }

    public List<EZBJNDIBeanData> getEJBJNDINames(String interfaceName, String beanName) {
        return this.getEJBJNDINames(interfaceName, beanName, null);
    }

    public List<EZBJNDIBeanData> getEJBJNDINames(String interfaceName, String beanName, URL ejbLinkURL) {
        if (ejbLinkURL != null) {
            EZBContainerJNDIResolver containerJNDIResolver = this.containersMap.get(ejbLinkURL);
            if (containerJNDIResolver != null) {
                return containerJNDIResolver.getEJBJNDINames(interfaceName, beanName, false);
            }
            return Collections.emptyList();
        }
        Collection<EZBContainerJNDIResolver> containerJNDIResolvers = this.containersMap.values();
        if (containerJNDIResolvers == null) {
            return Collections.emptyList();
        }
        ArrayList<EZBJNDIBeanData> beanDataList = new ArrayList<EZBJNDIBeanData>();
        for (EZBContainerJNDIResolver containerJNDIResolver : containerJNDIResolvers) {
            beanDataList.addAll(containerJNDIResolver.getEJBJNDINames(interfaceName, beanName, false));
        }
        return beanDataList;
    }

    public List<EZBJNDIData> getMessageDestinationJNDINames(String messageDestinationName) {
        Collection<EZBContainerJNDIResolver> containerJNDIResolvers = this.containersMap.values();
        if (containerJNDIResolvers == null) {
            return Collections.emptyList();
        }
        ArrayList<EZBJNDIData> dataList = new ArrayList<EZBJNDIData>();
        for (EZBContainerJNDIResolver containerJNDIResolver : containerJNDIResolvers) {
            dataList.addAll(containerJNDIResolver.getMessageDestinationJNDINames(messageDestinationName, false));
        }
        return dataList;
    }
}

