/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.jta;

import java.util.Iterator;
import java.util.Map;
import javax.transaction.Synchronization;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.resource.internal.cm.ConnectionManagerImpl;
import org.ow2.jonas.resource.internal.cm.ManagedConnectionInfo;
import org.ow2.jonas.resource.internal.pool.Pool;

public class JSynchronization
implements Synchronization {
    private ManagedConnectionInfo mci = null;
    private ConnectionManagerImpl cm = null;

    public JSynchronization(ConnectionManagerImpl pCm, ManagedConnectionInfo pMci) {
        this.mci = pMci;
        this.cm = pCm;
        this.mci.synchro = this;
        this.cm.getSynchros().add(this.mci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        if (this.mci == null) {
            return;
        }
        Pool pool = this.cm.getPool();
        synchronized (pool) {
            this.mci.synchro = null;
            this.cm.getSynchros().remove(this.mci);
            if (!this.mci.usedCs.isEmpty()) {
                this.cm.getUsedManagedConnections().remove(this.mci.getGlobalTx());
                this.mci.setGlobalTx(null);
                if (ConnectionManagerImpl.poolTrace.isLoggable(BasicLevel.DEBUG)) {
                    ConnectionManagerImpl.poolTrace.log(BasicLevel.DEBUG, (Object)("state:\n" + this.cm.getState("\t")));
                }
            } else {
                try {
                    this.cm.getManagedConnectionsWithoutTransaction().remove(this.mci);
                    if (this.mci.getGlobalTx() != null) {
                        this.cm.getUsedManagedConnections().remove(this.mci.getGlobalTx());
                    } else {
                        Iterator it = this.cm.getUsedManagedConnections().entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry me = it.next();
                            if (!this.mci.equals(me.getValue())) continue;
                            it.remove();
                        }
                    }
                    this.mci.setGlobalTx(null);
                    this.cm.closePStmts(this.mci);
                    this.mci.mc.cleanup();
                    this.cm.getPool().releaseResource(this.mci.mc, false);
                    if (ConnectionManagerImpl.trace.isLoggable(BasicLevel.DEBUG)) {
                        ConnectionManagerImpl.trace.log(BasicLevel.DEBUG, (Object)("Later releasing of MC=" + this.mci.mc));
                    }
                    this.mci = null;
                    if (ConnectionManagerImpl.poolTrace.isLoggable(BasicLevel.DEBUG)) {
                        ConnectionManagerImpl.poolTrace.log(BasicLevel.DEBUG, (Object)("state\n" + this.cm.getState("\t")));
                    }
                }
                catch (Exception e) {
                    ConnectionManagerImpl.trace.log(BasicLevel.ERROR, (Object)"an error related during releasing of ManagedConnection", (Throwable)e, (Object)"MySynchro", (Object)"afterCompletion");
                }
            }
            this.mci = null;
            this.cm = null;
        }
    }

    public void beforeCompletion() {
    }
}

