/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.api.MOP;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.CommonHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.GenClass;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.type.api.PExceptionTyping;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.util.monolog.api.BasicLevel;

public class MappingGenerator
extends CommonGenerator {
    protected HashMap mmops = new HashMap();

    public MappingGenerator(JormCompilerConfigurator jcc, JormCompilerParameter cp) throws PException {
        Iterator it = jcc.knownMappers();
        while (it.hasNext()) {
            String mn = (String)it.next();
            this.mmops.put(mn, jcc.getMOPFactory(mn).createMappingMOP(cp, mn));
        }
    }

    public String[][] getTemplateLibraries() {
        String[][] res = new String[this.mmops.size()][];
        Iterator it = this.mmops.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            res[i] = ((MOP)it.next()).getTemplateLibraries();
            ++i;
        }
        return res;
    }

    public void generate(Class clazz, TargetHolder holder, JormCompilerParameter cp, JormCompilerConfigurator jcc) throws PException {
        this.concreteGenerate(clazz, holder, cp);
    }

    private void concreteGenerate(Class clazz, TargetHolder holder, JormCompilerParameter cp) throws PException {
        ClassProject cpr = null;
        Iterator it = clazz.getClassProjects().iterator();
        while (it.hasNext()) {
            ClassProject tmpCp = (ClassProject)it.next();
            if (!tmpCp.getProjectName().equals(cp.getProjectName())) continue;
            cpr = tmpCp;
            break;
        }
        if (cpr == null) {
            throw new PExceptionCompiler("Cannot find the relevant project!");
        }
        it = cpr.getMappings().iterator();
        while (it.hasNext()) {
            Mapping mo = (Mapping)it.next();
            this.concreteGenerateWithMapper(mo.getMapperName(), clazz, holder, cp, mo);
            this.logger.log(BasicLevel.INFO, (Object)("     -> \"" + mo.getMapperName() + "\" mapping generated."));
        }
    }

    private void concreteGenerateWithMapper(String mn, Class co, TargetHolder holder, JormCompilerParameter cp, Mapping mo) throws PException {
        Expression namingfilter;
        String pack;
        String packroot = pack = ((Package)co.getParent()).getName();
        if (cp.isGeneratedWithMapperPackage()) {
            pack = "".equals(pack) ? mn : pack + "." + mn;
        }
        String fileName = co.getName() + "Mapping";
        if (pack.length() > 0) {
            fileName = (pack + '.').replace('.', File.separatorChar) + fileName;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Generate the " + fileName + " class"));
        MOP mmop = (MOP)this.mmops.get(mo.getMapperName());
        VelocityContext ctx = new VelocityContext();
        ctx.put("abstractClass", new Boolean(co.isAbstract()));
        ctx.put("velocityengine", this.velocityEngine);
        ctx.put("holder", holder);
        ctx.put("class", co);
        ctx.put("mapping", mo);
        ctx.put("dependencies", mo.getClassMapping().getDependencies());
        if (pack.length() > 0) {
            ctx.put("package", pack);
            ctx.put("packageroot", packroot);
        }
        ctx.put("mappername", mn);
        ctx.put("noBindingCreation", new Boolean(cp.isBindingAbstract()));
        ctx.put("cparam", cp);
        CommonHelper ch = new CommonHelper();
        ch.setLogger(this.logger);
        ctx.put("containsCharArrayField", new Boolean(ch.containsCharArrayField(mo)));
        ctx.put("tools", (Object)ch);
        ctx.put("header", "org/objectweb/jorm/generator/lib/Header.vm");
        ctx.put("mappingTools", this);
        ctx.put("bindingTools", this);
        ((Loggable)mmop).setLogger(this.logger);
        List pems = mo.getClassMapping().getAllPrimitiveElementMappings();
        ctx.put("pemlist", pems.toArray(new PrimitiveElementMapping[pems.size()]));
        mmop.initContext(ctx, co, cp.getProjectName(), mn);
        ctx.put("useNamingKey", Boolean.FALSE);
        NameDef nd = mo.getClassMapping().getIdentifierMapping().getNameDef();
        Class ancestorClass = this.getAncestor(co);
        try {
            namingfilter = ancestorClass.getInheritanceFilter(nd);
        }
        catch (ExpressionException e) {
            throw new PException((Exception)((Object)e));
        }
        Object namingKey = co.getInheritanceNamingKey(nd);
        if (namingfilter != null && namingKey != null) {
            ctx.put("useNamingKey", Boolean.TRUE);
            PType namingKeyType = namingfilter.getType();
            ctx.put("namingKeyTypeStr", this.ptype2String(namingKeyType));
            String namingKeyStr = null;
            switch (namingKeyType.getTypeCode()) {
                case 0: {
                    if (!(namingKey instanceof Boolean)) break;
                    namingKeyStr = namingKey.toString();
                    break;
                }
                case 8: {
                    if (!(namingKey instanceof Boolean)) break;
                    namingKeyStr = (Boolean)namingKey != false ? "Boolean.TRUE" : "Boolean.FALSE";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    PType jlpt = this.getJavaLangPrimitive(namingKeyType);
                    if (namingKey instanceof String) {
                        namingKeyStr = jlpt.getJavaName() + ".valueOf" + "(\"" + namingKey.toString() + "\")";
                        break;
                    }
                    namingKeyStr = "new " + jlpt.getJavaName() + "((" + namingKeyType.getJavaName() + ") " + namingKey.toString() + ")";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (namingKey instanceof String) {
                        namingKeyStr = "new " + namingKeyType.getJavaName() + "(\"" + namingKey.toString() + "\")";
                        break;
                    }
                    namingKeyStr = "new " + namingKeyType.getJavaName() + "((" + this.getPrimitive(namingKeyType).getJavaName() + ") " + namingKey.toString() + ")";
                    break;
                }
                case 16: {
                    namingKeyStr = "\"" + namingKey.toString() + "\"";
                }
            }
            if (namingKey == null) {
                throw new PExceptionTyping("Naming key value no corresponding to the type of the filter: filter type: " + namingKeyType.getJavaName() + " / naming key value: " + namingKey);
            }
            ctx.put("namingKey", namingKeyStr);
        }
        ArrayList gcms = new ArrayList();
        this.getGenClassMapping(mo, cp.getProjectName(), gcms);
        ctx.put("gcms", gcms);
        List crms = this.getClassReferenceMapping(mo, cp.getProjectName());
        ctx.put("crms", crms);
        ctx.put("classND", nd);
        try {
            FileWriter fw = holder.getFileWriter(fileName + ".java");
            if (this.template == null) {
                this.template = this.velocityEngine.getTemplate("org/objectweb/jorm/generator/lib/Mapping.vm");
            }
            this.template.merge(ctx, fw);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while writing Mapping java file: " + fileName + ".java");
        }
    }

    private void abstractGenerate(Class clazz, TargetHolder holder, JormCompilerParameter cp) throws PException {
        HashSet mapperNames = new HashSet();
        this.getMapperNames(clazz, cp.getProjectName(), mapperNames);
        Iterator itMapperName = mapperNames.iterator();
        while (itMapperName.hasNext()) {
            boolean useNdName;
            String mapperName = (String)itMapperName.next();
            Collection nds = clazz.getNameDefs();
            Class classWithNd = clazz;
            while (nds.size() < 1 && classWithNd.getInheritedClassNumber() > 0) {
                classWithNd = (Class)classWithNd.getSuperClasses().iterator().next();
                nds = classWithNd.getNameDefs();
            }
            if (nds.size() < 1) {
                this.logger.log(BasicLevel.WARN, (Object)("AbstractClass: No NameDef defined for the class " + clazz.getFQName()));
                return;
            }
            Iterator it = nds.iterator();
            boolean bl = useNdName = nds.size() > 1;
            while (it.hasNext()) {
                NameDef nd = (NameDef)it.next();
                this.abstractGenerateWithNameDef(mapperName, clazz, holder, cp, nd, useNdName);
            }
        }
    }

    private void getMapperNames(Class clazz, String projectName, Set res) {
        if (clazz.isAbstract()) {
            Iterator itClass = clazz.getSubClasses().iterator();
            while (itClass.hasNext()) {
                Class subClass = (Class)itClass.next();
                this.getMapperNames(subClass, projectName, res);
            }
        } else {
            res.addAll(clazz.getClassProject(projectName).getMappers());
        }
    }

    /*
     * Loose catch block
     */
    private void abstractGenerateWithNameDef(String mapperName, Class clazz, TargetHolder holder, JormCompilerParameter cp, NameDef nd, boolean useNdName) throws PException {
        block16: {
            Collection ms;
            String packName = ((Package)clazz.getParent()).getName();
            if (cp.isGeneratedWithMapperPackage()) {
                packName = "".equals(packName) ? mapperName : packName + "." + mapperName;
            }
            String fileName = clazz.getName() + "Mapping";
            if (useNdName) {
                packName = packName != null && packName.length() > 0 ? packName + "." + nd.getName() : nd.getName();
            }
            if (packName.length() > 0) {
                fileName = (packName + '.').replace('.', File.separatorChar) + fileName;
            }
            this.logger.log(BasicLevel.DEBUG, (Object)("Generate the " + fileName + " class"));
            MOP mmop = (MOP)this.mmops.get(mapperName);
            VelocityContext ctx = new VelocityContext();
            ctx.put("class", clazz);
            if (packName.length() > 0) {
                ctx.put("package", packName);
            }
            ctx.put("cparam", cp);
            CommonHelper ch = new CommonHelper();
            ch.setLogger(this.logger);
            ctx.put("tools", (Object)ch);
            ctx.put("mappername", mapperName);
            ctx.put("noBindingCreation", Boolean.TRUE);
            ctx.put("abstractClass", Boolean.TRUE);
            ctx.put("header", "org/objectweb/jorm/generator/lib/Header.vm");
            ctx.put("mappingTools", this);
            ctx.put("classND", nd);
            ClassProject classproject = clazz.getClassProject(cp.getProjectName());
            ArrayList dependencies = new ArrayList();
            List pems = null;
            if (classproject != null && !(ms = classproject.getMappings()).isEmpty()) {
                Iterator it = ms.iterator();
                while (it.hasNext()) {
                    Mapping m = (Mapping)it.next();
                    pems = m.getClassMapping().getAllPrimitiveElementMappings();
                    ClassMapping cm = m.getClassMapping();
                    if (cm == null) continue;
                    dependencies.addAll(cm.getDependencies());
                }
            }
            if (pems != null) {
                ctx.put("pemlist", pems.toArray(new PrimitiveElementMapping[pems.size()]));
            }
            ((Loggable)mmop).setLogger(this.logger);
            mmop.initContext(ctx, clazz, cp.getProjectName(), mapperName);
            ctx.put("dependencies", dependencies);
            OutputStreamWriter fw = null;
            fw = holder.getFileWriter(fileName + ".java");
            this.velocityEngine.getTemplate("org/objectweb/jorm/generator/lib/Mapping.vm").merge(ctx, fw);
            Object var20_20 = null;
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
                break block16;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            break block16;
            {
                catch (Exception e) {
                    throw new PExceptionCompiler(e, "Problem while writing Mapping java file: " + fileName + ".java");
                }
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                try {
                    if (fw != null) {
                        fw.flush();
                        fw.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private void getGenClassMapping(Mapping mo, String projname, ArrayList gcms) {
        gcms.addAll(mo.getGenClassMappings());
        Iterator it = mo.getClassMapping().getParentClassMappings().iterator();
        while (it.hasNext()) {
            this.getGenClassMapping(((ParentClassMapping)it.next()).getMOClass().getClassProject(projname).getMapping(mo.getMapperName()), projname, gcms);
        }
    }

    private List getClassReferenceMapping(Mapping mapping, String projname) {
        HashMap<MetaObject, ReferenceMapping> ref2refmap = new HashMap<MetaObject, ReferenceMapping>();
        ArrayList<Mapping> ms = new ArrayList<Mapping>();
        ms.add(mapping);
        while (!ms.isEmpty()) {
            Mapping mo = (Mapping)ms.remove(0);
            Iterator it = mo.getClassMapping().getReferenceMappings().iterator();
            while (it.hasNext()) {
                ReferenceMapping rm = (ReferenceMapping)it.next();
                ReferenceMapping old = ref2refmap.put(rm.getLinkedMO(), rm);
                if (old == null) continue;
                ref2refmap.put(rm.getLinkedMO(), old);
            }
            it = mo.getClassMapping().getParentClassMappings().iterator();
            while (it.hasNext()) {
                ms.add(((ParentClassMapping)it.next()).getMOClass().getClassProject(projname).getMapping(mo.getMapperName()));
            }
        }
        return new ArrayList(ref2refmap.values());
    }

    private Class getAncestor(Class clazz) throws PException {
        Collection superClasses = clazz.getSuperClasses();
        if (superClasses.isEmpty()) {
            return clazz;
        }
        if (superClasses.size() == 1) {
            return this.getAncestor((Class)superClasses.iterator().next());
        }
        throw new PException("Multiple inheritance not supported in the current implementation");
    }

    public String getOwner(TypedElement te, Class owner, String ownerName) {
        return te.getParent() == owner ? ownerName : "\"" + ((Class)te.getParent()).getFQName() + "\"";
    }

    public String ptype2CTString(PType pt) throws PExceptionTyping {
        if (pt == null) {
            throw new PExceptionTyping("null parameter forbidden");
        }
        switch (pt.getTypeCode()) {
            case 1: {
                return "PNamingContext.CTCHAR";
            }
            case 9: {
                return "PNamingContext.CTOCHAR";
            }
            case 2: {
                return "PNamingContext.CTBYTE";
            }
            case 10: {
                return "PNamingContext.CTOBYTE";
            }
            case 3: {
                return "PNamingContext.CTSHORT";
            }
            case 11: {
                return "PNamingContext.CTOSHORT";
            }
            case 4: {
                return "PNamingContext.CTINT";
            }
            case 12: {
                return "PNamingContext.CTOINT";
            }
            case 5: {
                return "PNamingContext.CTLONG";
            }
            case 13: {
                return "PNamingContext.CTOLONG";
            }
            case 16: {
                return "PNamingContext.CTSTRING";
            }
            case 17: {
                return "PNamingContext.CTDATE";
            }
            case 18: {
                return "PNamingContext.CTCHARARRAY";
            }
            case 19: {
                return "PNamingContext.CTBYTEARRAY";
            }
        }
        throw new PExceptionTyping("The following " + pt.getJormName() + " type has'nt been allowed to be used as a PName field");
    }

    public PType getJavaLangPrimitive(PType pt) {
        switch (pt.getTypeCode()) {
            case 0: 
            case 8: {
                return PTypeSpace.OBJBOOLEAN;
            }
            case 1: 
            case 9: {
                return PTypeSpace.OBJCHAR;
            }
            case 2: 
            case 10: {
                return PTypeSpace.OBJBYTE;
            }
            case 3: 
            case 11: {
                return PTypeSpace.OBJSHORT;
            }
            case 4: 
            case 12: {
                return PTypeSpace.OBJINT;
            }
            case 5: 
            case 13: {
                return PTypeSpace.OBJLONG;
            }
        }
        return null;
    }

    public PType getPrimitive(PType pt) {
        switch (pt.getTypeCode()) {
            case 0: 
            case 8: {
                return PTypeSpace.BOOLEAN;
            }
            case 1: 
            case 9: {
                return PTypeSpace.CHAR;
            }
            case 2: 
            case 10: {
                return PTypeSpace.BYTE;
            }
            case 3: 
            case 11: {
                return PTypeSpace.SHORT;
            }
            case 4: 
            case 12: {
                return PTypeSpace.INT;
            }
            case 5: 
            case 13: {
                return PTypeSpace.LONG;
            }
        }
        return null;
    }

    public String ptype2String(PType pt) throws PExceptionTyping {
        if (pt == null) {
            throw new PExceptionTyping("null parameter forbidden");
        }
        return pt.getProgName();
    }

    public String getGenclass(int level) {
        String res = "";
        for (int i = 0; i < level; ++i) {
            res = res + ".getGenClassMapping()";
        }
        return res;
    }

    public int getIndexNumber(GenClass gc) {
        Iterator it = gc.iterateIndexField();
        int res = 0;
        while (it.hasNext()) {
            ++res;
            it.next();
        }
        return res;
    }

    public TypedElement getLastElement(GenClassRef gcr) {
        GenClassRef o = gcr;
        while (o instanceof GenClassRef) {
            GenClassRef g = o;
            if (g.isClassRef()) {
                o = g.getClassRef();
                continue;
            }
            if (g.isGenClassRef()) {
                o = g.getClassRef();
                continue;
            }
            if (!g.isPrimitive()) continue;
            o = g.getPrimitiveElement();
        }
        return o;
    }

    public ArrayList getGenClassNames(GenClassRef gcr) {
        ArrayList<String> gcns = new ArrayList<String>(5);
        GenClassRef o = gcr;
        while (o instanceof GenClassRef) {
            GenClassRef g = o;
            gcns.add(g.getGenClassName());
            if (g.isClassRef()) {
                o = g.getClassRef();
                continue;
            }
            if (g.isGenClassRef()) {
                o = g.getGenClassRef();
                continue;
            }
            if (!g.isPrimitive()) continue;
            o = g.getPrimitiveElement();
        }
        ArrayList<String> res = new ArrayList<String>(gcns.size());
        for (int i = 0; i < gcns.size(); ++i) {
            String s = "new String[]{";
            for (int j = 0; j <= i; ++j) {
                String elem = "\"" + gcns.get(j) + "\"";
                s = s + elem + (i == j ? "}" : ",");
            }
            res.add(s);
        }
        return res;
    }
}

