/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.client.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;

public final class Bootstrap {
    private Bootstrap() {
    }

    public static void main(String[] args) throws Exception {
        String jroot = System.getProperty("jonas.root");
        if (jroot == null) {
            throw new Exception("JONAS_ROOT is not set.");
        }
        File root = new File(jroot);
        File lib = new File(root, "lib");
        URL clientDotJarURL = null;
        try {
            clientDotJarURL = new File(lib, "client.jar").toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(2);
        }
        JClassLoader loader = new JClassLoader("ClientClassLoader", new URL[]{clientDotJarURL});
        Method main = null;
        if (args == null || args.length == 0) {
            return;
        }
        String classname = args[0];
        try {
            Class<?> clazz = loader.loadClass(classname);
            main = clazz.getDeclaredMethod("main", String[].class);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot load class: '" + classname + "': " + e.getMessage());
            throw e;
        }
        catch (SecurityException e) {
            System.err.println("Permission denied on: '" + classname + "': " + e.getMessage());
            throw e;
        }
        catch (NoSuchMethodException e) {
            System.err.println("No main(String[]) method on: '" + classname + "': " + e.getMessage());
            throw e;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            main.invoke(null, new Object[]{newArgs});
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e;
            }
        }
        catch (Exception e) {
            System.err.println("Cannot execute main(String[]) method on: '" + classname + "': " + e.getMessage());
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

