/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

public class Pattern
implements Comparable {
    private static final int EXACT = 0;
    private static final int PATH_PREFIX = 1;
    private static final int EXTENSION = 2;
    private static final int DEFAULT = 3;
    private String pattern = null;
    private int type;

    public Pattern(String pattern) {
        this.pattern = pattern;
        this.defineTypePattern();
    }

    private void defineTypePattern() {
        this.type = this.pattern.startsWith("/") && this.pattern.endsWith("/*") ? 1 : (this.pattern.startsWith("*.") ? 2 : (this.pattern.equals("/") ? 3 : 0));
    }

    public boolean isPathPrefix() {
        return this.type == 1;
    }

    public boolean isExtensionPattern() {
        return this.type == 2;
    }

    public boolean isDefaultPattern() {
        return this.type == 3;
    }

    public boolean isExactPattern() {
        return this.type == 0;
    }

    public boolean isSubstringPattern(String substring) {
        int size = substring.length();
        if (size == 0) {
            return true;
        }
        return this.pattern.startsWith(substring) && (this.pattern.length() == size || this.pattern.substring(size).charAt(0) == '/');
    }

    public boolean isMatching(Pattern otherPattern) {
        if (this.pattern.equals(otherPattern)) {
            return true;
        }
        if (this.pattern.length() == 2 && this.isPathPrefix()) {
            return true;
        }
        if (this.isPathPrefix() && otherPattern.isSubstringPattern(this.pattern.substring(0, this.pattern.length() - 2))) {
            return true;
        }
        if (this.isExtensionPattern() && otherPattern.getValue().endsWith(this.pattern.substring(1))) {
            return true;
        }
        return this.isDefaultPattern();
    }

    public String getValue() {
        return this.pattern;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Pattern)) {
            return false;
        }
        return this.pattern.equals(((Pattern)o).getValue());
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public int compareTo(Object o) {
        if (!(o instanceof Pattern)) {
            return -1;
        }
        return this.pattern.compareTo(((Pattern)o).getValue());
    }
}

