/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String OPENSAML_NS = "http://www.opensaml.org";
    public static final String SAML_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String SAMLP_NS = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final String XMLSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XPATH2_NS = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String SOAP11ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String XML_SCHEMA_ID = "xml.xsd";
    public static final String SAML_SCHEMA_ID = "cs-sstc-schema-assertion-01.xsd";
    public static final String SAMLP_SCHEMA_ID = "cs-sstc-schema-protocol-01.xsd";
    public static final String SAML11_SCHEMA_ID = "cs-sstc-schema-assertion-1.1.xsd";
    public static final String SAMLP11_SCHEMA_ID = "cs-sstc-schema-protocol-1.1.xsd";
    public static final String XMLSIG_SCHEMA_ID = "xmldsig-core-schema.xsd";
    public static final String XPATH2_SCHEMA_ID = "xmldsig-filter2.xsd";
    public static final String SOAP11ENV_SCHEMA_ID = "soap-envelope.xsd";
    protected static byte[] XML_schema;
    protected static byte[] SAML_schema;
    protected static byte[] SAMLP_schema;
    protected static byte[] SAML11_schema;
    protected static byte[] SAMLP11_schema;
    protected static byte[] XMLSig_schema;
    protected static byte[] XPath2_schema;
    protected static byte[] SOAP11Env_schema;
    public static ParserPool parserPool;
    private static Logger log;
    static /* synthetic */ Class class$org$opensaml$XML;

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean safeCompare(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    public static boolean isElementNamed(Element element, String string, String string2) {
        return element != null && XML.safeCompare(string, element.getNamespaceURI()) && XML.safeCompare(string2, element.getLocalName());
    }

    public static Element getFirstChildElement(Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getLastChildElement(Node node) {
        Node node2;
        for (node2 = node.getLastChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getPreviousSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getFirstChildElement(Node node, String string, String string2) {
        Element element = XML.getFirstChildElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getNextSiblingElement(element);
        }
        return element;
    }

    public static Element getLastChildElement(Node node, String string, String string2) {
        Element element = XML.getLastChildElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getPreviousSiblingElement(element);
        }
        return element;
    }

    public static Element getNextSiblingElement(Node node) {
        Node node2;
        for (node2 = node.getNextSibling(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getPreviousSiblingElement(Node node) {
        Node node2;
        for (node2 = node.getPreviousSibling(); node2 != null && node2.getNodeType() != 1; node2 = node2.getPreviousSibling()) {
        }
        if (node2 != null) {
            return (Element)node2;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String string, String string2) {
        Element element = XML.getNextSiblingElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getNextSiblingElement(element);
        }
        return element;
    }

    public static Element getPreviousSiblingElement(Node node, String string, String string2) {
        Element element = XML.getPreviousSiblingElement(node);
        while (element != null && !XML.isElementNamed(element, string, string2)) {
            element = XML.getPreviousSiblingElement(element);
        }
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        parserPool = new ParserPool();
        log = Logger.getLogger((String)(class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getName());
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer(1024);
            InputStream inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-assertion-01.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XML static initializer unable to locate SAML assertion schema");
            }
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            SAML_schema = stringBuffer.toString().getBytes();
            inputStream.close();
            inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-protocol-01.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XML static initializer unable to locate SAML protocol schema");
            }
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            SAMLP_schema = stringBuffer.toString().getBytes();
            inputStream.close();
            inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-assertion-1.1.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XML static initializer unable to locate SAML 1.1 assertion schema");
            }
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            SAML11_schema = stringBuffer.toString().getBytes();
            inputStream.close();
            inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/cs-sstc-schema-protocol-1.1.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XML static initializer unable to locate SAML 1.1 protocol schema");
            }
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            SAMLP11_schema = stringBuffer.toString().getBytes();
            inputStream.close();
            inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-core-schema.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XML static initializer unable to locate XML Signature schema");
            }
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            XMLSig_schema = stringBuffer.toString().getBytes();
            inputStream.close();
            inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xmldsig-filter2.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XML static initializer unable to locate XPath Filter2 schema");
            }
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            XPath2_schema = stringBuffer.toString().getBytes();
            inputStream.close();
            inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/soap-envelope.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XML static initializer unable to locate SOAP 1.1 Envelope schema");
            }
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            SOAP11Env_schema = stringBuffer.toString().getBytes();
            inputStream.close();
            inputStream = (class$org$opensaml$XML == null ? (class$org$opensaml$XML = XML.class$("org.opensaml.XML")) : class$org$opensaml$XML).getResourceAsStream("/schemas/xml.xsd");
            if (inputStream == null) {
                throw new RuntimeException("XM static initializer unable to locate XML core schema");
            }
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            XML_schema = stringBuffer.toString().getBytes();
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("XML static initializer caught an I/O error");
        }
    }

    public static class ParserPool
    implements EntityResolver,
    ErrorHandler {
        private Stack pool = new Stack();
        private Vector resolvers = new Vector();
        private String schemaLocations = null;
        private Hashtable schemaLocMap = new Hashtable();

        public ParserPool() {
            this.registerSchema(XML.SAML_NS, SAMLConfig.instance().getBooleanProperty("org.opensaml.compatibility-mode") ? XML.SAML_SCHEMA_ID : XML.SAML11_SCHEMA_ID, null);
            this.registerSchema(XML.SAMLP_NS, SAMLConfig.instance().getBooleanProperty("org.opensaml.compatibility-mode") ? XML.SAMLP_SCHEMA_ID : XML.SAMLP11_SCHEMA_ID, null);
            this.registerSchema(XML.SOAP11ENV_NS, XML.SOAP11ENV_SCHEMA_ID, null);
            this.registerSchema(XML.XMLSIG_NS, XML.XMLSIG_SCHEMA_ID, null);
            this.registerSchema(XML.XML_NS, XML.XML_SCHEMA_ID, null);
            this.registerSchema(XML.XPATH2_NS, XML.XPATH2_SCHEMA_ID, null);
            System.setProperty("org.apache.xerces.xni.parser.Configuration", "org.apache.xerces.parsers.XMLGrammarCachingConfiguration");
        }

        public synchronized DOMParser get() throws SAMLException {
            try {
                DOMParser dOMParser = null;
                if (this.pool.empty()) {
                    dOMParser = new DOMParser();
                    dOMParser.setFeature("http://xml.org/sax/features/validation", true);
                    dOMParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                    dOMParser.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
                    dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                    dOMParser.setEntityResolver((EntityResolver)this);
                    dOMParser.setErrorHandler((ErrorHandler)this);
                } else {
                    dOMParser = (DOMParser)this.pool.pop();
                }
                dOMParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)this.schemaLocations);
                return dOMParser;
            }
            catch (SAXException sAXException) {
                throw new SAMLException("XML.ParserPool.get() unable to configure parser properly", (Exception)sAXException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document parse(InputStream inputStream) throws SAMLException, SAXException, IOException {
            DOMParser dOMParser = this.get();
            try {
                dOMParser.parse(new InputSource(inputStream));
                Document document = dOMParser.getDocument();
                return document;
            }
            finally {
                this.put(dOMParser);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document parse(String string) throws SAMLException, SAXException, IOException {
            DOMParser dOMParser = this.get();
            try {
                dOMParser.parse(new InputSource(string));
                Document document = dOMParser.getDocument();
                return document;
            }
            finally {
                this.put(dOMParser);
            }
        }

        public Document newDocument() {
            return new DocumentImpl();
        }

        public synchronized void registerSchema(String string, String string2, EntityResolver entityResolver) {
            if (string != null && string2 != null) {
                if (this.schemaLocMap.containsKey(string)) {
                    this.schemaLocMap.remove(string);
                }
                this.schemaLocMap.put(string, string2);
                if (entityResolver != null) {
                    this.resolvers.add(entityResolver);
                }
                this.schemaLocations = null;
                Iterator iterator = this.schemaLocMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (this.schemaLocations == null) {
                        this.schemaLocations = entry.getKey() + " " + entry.getValue();
                        continue;
                    }
                    this.schemaLocations = this.schemaLocations + " " + entry.getKey() + " " + entry.getValue();
                }
            }
        }

        public synchronized void put(DOMParser dOMParser) {
            this.pool.push(dOMParser);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            log.debug((Object)("ParserPool resolving entity: publicId = " + string + " : systemId = " + string2));
            InputSource inputSource = null;
            if (string2.endsWith(XML.SAML_SCHEMA_ID) && SAML_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(SAML_schema));
            } else if (string2.endsWith(XML.SAMLP_SCHEMA_ID) && SAMLP_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(SAMLP_schema));
            } else if (string2.endsWith(XML.SAML11_SCHEMA_ID) && SAML11_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(SAML11_schema));
            } else if (string2.endsWith(XML.SAMLP11_SCHEMA_ID) && SAMLP11_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(SAMLP11_schema));
            } else if (string2.endsWith(XML.XMLSIG_SCHEMA_ID) && XMLSig_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(XMLSig_schema));
            } else if (string2.endsWith(XML.SOAP11ENV_SCHEMA_ID) && SOAP11Env_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(SOAP11Env_schema));
            } else if (string2.endsWith(XML.XML_SCHEMA_ID) && XML_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(XML_schema));
            } else if (string2.endsWith(XML.XPATH2_SCHEMA_ID) && XPath2_schema != null) {
                inputSource = new InputSource(new ByteArrayInputStream(XPath2_schema));
            } else if (this.resolvers != null) {
                Iterator iterator = this.resolvers.iterator();
                while (inputSource == null && iterator.hasNext()) {
                    inputSource = ((EntityResolver)iterator.next()).resolveEntity(string, string2);
                }
            }
            if (inputSource != null) {
                log.debug((Object)"entity resolved by ParserPool");
            }
            return inputSource;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            log.warn((Object)("Parser warning: line = " + sAXParseException.getLineNumber() + " : uri = " + sAXParseException.getSystemId()));
            log.warn((Object)("Parser warning (root cause): " + sAXParseException.getMessage()));
        }
    }
}

