/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl;

import javax.servlet.http.HttpServletRequest;
import org.ow2.util.auditreport.impl.EncodingType;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.util.ObjectEncoder;

public class WebInvocationAuditReport
extends GenericAuditReport {
    private static final long serialVersionUID = 4264755180723751875L;
    private long requestStart = 0L;
    private long requestStop = 0L;
    private double requestDuration = 0.0;
    private String businessMethod = "";
    private String target = "";
    private Object[] methodParameters = null;
    private Object methodReturn = null;
    private long paramSize = 0L;
    private long returnSize = 0L;
    private String authType = "";
    private String contextPath = "";
    private String pathInfo = "";
    private String pathTranslated = "";
    private String queryString = "";
    private String requestedSessionId = "";
    private String requestURI = "";
    private String requestURL = "";
    private String servletPath = "";
    private String characterEncoding = "";
    private int contentLength = 0;
    private String contentType = "";
    private String localAddress = "";
    private String localName = "";
    private int localPort = 0;
    private String protocol = "";
    private String remoteAddress = "";
    private String remoteHost = "";
    private String remotePort = "";
    private String scheme = "";
    private String serverName = "";
    private int serverport = 0;
    private boolean secure = false;
    private int status = -1;

    public WebInvocationAuditReport() {
    }

    public WebInvocationAuditReport(int level, long requestStartParam, long requestTimeStampParam, String businessMethodParam, String targetParam, Object[] methodParametersParam, Thread currentThreadParam, int freeMemoryBeforeParam, int totalMemoryBeforeParam, String role, int paramSize) {
        this.setCallLevel(level);
        this.setRequestTimeStamp(requestTimeStampParam);
        this.setMethodStackTrace(currentThreadParam.getStackTrace());
        this.setFreeMemoryBefore(freeMemoryBeforeParam);
        this.setTotalMemoryBefore(totalMemoryBeforeParam);
        this.setRoles(role);
        this.setParamSize(paramSize);
        this.target = targetParam;
        this.businessMethod = businessMethodParam;
        this.methodParameters = methodParametersParam;
        this.requestStart = requestStartParam;
    }

    public WebInvocationAuditReport(HttpServletRequest req) {
        this.setBusinessMethod(req.getMethod());
        this.setAuthType(req.getAuthType());
        this.setBeanName(req.getRequestURL().toString());
        this.setCharacterEncoding(req.getCharacterEncoding());
        this.setContentLength(req.getContentLength());
        this.setContentType(req.getContentType());
        this.setContextPath(req.getContextPath());
        this.setLocalAddress(req.getLocalAddr());
        this.setLocalName(req.getLocalName());
        this.setLocalPort(req.getLocalPort());
        this.setParamSize(req.getParameterMap().size());
        this.setPathInfo(req.getPathInfo());
        this.setPathTranslated(req.getPathTranslated());
        this.setProtocol(req.getProtocol());
        this.setQueryString(req.getQueryString());
        this.setRemoteAddress(req.getRemoteAddr());
        this.setRemoteHost(req.getRemoteHost());
        this.setRemotePort(String.valueOf(req.getRemotePort()));
        this.setRequestURI(req.getRequestURI());
        this.setRequestURL(req.getRequestURL().toString());
        this.setRequestedSessionId(req.getRequestedSessionId());
        this.setScheme(req.getScheme());
        this.setSecure(req.isSecure());
        this.setServerName(req.getServerName());
        this.setServerport(req.getServerPort());
        this.setServletPath(req.getServletPath());
    }

    public String getBusinessMethod() {
        return this.businessMethod;
    }

    public Object[] getMethodParameters() {
        return this.methodParameters;
    }

    public Object getMethodReturn() {
        return this.methodReturn;
    }

    public double getRequestDuration() {
        return this.requestDuration;
    }

    public long getRequestStart() {
        return this.requestStart;
    }

    public long getRequestStop() {
        return this.requestStop;
    }

    public void setRequestStart(long requestStartParam) {
        this.requestStart = requestStartParam;
    }

    public void setRequestStop(long requestStopParam) {
        this.requestStop = requestStopParam;
        this.setRequestDuration((double)(requestStopParam - this.getRequestStart()) / WebInvocationAuditReport.getNS());
    }

    public void setRequestDuration(double requestDurationParam) {
        this.requestDuration = requestDurationParam;
    }

    public void setBusinessMethod(String businessMethodParam) {
        this.businessMethod = businessMethodParam;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String targetParam) {
        this.target = targetParam;
    }

    public void setMethodReturn(Object methodReturnParam) {
        this.methodReturn = methodReturnParam;
    }

    public void setMethodParameters(Object[] methodParametersParam) {
        this.methodParameters = methodParametersParam;
    }

    public long getParamSize() {
        return this.paramSize;
    }

    public void setParamSize(long paramSize) {
        this.paramSize = paramSize;
    }

    public long getReturnSize() {
        return this.returnSize;
    }

    public void setReturnSize(long returnSize) {
        this.returnSize = returnSize;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(String remotePort) {
        this.remotePort = remotePort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerport() {
        return this.serverport;
    }

    public void setServerport(int serverport) {
        this.serverport = serverport;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public static double getNS() {
        return 1000000.0;
    }

    public static double getKB() {
        return 1024.0;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    static {
        ObjectEncoder.registerField(WebInvocationAuditReport.class, "methodParameters", EncodingType.OBJECTTABLE);
        ObjectEncoder.registerField(WebInvocationAuditReport.class, "methodReturn", EncodingType.OBJECT);
    }
}

