/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.jaxws;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.Handler;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.context.WebServiceContextImpl;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.xbean.recipe.ObjectRecipe;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.jonas.ws.axis2.easybeans.Axis2EjbMessageReceiver;
import org.ow2.jonas.ws.axis2.easybeans.Axis2EndpointLifecycleManagerFactory;
import org.ow2.jonas.ws.axis2.http.Axis2RequestResponseTransport;
import org.ow2.jonas.ws.axis2.http.Axis2TransportInfo;
import org.ow2.jonas.ws.axis2.http.AxisServiceGenerator;
import org.ow2.jonas.ws.axis2.http.WSDLQueryHandler;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.DescriptionUtils;
import org.ow2.jonas.ws.axis2.util.Axis2Java2WSDLBuilder;
import org.ow2.jonas.ws.axis2.util.JAXWSUtils;
import org.ow2.jonas.ws.jaxws.IWSRequest;
import org.ow2.jonas.ws.jaxws.IWSResponse;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortIdentifier;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2WSEndpoint
implements IWebServiceEndpoint {
    private static final Log logger = LogFactory.getLog(Axis2WSEndpoint.class);
    private String style = "document";
    private String use = "literal";
    protected ConfigurationContext configurationContext;
    protected AxisService service;
    protected Binding binding;
    protected PortMetaData portMetaData;
    protected Class endpointClass;
    protected WSDLQueryHandler wsdlQueryHandler;
    protected StatelessSessionFactory factory;
    private PortIdentifier identifier;
    private IWebServiceEndpoint.EndpointType type;
    public static final String END_POINT_TYPE = "EndPointType";

    public Axis2WSEndpoint(Class endpointClass, IWebServiceEndpoint.EndpointType type, PortMetaData portMetaData, StatelessSessionFactory factory) {
        this.endpointClass = endpointClass;
        this.portMetaData = portMetaData;
        this.type = type;
        this.factory = factory;
        String name = endpointClass.getSimpleName();
        String namespace = JAXWSUtils.getDefaultNamespace(endpointClass);
        this.identifier = new PortIdentifier(new QName(namespace, name), portMetaData.getContextRoot());
    }

    public void init() throws Exception {
        this.configurationContext = ConfigurationContextFactory.createBasicConfigurationContext((String)"META-INF/axis2.xml");
        AxisServiceGenerator serviceGen = this.createServiceGenerator();
        this.service = serviceGen.getServiceFromClass(this.endpointClass, this.configurationContext, this.portMetaData);
        this.service.setScope("application");
        this.service.setEndpointName(this.service.getName());
        this.configurationContext.getAxisConfiguration().addService(this.service);
        this.wsdlQueryHandler = new WSDLQueryHandler(this.service);
        if (this.type == IWebServiceEndpoint.EndpointType.EJB) {
            this.configurationContext.setContextRoot(this.portMetaData.getContextRoot());
            this.configurationContext.setServicePath(this.portMetaData.getUrlPattern());
        }
        this.configureHandlers();
        FactoryRegistry.setFactory(EndpointLifecycleManagerFactory.class, (Object)new Axis2EndpointLifecycleManagerFactory());
    }

    protected AxisServiceGenerator createServiceGenerator() {
        AxisServiceGenerator serviceGenerator = null;
        if (this.type == IWebServiceEndpoint.EndpointType.POJO) {
            serviceGenerator = new AxisServiceGenerator();
        } else if (this.type == IWebServiceEndpoint.EndpointType.EJB) {
            serviceGenerator = new AxisServiceGenerator();
            Axis2EjbMessageReceiver messageReceiver = new Axis2EjbMessageReceiver(this, this.endpointClass, this.factory);
            serviceGenerator.setMessageReceiver(messageReceiver);
        }
        return serviceGenerator;
    }

    public IWebServiceEndpoint.EndpointType getType() {
        return this.type;
    }

    public PortIdentifier getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(IWSRequest request, IWSResponse response) throws WSException {
        block17: {
            HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
            HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
            MessageContext msgContext = new MessageContext();
            msgContext.setIncomingTransportName("http");
            msgContext.setProperty("REMOTE_ADDR", (Object)request.getRemoteAddr());
            msgContext.setProperty(END_POINT_TYPE, (Object)this.getType());
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.injectHandlers();
                TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("http");
                TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("http");
                msgContext.setConfigurationContext(this.configurationContext);
                msgContext.setTransportIn(transportIn);
                msgContext.setTransportOut(transportOut);
                msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
                msgContext.setServerSide(true);
                msgContext.setAxisService(this.service);
                if ("GET".equals(httpRequest.getMethod())) {
                    logger.debug((Object)"received a GET request", new Object[0]);
                    logger.debug((Object)("Query String:" + httpRequest.getQueryString()), new Object[0]);
                    String query = httpRequest.getQueryString();
                    if (query == null) break block17;
                    if (query.toLowerCase().indexOf("wsdl") >= 0) {
                        try {
                            this.processListWSDL(request, response);
                            break block17;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new WSException("Get WSDL for " + this.service.getName() + "  failed");
                        }
                    }
                    this.processURLRequest(request, response, this.service, msgContext);
                    break block17;
                }
                if ("POST".equals(httpRequest.getMethod())) {
                    this.doService(request, response, msgContext);
                    break block17;
                }
                throw new UnsupportedOperationException("[" + httpRequest.getMethod() + " ] method not supported");
            }
            catch (Throwable e) {
                String msg = "Exception occurred while trying to invoke service method doService()";
                logger.error((Object)msg, new Object[]{e});
                try {
                    msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
                    msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatus(202);
                    } else {
                        response.setStatus(500);
                    }
                    AxisEngine.sendFault((MessageContext)faultContext);
                }
                catch (Exception ex) {
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatus(202);
                        break block17;
                    }
                    response.setStatus(500);
                    response.setHeader("Content-Type", "text/plain");
                    PrintWriter pw = null;
                    try {
                        pw = new PrintWriter(response.getOutputStream());
                    }
                    catch (IOException e1) {
                        throw new WSException("Exception occured while getting output print writer", e);
                    }
                    ex.printStackTrace(pw);
                    pw.flush();
                    logger.error((Object)msg, new Object[]{ex});
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        }
    }

    protected void doService(IWSRequest request, IWSResponse response, MessageContext msgContext) throws Exception {
        this.processPOSTRequest(request, response, this.service, msgContext);
        OperationContext operationContext = msgContext.getOperationContext();
        Object contextWritten = null;
        Object isTwoChannel = null;
        if (operationContext != null) {
            contextWritten = operationContext.getProperty("RESPONSE_WRITTEN");
            isTwoChannel = operationContext.getProperty("DIFFERENT_EPR");
        }
        if (contextWritten != null && "true".equals(contextWritten)) {
            if (isTwoChannel != null && "true".equals(isTwoChannel)) {
                response.setStatus(202);
                return;
            }
            response.setStatus(200);
        } else {
            response.setStatus(202);
        }
    }

    protected void setMsgContextProperties(IWSRequest request, IWSResponse response, AxisService service, MessageContext msgContext) throws IOException {
        msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
        msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
        msgContext.setProperty("RequestResponseTransportControl", (Object)new Axis2RequestResponseTransport(response));
        msgContext.setIncomingTransportName("http");
        HttpServletRequest servletRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)servletRequest);
        msgContext.setProperty("TransportInURL", (Object)servletRequest.getRequestURI().toString());
        HttpServletResponse servletResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)servletResponse);
        ServletContext servletContext = (ServletContext)request.getAttribute(ServletContext.class);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, (Object)servletContext);
        if (servletRequest != null) {
            msgContext.setProperty("TRANSPORT_HEADERS", (Object)new TransportHeaders(servletRequest));
        }
        if (this.binding != null) {
            msgContext.setProperty(JAXWSMessageReceiver.PARAM_BINDING, (Object)this.binding);
        }
        msgContext.setTo(new EndpointReference(servletRequest.getRequestURL().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processURLRequest(IWSRequest request, IWSResponse response, AxisService service, MessageContext msgContext) throws Exception {
        String contentType = request.getHeader("Content-Type");
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        ServiceContext serviceContext = msgContext.getServiceContext();
        ObjectRecipe objectRecipe = new ObjectRecipe(this.endpointClass.getName());
        Object obj = objectRecipe.create(this.endpointClass.getClassLoader());
        WebServiceContextImpl wci = new WebServiceContextImpl();
        serviceContext.setProperty("serviceObject", obj);
        Handler.InvocationResponse processed = null;
        processed = RESTUtil.processURLRequest((MessageContext)msgContext, (OutputStream)response.getOutputStream(), (String)contentType);
        if (!processed.equals((Object)Handler.InvocationResponse.CONTINUE)) {
            String s = HTTPTransportReceiver.getServicesHTML((ConfigurationContext)configurationContext);
            PrintWriter pw = new PrintWriter(response.getOutputStream());
            pw.write(s);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPOSTRequest(IWSRequest request, IWSResponse response, AxisService service, MessageContext msgContext) throws Exception {
        HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
        HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
        String contentType = request.getHeader("Content-Type");
        String soapAction = request.getHeader("SOAPAction");
        if (soapAction == null) {
            soapAction = "\"\"";
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            if (!HTTPTransportUtils.isRESTRequest((String)contentType)) {
                Thread.currentThread().setContextClassLoader(this.endpointClass.getClassLoader());
                HTTPTransportUtils.processHTTPPostRequest((MessageContext)msgContext, (InputStream)httpRequest.getInputStream(), (OutputStream)httpResponse.getOutputStream(), (String)contentType, (String)soapAction, (String)new URI(httpRequest.getRequestURI()).getPath());
            } else {
                RESTUtil.processXMLRequest((MessageContext)msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), (String)contentType);
            }
        }
        finally {
            Thread.currentThread();
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void start() {
    }

    public void stop() {
        List handlers = this.binding.getHandlerChain();
        for (Handler handler : handlers) {
            this.invokePreDestroy(handler);
        }
    }

    public PortMetaData getPortMetaData() {
        return this.portMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureHandlers() throws UnsupportedEncodingException, WSException {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(this.service);
        if (desc == null) {
            throw new WSException("There is no endpoint description for this service: " + this.service.getName());
        }
        String xml = this.portMetaData.getHandlerXML();
        HandlerChainsType handlerChains = null;
        if (xml != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            handlerChains = DescriptionUtils.loadHandlerChains(in, null);
            desc.setHandlerChain(handlerChains);
        }
        this.binding = BindingUtils.createBinding((EndpointDescription)desc);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.endpointClass.getClassLoader());
        try {
            DescriptionUtils.registerHandlerHeaders(desc.getAxisService(), this.binding.getHandlerChain());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected void injectHandlers() throws WSException {
        List handlers = this.binding.getHandlerChain();
        try {
            for (Handler handler : handlers) {
                this.injectEJBResources(handler);
                this.invokePostConstruct(handler);
            }
        }
        catch (Exception e) {
            throw new WSException("Injection of @EJB resource for " + this.service.getName() + " failed!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectEJBResources(Object instance) throws WSException {
        Field[] fieldArray;
        for (Field field : fieldArray = instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(EJB.class)) continue;
            EJB ejbResource = field.getAnnotation(EJB.class);
            String dependentEJBName = ejbResource.name();
            try {
                InitialContext ictx = new InitialContext();
                EZBRemoteJNDIResolver jndiResolver = (EZBRemoteJNDIResolver)ictx.lookup("EZB_Remote_JNDIResolver");
                String ejbResourceName = ((EZBJNDIBeanData)jndiResolver.getEJBJNDINames(dependentEJBName).toArray()[0]).getName();
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.endpointClass.getClassLoader());
                    Object ejbObject = ictx.lookup(ejbResourceName);
                    boolean accessibility = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        field.set(instance, ejbObject);
                    }
                    catch (Exception e) {
                        throw new WSException("Exception occurs while injecting field for " + this.service.getName() + "!", (Throwable)e);
                    }
                    finally {
                        field.setAccessible(accessibility);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (Exception e) {
                throw new WSException("Unable to inject the field for " + this.service.getName() + "!", (Throwable)e);
            }
        }
    }

    private void processListWSDL(IWSRequest request, IWSResponse response) throws Exception {
        HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
        HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
        response.setStatus(200);
        response.setContentType("text/xml");
        InputStream inStream = null;
        String epr = httpRequest.getRequestURL().toString();
        if (this.portMetaData.getWSDLLocation() != null) {
            inStream = this.endpointClass.getClassLoader().getResourceAsStream(this.portMetaData.getWSDLLocation());
            OutputStream outStream = response.getOutputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = null;
            doc = db.parse(inStream);
            doc.normalize();
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            this.ReplaceURL(nodeList, epr);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            Properties properties = transformer.getOutputProperties();
            properties.setProperty("encoding", "GB2312");
            properties.setProperty("method", "xml");
            transformer.setOutputProperties(properties);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outStream);
            transformer.transform(source, result);
        } else {
            OutputStream outStream = response.getOutputStream();
            Axis2Java2WSDLBuilder builder = new Axis2Java2WSDLBuilder(epr, outStream, this.endpointClass.getName(), this.endpointClass.getClassLoader());
            builder.generateWSDL();
        }
    }

    public void ReplaceURL(NodeList nodeList, String url) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"service".equals(node.getNodeName()) && !"wsdl:service".equals(node.getNodeName())) continue;
            NodeList nl1 = node.getChildNodes();
            for (int j = 0; j < nl1.getLength(); ++j) {
                Node nd1 = nl1.item(j);
                if (nd1.getNodeType() != 1 || !"port".equals(nd1.getNodeName()) && !"wsdl:port".equals(nd1.getNodeName())) continue;
                logger.debug((Object)nd1.getNodeName(), new Object[0]);
                NodeList nl2 = nd1.getChildNodes();
                for (int k = 0; k < nl2.getLength(); ++k) {
                    Node nd2 = nl2.item(k);
                    if (nd2.getNodeType() != 1 || !"soap:address".equals(nd2.getNodeName()) && !"soap12:address".equals(nd2.getNodeName()) && !"http:address".equals(nd2.getNodeName())) continue;
                    logger.debug((Object)nd2.getNodeName(), new Object[0]);
                    nd2.getAttributes().getNamedItem("location").setNodeValue(url);
                    logger.debug((Object)nd2.getAttributes().getNamedItem("location"), new Object[0]);
                }
            }
        }
    }

    public void displayInfos() {
        String endpointURL = "not yet available";
        if (this.portMetaData != null && this.portMetaData.getEndpointURL() != null) {
            endpointURL = this.portMetaData.getEndpointURL();
        }
        logger.info((Object)"{0} endpoint URL at ''{1}''", new Object[]{this.type, endpointURL});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePostConstruct(Object instance) {
        for (Method method : this.getMethods(instance.getClass(), PostConstruct.class)) {
            PostConstruct pc = method.getAnnotation(PostConstruct.class);
            if (pc == null) continue;
            boolean accessible = method.isAccessible();
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("@PostConstruct method is not visible: " + method), new Object[0]);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)"@PostConstruct method threw exception", new Object[]{e});
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePreDestroy(Object instance) {
        for (Method method : this.getMethods(instance.getClass(), PreDestroy.class)) {
            PreDestroy pc = method.getAnnotation(PreDestroy.class);
            if (pc == null) continue;
            boolean accessible = method.isAccessible();
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("@PreDestroy method is not visible: " + method), new Object[0]);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)"@PreDestroy method threw exception", new Object[]{e});
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    private Collection<Method> getMethods(Class target, Class<? extends Annotation> annotationType) {
        HashSet<Method> methods = new HashSet<Method>();
        this.addMethods(target.getMethods(), annotationType, methods);
        this.addMethods(target.getDeclaredMethods(), annotationType, methods);
        return methods;
    }

    private void addMethods(Method[] methods, Class<? extends Annotation> annotationType, Collection<Method> methodsCol) {
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            methodsCol.add(method);
        }
    }
}

