/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.stateful;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.enhanced.EnhancedCluePool;
import org.ow2.util.pool.impl.enhanced.api.clue.basiccluemanager.IClueAccessor;
import org.ow2.util.pool.impl.enhanced.impl.clue.basiccluemanager.BasicClueManager;
import org.ow2.util.pool.impl.enhanced.manager.clue.ICluePoolManager;
import org.ow2.util.pool.impl.enhanced.manager.clue.optional.IPoolItemRemoveClueManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionFactory
extends SessionFactory<EasyBeansSFSB>
implements IPoolItemRemoveClueManager<EasyBeansSFSB, Long>,
IClueAccessor<EasyBeansSFSB, Long> {
    private static Log logger = LogFactory.getLog(StatefulSessionFactory.class);
    private long idCount = 0L;
    private BasicClueManager<EasyBeansSFSB, Long> basicClueManager;

    public StatefulSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        EnhancedCluePool enhancedPool = this.getManagementPool().getEnhancedCluePoolFactory().createEnhancedCluePool((ICluePoolManager)this);
        this.basicClueManager = new BasicClueManager((IClueAccessor)this, false, false);
        enhancedPool.setAllowSharedInstance(false);
        this.setPool(enhancedPool);
    }

    protected synchronized Long getId(Long beanId) {
        Long newId = beanId;
        if (newId == null) {
            ++this.idCount;
            newId = this.idCount;
        }
        return newId;
    }

    @Override
    protected synchronized EasyBeansSFSB getBean(Long beanId) throws IllegalArgumentException {
        EasyBeansSFSB bean = null;
        try {
            bean = (EasyBeansSFSB)this.getPool().get((Object)beanId);
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
        logger.debug((Object)"Set for bean {0} the Id = {1}", new Object[]{bean, beanId});
        bean.setEasyBeansStatefulID(beanId);
        return bean;
    }

    @Override
    public void remove(EasyBeansSFSB instance) {
        super.remove(instance);
        instance.setEasyBeansRemoved(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        Long id = this.getId(localCallRequest.getBeanId());
        JEJBResponse ejbResponse = new JEJBResponse();
        ejbResponse.setBeanId(id);
        EasyBeansSFSB bean = null;
        try {
            bean = this.getBean(id);
        }
        catch (IllegalArgumentException e) {
            ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", (Throwable)e));
            return ejbResponse;
        }
        catch (NoSuchEJBException e) {
            ejbResponse.setRPCException(new RPCException("Bean has been removed", (Throwable)e));
            return ejbResponse;
        }
        Method m = this.getHashes().get(localCallRequest.getMethodHash());
        if (m == null) {
            ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'.", (Throwable)new NoSuchMethodException("The method is not found on the bean")));
            return ejbResponse;
        }
        Object value = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        String oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
        this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
        OperationState oldState = this.getOperationState();
        this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
        String methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(m) + "@Local";
        Object event = this.getInvocationEventBegin(methodEventProviderId, localCallRequest.getMethodArgs());
        long number = event.getInvocationNumber();
        this.getEventDispatcher().dispatch((IEvent)event);
        EasyBeansSFSB easyBeansSFSB = bean;
        synchronized (easyBeansSFSB) {
            try {
                value = m.invoke((Object)bean, localCallRequest.getMethodArgs());
            }
            catch (IllegalArgumentException e) {
                ejbResponse.setRPCException(new RPCException((Throwable)e));
                event = new EventBeanInvocationError(methodEventProviderId, number, e);
            }
            catch (IllegalAccessException e) {
                ejbResponse.setRPCException(new RPCException((Throwable)e));
                event = new EventBeanInvocationError(methodEventProviderId, number, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                RPCException rpcException = new RPCException(cause);
                ApplicationException applicationException = (ApplicationException)this.getBeanInfo().getApplicationExceptions().get(cause.getClass().getName());
                if (applicationException != null) {
                    rpcException.setApplicationException();
                }
                ejbResponse.setRPCException(rpcException);
                event = new EventBeanInvocationError(methodEventProviderId, number, e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                this.getOperationStateThreadLocal().set(oldState);
                try {
                    this.getPool().release((Object)bean);
                }
                catch (PoolException e) {
                    ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e));
                }
                if (bean.getEasyBeansRemoved()) {
                    ejbResponse.setRemoved(true);
                }
                event = new EventBeanInvocationEnd(methodEventProviderId, number, value);
            }
        }
        ejbResponse.setValue(value);
        if (!localCallRequest.isCalledFromRemoteRequest()) {
            this.getEventDispatcher().dispatch((IEvent)event);
        }
        return ejbResponse;
    }

    public void notifyTimeout(Timer timer) {
        throw new EJBException("Stateful bean cannot receive Timer objects");
    }

    public boolean tryMatch(EasyBeansSFSB easyBeansSFSB, Long clue) {
        return this.basicClueManager.tryMatch((Object)easyBeansSFSB, (Object)clue);
    }

    public void unMatch(EasyBeansSFSB easyBeansSFSB) {
        this.basicClueManager.unMatch((Object)easyBeansSFSB);
    }

    public Long getClue(EasyBeansSFSB easyBeansSFSB) {
        return easyBeansSFSB.getEasyBeansStatefulID();
    }

    public void setClue(EasyBeansSFSB easyBeansSFSB, Long clue) {
        easyBeansSFSB.setEasyBeansStatefulID(clue);
    }
}

