/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean.mdb;

import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.ResolverHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class MDBBeanHelper {
    private static final String MDB_METHODS = "ejbCreate()/ejbRemove() methods";
    private static final JMethod EJBCREATE_METHOD = new JMethod(1, "ejbCreate", "()V", null, new String[]{"javax/ejb/CreateException"});
    private static final JMethod EJBREMOVE_METHOD = new JMethod(1, "ejbRemove", "()V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});

    private MDBBeanHelper() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata mdbBean) throws ResolverException {
        EasyBeansEjbJarMethodMetadata ejbRemoveMethod;
        EasyBeansEjbJarMethodMetadata ejbCreateMethod = ResolverHelper.getMethod(mdbBean, EJBCREATE_METHOD, true, MDB_METHODS, false);
        if (ejbCreateMethod != null) {
            ejbCreateMethod.setPostConstruct(true);
            if (!mdbBean.getPostConstructMethodsMetadata().contains(ejbCreateMethod)) {
                mdbBean.addPostConstructMethodMetadata(ejbCreateMethod);
            }
        }
        if ((ejbRemoveMethod = ResolverHelper.getMethod(mdbBean, EJBREMOVE_METHOD, true, MDB_METHODS, false)) != null) {
            ejbRemoveMethod.setPreDestroy(true);
            if (!mdbBean.getPreDestroyMethodsMetadata().contains(ejbRemoveMethod)) {
                mdbBean.addPreDestroyMethodMetadata(ejbRemoveMethod);
            }
        }
    }
}

