/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.statistic;

import java.util.HashMap;
import java.util.Map;
import javax.management.j2ee.statistics.CountStatistic;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocation;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.api.jmx.EZBMBeanAttribute;
import org.ow2.easybeans.api.statistic.EZBStatistic;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBJmxComponent;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.statistic.AbstractStatistic;
import org.ow2.easybeans.statistic.AbstractStatisticFactory;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.jmx.impl.AbstractMBeanAttribute;

public class TotalCallTimeStatisticFactory
extends AbstractStatisticFactory {
    public TotalCallTimeStatisticFactory(EZBEventComponent eventComponent, EZBJmxComponent jmxComponent) {
        super(J2EEManagedObjectNamingHelper.getAllJ2EEManagedObjectsFilter(), eventComponent, jmxComponent);
    }

    public EZBStatistic createStatistic(String statisticProviderId) {
        return new TotalCallTimeStatistic(statisticProviderId);
    }

    public class TotalCallTimeStatistic
    extends AbstractStatistic {
        private long total;
        private Map<Long, EZBEventBeanInvocationBegin> pendingCall;

        public TotalCallTimeStatistic(String statisticProviderId) {
            super(statisticProviderId.matches(J2EEManagedObjectNamingHelper.getAllMethodsFilter()) ? "totalProcessingTime_" + statisticProviderId.substring(statisticProviderId.lastIndexOf("/") + 1) : "totalProcessingTime", "The total processing time", "ms", TotalCallTimeStatisticFactory.this.getStatisticFactoryId(), statisticProviderId, TotalCallTimeStatisticFactory.this.getEventComponent(), TotalCallTimeStatisticFactory.this.getJmxComponent());
            this.pendingCall = new HashMap<Long, EZBEventBeanInvocationBegin>();
            this.addEventListener(new TotalCallTimeEventListener());
            this.addMBeanAttribute(new TotalCallTimeMBeanAttribute());
        }

        public synchronized void reset() {
            super.reset();
            this.total = 0L;
        }

        public synchronized String getValue() {
            return this.total + this.getUnit();
        }

        public synchronized CountStatistic getJSR77Statistic() {
            return new CountStatistic(){

                public String getName() {
                    return TotalCallTimeStatistic.this.getName();
                }

                public String getDescription() {
                    return TotalCallTimeStatistic.this.getDescription();
                }

                public String getUnit() {
                    return TotalCallTimeStatistic.this.getUnit();
                }

                public long getStartTime() {
                    return TotalCallTimeStatistic.this.getStartTime();
                }

                public long getLastSampleTime() {
                    return TotalCallTimeStatistic.this.getLastSampleTime();
                }

                public long getCount() {
                    return TotalCallTimeStatistic.this.total;
                }
            };
        }

        private class TotalCallTimeMBeanAttribute
        extends AbstractMBeanAttribute
        implements EZBMBeanAttribute {
            public String getMBeanProviderFilter() {
                return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(TotalCallTimeStatistic.this.getStatisticProviderId());
            }

            public TotalCallTimeMBeanAttribute() {
                super(TotalCallTimeStatistic.this.getName(), TotalCallTimeStatistic.this.getUnit(), TotalCallTimeStatistic.this.getDescription(), true, false, false);
            }

            public Object getValue(String id) {
                return TotalCallTimeStatistic.this.total;
            }

            public void setValue(String id, Object value) {
            }
        }

        private class TotalCallTimeEventListener
        implements EZBEventListener {
            private String eventProviderFilter;

            public TotalCallTimeEventListener() {
                this.eventProviderFilter = J2EEManagedObjectNamingHelper.getAllRelativeMethodsFilter(TotalCallTimeStatistic.this.getStatisticProviderId());
            }

            public String getEventProviderFilter() {
                return this.eventProviderFilter;
            }

            public boolean accept(IEvent event) {
                try {
                    return ((EZBEventBeanInvocation)event).getEventProviderId().matches(this.getEventProviderFilter());
                }
                catch (Throwable error) {
                    return false;
                }
            }

            public EventPriority getPriority() {
                return EventPriority.ASYNC_LOW;
            }

            public synchronized void handle(IEvent event) {
                if (EZBEventBeanInvocationBegin.class.isAssignableFrom(event.getClass())) {
                    EZBEventBeanInvocationBegin e = (EZBEventBeanInvocationBegin)event;
                    TotalCallTimeStatistic.this.pendingCall.put(e.getInvocationNumber(), e);
                } else {
                    EZBEventBeanInvocation eventEnd = (EZBEventBeanInvocation)event;
                    EZBEventBeanInvocation eventBegin = (EZBEventBeanInvocation)TotalCallTimeStatistic.this.pendingCall.remove(eventEnd.getInvocationNumber());
                    TotalCallTimeStatistic.this.total += eventEnd.getTime() - eventBegin.getTime();
                    TotalCallTimeStatistic.this.setLastSampleTime(System.currentTimeMillis());
                }
            }
        }
    }
}

