/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.audit;

import org.ow2.easybeans.api.event.EZBEvent;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationEnd;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationError;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycle;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStarted;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStarting;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStopped;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStopping;
import org.ow2.easybeans.component.audit.jmx.JMXNotifier;
import org.ow2.easybeans.component.audit.report.InvocationAuditReportFactory;
import org.ow2.util.auditreport.impl.InvocationAuditReport;
import org.ow2.util.auditreport.impl.LifeCycleAuditReport;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;

public class Auditor
implements EZBEventListener {
    private String eventProviderFilter = ".*";
    private JMXNotifier jmxNotifier = null;
    private InvocationAuditReportFactory invocationAuditReportFactory = null;
    private boolean lifecycleEnabled = false;

    public Auditor(String filter, JMXNotifier jmxNotifier, InvocationAuditReportFactory invocationAuditReportFactory) {
        this.eventProviderFilter = filter;
        this.jmxNotifier = jmxNotifier;
        this.invocationAuditReportFactory = invocationAuditReportFactory;
    }

    public void handle(IEvent event) {
        EZBEventBeanInvocationEnd eventEnd;
        EZBEventBeanInvocationBegin e;
        String eventOn = ((EZBEvent)event).getEventProviderId();
        String methodName = eventOn.substring(eventOn.lastIndexOf("/") + 1, eventOn.length());
        if (EZBEventBeanInvocationBegin.class.isAssignableFrom(event.getClass()) && (e = (EZBEventBeanInvocationBegin)event).getEventProviderId().contains(this.eventProviderFilter)) {
            this.invocationAuditReportFactory.prepareAuditReport(System.nanoTime(), methodName, Thread.currentThread(), e, e.getEventProviderId(), e.getCallerRoles(), e.getCallerPrincipal());
        }
        if (EZBEventBeanInvocationEnd.class.isAssignableFrom(event.getClass()) && (eventEnd = (EZBEventBeanInvocationEnd)event).getEventProviderId().contains(this.eventProviderFilter)) {
            this.jmxNotifier.sendAuditNotification(InvocationAuditReport.class.toString(), this.invocationAuditReportFactory.getAuditReport(System.nanoTime(), eventEnd, eventEnd.getEventProviderId()).toString());
        }
        if (EZBEventBeanInvocationError.class.isAssignableFrom(event.getClass()) && (eventEnd = (EZBEventBeanInvocationError)event).getEventProviderId().contains(this.eventProviderFilter)) {
            this.jmxNotifier.sendAuditNotification(InvocationAuditReport.class.toString(), this.invocationAuditReportFactory.getAuditReport(System.nanoTime(), (EZBEventBeanInvocationError)eventEnd, eventEnd.getEventProviderId()).toString());
        }
        if (this.lifecycleEnabled) {
            if (EZBEventLifeCycleStarted.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStarted)event;
                this.jmxNotifier.sendAuditNotification(LifeCycleAuditReport.class.toString(), this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STARTED, Thread.currentThread()).toString());
            }
            if (EZBEventLifeCycleStarting.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStarting)event;
                this.jmxNotifier.sendAuditNotification(LifeCycleAuditReport.class.toString(), this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STARTING, Thread.currentThread()).toString());
            }
            if (EZBEventLifeCycleStopped.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStopped)event;
                this.jmxNotifier.sendAuditNotification(LifeCycleAuditReport.class.toString(), this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STOPPED, Thread.currentThread()).toString());
            }
            if (EZBEventLifeCycleStopping.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStopping)event;
                this.jmxNotifier.sendAuditNotification(LifeCycleAuditReport.class.toString(), this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STOPPING, Thread.currentThread()).toString());
            }
        }
    }

    public String getEventProviderFilter() {
        return this.eventProviderFilter;
    }

    public boolean accept(IEvent event) {
        try {
            return ((EZBEvent)event).getEventProviderId().contains(this.eventProviderFilter);
        }
        catch (Throwable error) {
            return false;
        }
    }

    public EventPriority getPriority() {
        return EventPriority.ASYNC_LOW;
    }

    public LifeCycleAuditReport getLifeCycleAuditReport(EZBEventLifeCycle event, String beanName, LifeCycleAuditReport.STEP step, Thread current) {
        int freeMemoryBefore = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryBefore = (int)Runtime.getRuntime().totalMemory();
        int freeMemoryAfter = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryAfter = (int)Runtime.getRuntime().totalMemory();
        return new LifeCycleAuditReport(event.getTime(), beanName, step, current, freeMemoryBefore, totalMemoryBefore, freeMemoryAfter, totalMemoryAfter);
    }
}

