/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.impl.lucene.PerDPResources;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneBackendQueueProcessorFactory
implements BackendQueueProcessorFactory {
    private SearchFactoryImplementor searchFactoryImp;
    private final Map<DirectoryProvider, PerDPResources> resourcesMap = new HashMap<DirectoryProvider, PerDPResources>();
    private boolean sync;

    @Override
    public void initialize(Properties props, SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImp = searchFactoryImplementor;
        this.sync = BatchedQueueingProcessor.isConfiguredAsSync(props);
        for (DirectoryProvider<?> dp : searchFactoryImplementor.getDirectoryProviders()) {
            PerDPResources resources = new PerDPResources(searchFactoryImplementor, dp);
            this.resourcesMap.put(dp, resources);
        }
    }

    @Override
    public Runnable getProcessor(List<LuceneWork> queue) {
        return new LuceneBackendQueueProcessor(queue, this.searchFactoryImp, this.resourcesMap, this.sync);
    }

    @Override
    public void close() {
        for (PerDPResources res : this.resourcesMap.values()) {
            ExecutorService executor = res.getExecutor();
            executor.shutdown();
        }
    }
}

