/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.IndexInteractionType;
import org.hibernate.search.backend.impl.lucene.PerDPResources;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

class PerDPQueueProcessor
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final Workspace workspace;
    private final LuceneWorkVisitor worker;
    private final ExecutorService executor;
    private final List<LuceneWork> workOnWriter = new ArrayList<LuceneWork>();
    private final List<LuceneWork> workOnReader = new ArrayList<LuceneWork>();
    private boolean batchmode = false;
    private boolean needsWriter = false;
    private boolean preferReader = false;

    public PerDPQueueProcessor(PerDPResources resources) {
        this.worker = resources.getVisitor();
        this.workspace = resources.getWorkspace();
        this.executor = resources.getExecutor();
    }

    public void addWork(LuceneWork work) {
        if (work.isBatch()) {
            this.batchmode = true;
            log.debug("Batch mode enabled");
        }
        IndexInteractionType type = work.getWorkDelegate(this.worker).getIndexInteractionType();
        switch (type) {
            case PREFER_INDEXREADER: {
                this.preferReader = true;
                this.workOnReader.add(work);
                break;
            }
            case NEEDS_INDEXWRITER: {
                this.needsWriter = true;
            }
            case PREFER_INDEXWRITER: {
                this.workOnWriter.add(work);
                break;
            }
            default: {
                throw new AssertionFailure("Uncovered switch case for type " + (Object)((Object)type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.batchmode) {
            if (!this.needsWriter) {
                if (this.preferReader) {
                    this.useReaderOnly();
                } else {
                    this.useWriterOnly();
                }
            } else {
                this.useWriterOnly();
            }
            if (!this.workOnWriter.isEmpty() && !this.workOnReader.isEmpty()) {
                throw new AssertionFailure("During non-batch mode performWorks tries to use both IndexWriter and IndexReader.");
            }
        }
        log.trace("Locking Workspace (or waiting to...)");
        this.workspace.lock();
        log.trace("Workspace lock aquired.");
        try {
            this.performReaderWorks();
            this.performWriterWorks();
        }
        finally {
            this.workspace.unlock();
            log.trace("Unlocking Workspace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performWriterWorks() {
        if (this.workOnWriter.isEmpty()) {
            return;
        }
        log.debug("Opening an IndexWriter for update");
        IndexWriter indexWriter = this.workspace.getIndexWriter(this.batchmode);
        try {
            for (LuceneWork lw : this.workOnWriter) {
                lw.getWorkDelegate(this.worker).performWork(lw, indexWriter);
            }
            this.workspace.commitIndexWriter();
            this.workspace.optimizerPhase();
        }
        finally {
            this.workspace.closeIndexWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performReaderWorks() {
        if (this.workOnReader.isEmpty()) {
            return;
        }
        log.debug("Opening an IndexReader for update");
        IndexReader indexReader = this.workspace.getIndexReader();
        try {
            for (LuceneWork lw : this.workOnReader) {
                lw.getWorkDelegate(this.worker).performWork(lw, indexReader);
            }
        }
        finally {
            this.workspace.closeIndexReader();
        }
    }

    private void useReaderOnly() {
        log.debug("Skipping usage of an IndexWriter for updates");
        this.workOnReader.addAll(this.workOnWriter);
        this.workOnWriter.clear();
    }

    private void useWriterOnly() {
        log.debug("Skipping usage of an IndexReader for updates");
        this.workOnWriter.addAll(0, this.workOnReader);
        this.workOnReader.clear();
    }

    public ExecutorService getOwningExecutor() {
        return this.executor;
    }
}

