/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.windows;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;

public class WinSysEnv {
    private static Properties env = null;
    private static Logger logger = Log.getLogger(WinSysEnv.class.getName());

    public static String get(String var) {
        if (env == null) {
            WinSysEnv.load();
        }
        String value = null;
        if (env != null) {
            value = env.getProperty(var);
        }
        return value;
    }

    public static Properties getEnv() {
        if (env == null) {
            WinSysEnv.load();
        }
        return env;
    }

    private static void load() {
        if (env == null) {
            Properties props = new Properties();
            Runtime rt = Runtime.getRuntime();
            Process proc = null;
            try {
                proc = rt.exec("cmd /c SET");
                BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String ln = null;
                while ((ln = r.readLine()) != null) {
                    int ix = ln.indexOf("=");
                    props.setProperty(ln.substring(0, ix), ln.substring(ix + 1));
                }
                if (proc != null) {
                    proc.waitFor();
                }
            }
            catch (IOException e1) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot get System environment : " + e1));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            env = props;
        }
    }
}

