/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jmx.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.naming.NameAlreadyBoundException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.internal.BaseJMXService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.security.auth.spi.RoleBasedAuthorizationModule;
import org.ow2.jonas.service.JonasAlreadyStartedException;
import org.ow2.jonas.service.ServiceException;

public class JOnASJMXService
extends BaseJMXService
implements Pojo {
    private InstanceManager __IM;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.jmx");
    private static final String MX4J_COMMONS_LOGGER_CLASSNAME = "mx4j.log.CommonsLogger";
    private static final String MX4J_LOG_CLASSNAME = "mx4j.log.Log";
    private static final String MX4J_LOGGER_CLASS = "mx4j.log.Logger";
    private boolean __FconnectorServers;
    private JMXConnectorServer[] connectorServers;
    private boolean __FconnectorServerURLs;
    private JMXServiceURL[] connectorServerURLs;
    private boolean __FregistryService;
    private RegistryService registryService;
    private boolean __FconnectorObjectNames;
    private List<ObjectName> connectorObjectNames;
    private boolean __FnamingManager;
    private JNamingManager namingManager;
    private boolean __FjmxSecured;
    private boolean jmxSecured;
    private boolean __FauthenticationMethod;
    private String authenticationMethod;
    private boolean __FauthenticationParameter;
    private String authenticationParameter;
    private boolean __FauthorizationMethod;
    private String authorizationMethod;
    private boolean __FauthorizationParameter;
    private String authorizationParameter;
    private boolean __MinitializeMX4JLoggingSystem;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgetConnectorServerURLs;
    private boolean __MsetRegistryService$org_ow2_jonas_registry_RegistryService;
    private boolean __MgetNamingManager;
    private boolean __MsetNamingManager$org_ow2_jonas_naming_JNamingManager;
    private boolean __MsetJmxSecured$boolean;
    private boolean __MsetAuthenticationMethod$java_lang_String;
    private boolean __MsetAuthenticationParameter$java_lang_String;
    private boolean __MsetAuthorizationMethod$java_lang_String;
    private boolean __MsetAuthorizationParameter$java_lang_String;

    JMXConnectorServer[] __getconnectorServers() {
        if (!this.__FconnectorServers) {
            return this.connectorServers;
        }
        return (JMXConnectorServer[])this.__IM.onGet((Object)this, "connectorServers");
    }

    void __setconnectorServers(JMXConnectorServer[] jMXConnectorServerArray) {
        if (!this.__FconnectorServers) {
            this.connectorServers = jMXConnectorServerArray;
            return;
        }
        this.__IM.onSet((Object)this, "connectorServers", (Object)jMXConnectorServerArray);
    }

    JMXServiceURL[] __getconnectorServerURLs() {
        if (!this.__FconnectorServerURLs) {
            return this.connectorServerURLs;
        }
        return (JMXServiceURL[])this.__IM.onGet((Object)this, "connectorServerURLs");
    }

    void __setconnectorServerURLs(JMXServiceURL[] jMXServiceURLArray) {
        if (!this.__FconnectorServerURLs) {
            this.connectorServerURLs = jMXServiceURLArray;
            return;
        }
        this.__IM.onSet((Object)this, "connectorServerURLs", (Object)jMXServiceURLArray);
    }

    RegistryService __getregistryService() {
        if (!this.__FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this.__IM.onGet((Object)this, "registryService");
    }

    void __setregistryService(RegistryService registryService) {
        if (!this.__FregistryService) {
            this.registryService = registryService;
            return;
        }
        this.__IM.onSet((Object)this, "registryService", (Object)registryService);
    }

    List __getconnectorObjectNames() {
        if (!this.__FconnectorObjectNames) {
            return this.connectorObjectNames;
        }
        return (List)this.__IM.onGet((Object)this, "connectorObjectNames");
    }

    void __setconnectorObjectNames(List list) {
        if (!this.__FconnectorObjectNames) {
            this.connectorObjectNames = list;
            return;
        }
        this.__IM.onSet((Object)this, "connectorObjectNames", (Object)list);
    }

    JNamingManager __getnamingManager() {
        if (!this.__FnamingManager) {
            return this.namingManager;
        }
        return (JNamingManager)this.__IM.onGet((Object)this, "namingManager");
    }

    void __setnamingManager(JNamingManager jNamingManager) {
        if (!this.__FnamingManager) {
            this.namingManager = jNamingManager;
            return;
        }
        this.__IM.onSet((Object)this, "namingManager", (Object)jNamingManager);
    }

    boolean __getjmxSecured() {
        if (!this.__FjmxSecured) {
            return this.jmxSecured;
        }
        Object object = this.__IM.onGet((Object)this, "jmxSecured");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setjmxSecured(boolean bl) {
        if (!this.__FjmxSecured) {
            this.jmxSecured = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "jmxSecured", (Object)bl2);
    }

    String __getauthenticationMethod() {
        if (!this.__FauthenticationMethod) {
            return this.authenticationMethod;
        }
        return (String)this.__IM.onGet((Object)this, "authenticationMethod");
    }

    void __setauthenticationMethod(String string) {
        if (!this.__FauthenticationMethod) {
            this.authenticationMethod = string;
            return;
        }
        this.__IM.onSet((Object)this, "authenticationMethod", (Object)string);
    }

    String __getauthenticationParameter() {
        if (!this.__FauthenticationParameter) {
            return this.authenticationParameter;
        }
        return (String)this.__IM.onGet((Object)this, "authenticationParameter");
    }

    void __setauthenticationParameter(String string) {
        if (!this.__FauthenticationParameter) {
            this.authenticationParameter = string;
            return;
        }
        this.__IM.onSet((Object)this, "authenticationParameter", (Object)string);
    }

    String __getauthorizationMethod() {
        if (!this.__FauthorizationMethod) {
            return this.authorizationMethod;
        }
        return (String)this.__IM.onGet((Object)this, "authorizationMethod");
    }

    void __setauthorizationMethod(String string) {
        if (!this.__FauthorizationMethod) {
            this.authorizationMethod = string;
            return;
        }
        this.__IM.onSet((Object)this, "authorizationMethod", (Object)string);
    }

    String __getauthorizationParameter() {
        if (!this.__FauthorizationParameter) {
            return this.authorizationParameter;
        }
        return (String)this.__IM.onGet((Object)this, "authorizationParameter");
    }

    void __setauthorizationParameter(String string) {
        if (!this.__FauthorizationParameter) {
            this.authorizationParameter = string;
            return;
        }
        this.__IM.onSet((Object)this, "authorizationParameter", (Object)string);
    }

    public JOnASJMXService() {
        this(null);
    }

    private JOnASJMXService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setconnectorServers(null);
        this.__setconnectorServerURLs(null);
        this.__setregistryService(null);
        this.__setconnectorObjectNames(null);
        this.__setnamingManager(null);
        this.__setjmxSecured(false);
        this.__setauthenticationMethod(null);
        this.__setauthenticationParameter(null);
        this.__setauthorizationMethod(null);
        this.__setauthorizationParameter(null);
    }

    private void initializeMX4JLoggingSystem() {
        if (!this.__MinitializeMX4JLoggingSystem) {
            this.__initializeMX4JLoggingSystem();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initializeMX4JLoggingSystem", new Object[0]);
            this.__initializeMX4JLoggingSystem();
            this.__IM.onExit((Object)this, "initializeMX4JLoggingSystem", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initializeMX4JLoggingSystem", throwable);
            throw throwable;
        }
    }

    private void __initializeMX4JLoggingSystem() {
        block6: {
            Class<?> mx4jCommonsLoggerClass = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                mx4jCommonsLoggerClass = loader.loadClass(MX4J_COMMONS_LOGGER_CLASSNAME);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Class mx4j.log.CommonsLogger founded");
                }
                Object o = mx4jCommonsLoggerClass.newInstance();
                Class<?> clazz = loader.loadClass(MX4J_LOG_CLASSNAME);
                Class<?> mx4jLoggerClass = loader.loadClass(MX4J_LOGGER_CLASS);
                Method m = clazz.getMethod("redirectTo", mx4jLoggerClass);
                m.invoke(clazz, o);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"MX4J logging redirected to the Jakarta commons logger");
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Class mx4j.log.CommonsLogger not found: " + cnfe));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block6;
                logger.log(BasicLevel.WARN, (Object)("Problem with mx4j.log.CommonsLogger instance creation " + e));
            }
        }
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting JMX Service");
        this.initializeMX4JLoggingSystem();
        super.doStart();
        String serverName = this.getJonasServerName();
        if (serverName == null) {
            throw new ServiceException("Cannot start JMX service. No serverName.");
        }
        String defaultProtocolName = this.__getregistryService().getDefaultProtocolName();
        try {
            List protocols = this.__getregistryService().getActiveProtocolNames();
            int nbProtocols = protocols.size();
            this.__setconnectorServerURLs(new JMXServiceURL[nbProtocols]);
            this.__setconnectorServers(new JMXConnectorServer[nbProtocols]);
            this.__setconnectorObjectNames(new ArrayList());
            int index = 0;
            for (String name : protocols) {
                String connectorName = null;
                this.__getregistryService().setDefaultProtocol(name);
                String protocol = "rmi";
                URI carolURL = this.__getregistryService().getProviderURL(name);
                String scheme = carolURL.getScheme();
                String host = carolURL.getHost();
                int port = this.__getregistryService().getExportedObjectPort(name);
                String ictxFactory = this.__getregistryService().getInitialContextFactoryName(name);
                Properties props = new Properties();
                props.put("jmx.remote.jndi.rebind", "true");
                props.put("java.naming.factory.initial", ictxFactory);
                props.put("java.naming.provider.url", carolURL.toString());
                JMXServiceURL serviceURL = null;
                if (name.equals("jrmp")) {
                    connectorName = "jrmpconnector_" + serverName;
                } else if (name.equals("irmi")) {
                    connectorName = "irmiconnector_" + serverName;
                    if (port != 0) {
                        ++port;
                    }
                } else {
                    if (!name.equals("iiop")) continue;
                    connectorName = "iiopconnector_" + serverName;
                    protocol = "iiop";
                    Object orb = null;
                    IExecution<Object> exec = new IExecution<Object>(){

                        public Object execute() throws Exception {
                            return JOnASJMXService.this.getNamingManager().getInitialContext().lookup("java:comp/ORB");
                        }
                    };
                    ExecutionResult res = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)exec);
                    if (res.hasException()) {
                        throw res.getException();
                    }
                    orb = res.getResult();
                    props.put("java.naming.corba.orb", orb);
                }
                MBeanServerForwarder forwarder = null;
                if (this.__getjmxSecured()) {
                    String fileSeparator = System.getProperty("file.separator");
                    if (this.__getauthenticationMethod() != null && this.__getauthenticationParameter() != null) {
                        if ("jmx.remote.x.password.file".equals(this.__getauthenticationMethod())) {
                            props.put(this.__getauthenticationMethod(), JProp.getJonasBase() + fileSeparator + this.__getauthenticationParameter());
                        } else {
                            props.put(this.__getauthenticationMethod(), this.__getauthenticationParameter());
                        }
                    }
                    if (this.__getauthorizationMethod() != null && this.__getauthorizationParameter() != null) {
                        if (this.__getauthorizationMethod().startsWith("jmx.remote.x.access.rolebased")) {
                            forwarder = RoleBasedAuthorizationModule.newProxyInstance((String)this.__getauthorizationMethod().substring("jmx.remote.x.access.rolebased".length() + 1), (String)this.__getauthorizationParameter());
                        } else if ("jmx.remote.x.access.file".equals(this.__getauthorizationMethod())) {
                            props.put(this.__getauthorizationMethod(), JProp.getJonasBase() + fileSeparator + this.__getauthorizationParameter());
                        } else {
                            props.put(this.__getauthorizationMethod(), this.__getauthorizationParameter());
                        }
                    }
                }
                serviceURL = new JMXServiceURL(protocol, host, port, "/jndi/" + carolURL.toString() + "/" + connectorName);
                JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, props, null);
                if (forwarder != null) {
                    connectorServer.setMBeanServerForwarder(forwarder);
                }
                this.__getconnectorServers()[index] = connectorServer;
                String connectorObjectName = "connector_" + name;
                ObjectName connectorServerName = JonasObjectName.jmxConnectorServer((String)scheme, (String)connectorObjectName);
                this.__getconnectorObjectNames().add(connectorServerName);
                if (this.getJmxServer().isRegistered(connectorServerName)) {
                    this.getJmxServer().unregisterMBean(connectorServerName);
                }
                this.getJmxServer().registerMBean(connectorServer, connectorServerName);
                final int idx = index++;
                final JMXConnectorServer server = connectorServer;
                IExecution<Void> exec = new IExecution<Void>(){

                    public Void execute() throws Exception {
                        server.start();
                        ((JOnASJMXService)JOnASJMXService.this).__getconnectorServerURLs()[idx] = server.getAddress();
                        if (JOnASJMXService.this.__getjmxSecured()) {
                            try {
                                JMXConnectorFactory.connect(JOnASJMXService.this.__getconnectorServerURLs()[idx]).close();
                                logger.log(BasicLevel.WARN, (Object)"JMX security is enabled but anonymous logins are still accepted! Please check your JMX security configuration.");
                            }
                            catch (SecurityException e) {
                                logger.log(BasicLevel.INFO, (Object)"JMX security is enabled and active");
                            }
                        } else {
                            logger.log(BasicLevel.INFO, (Object)"JMX security is disabled");
                        }
                        return null;
                    }
                };
                System.setProperty("carol.multipro.protocol", name);
                ExecutionResult res = RunnableHelper.execute((ClassLoader)JOnASJMXService.class.getClassLoader(), (IExecution)exec);
                System.setProperty("carol.multipro.protocol", "any");
                if (!res.hasException()) continue;
                throw res.getException();
            }
        }
        catch (NameAlreadyBoundException ne) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot start JMX service " + ne));
            throw new JonasAlreadyStartedException();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot start JMX service", (Throwable)e);
        }
        finally {
            this.__getregistryService().setDefaultProtocol(defaultProtocolName);
        }
        String jmxConnectors = null;
        jmxConnectors = this.__getconnectorServerURLs() != null && this.__getconnectorServerURLs().length == 1 && this.__getconnectorServerURLs()[0] == null ? ". No JMX Connector." : " using connector(s)" + Arrays.asList(this.__getconnectorServerURLs());
        logger.log(BasicLevel.INFO, (Object)("JMX Service started" + jmxConnectors));
    }

    public void doStop() {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() {
        super.doStop();
        logger.log(BasicLevel.DEBUG, (Object)"Stopping JMX Service");
        if (this.__getconnectorObjectNames() != null) {
            for (final ObjectName name : this.__getconnectorObjectNames()) {
                try {
                    IExecution<Void> exec = new IExecution<Void>(){

                        public Void execute() throws Exception {
                            JOnASJMXService.this.getJmxServer().unregisterMBean(name);
                            return null;
                        }
                    };
                    String protocol = name.getKeyProperty("protocol");
                    System.setProperty("carol.multipro.protocol", protocol);
                    ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)exec);
                    System.setProperty("carol.multipro.protocol", "any");
                    if (!result.hasException()) continue;
                    throw result.getException();
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot unregister Connector MBean for '" + name + "'"), (Throwable)e);
                }
            }
        }
        if (this.__getconnectorServers() != null) {
            for (int i = 0; i < this.__getconnectorServers().length; ++i) {
                try {
                    this.__getconnectorServers()[i].stop();
                    continue;
                }
                catch (Exception e) {
                    logger.log(BasicLevel.INFO, (Object)"Cannot Stop JMX Connector", (Throwable)e);
                }
            }
        }
        logger.log(BasicLevel.INFO, (Object)"JMX Service stopped");
    }

    public JMXServiceURL[] getConnectorServerURLs() {
        JMXServiceURL[] jMXServiceURLArray;
        if (!this.__MgetConnectorServerURLs) {
            return this.__getConnectorServerURLs();
        }
        try {
            this.__IM.onEntry((Object)this, "getConnectorServerURLs", new Object[0]);
            jMXServiceURLArray = this.__getConnectorServerURLs();
            this.__IM.onExit((Object)this, "getConnectorServerURLs", (Object)jMXServiceURLArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConnectorServerURLs", throwable);
            throw throwable;
        }
        return jMXServiceURLArray;
    }

    private JMXServiceURL[] __getConnectorServerURLs() {
        return this.__getconnectorServerURLs();
    }

    public void setRegistryService(RegistryService registryService) {
        if (!this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService) {
            this.__setRegistryService(registryService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", new Object[]{registryService});
            this.__setRegistryService(registryService);
            this.__IM.onExit((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", throwable);
            throw throwable;
        }
    }

    private void __setRegistryService(RegistryService registryService) {
        this.__setregistryService(registryService);
    }

    public JNamingManager getNamingManager() {
        JNamingManager jNamingManager;
        if (!this.__MgetNamingManager) {
            return this.__getNamingManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getNamingManager", new Object[0]);
            jNamingManager = this.__getNamingManager();
            this.__IM.onExit((Object)this, "getNamingManager", (Object)jNamingManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNamingManager", throwable);
            throw throwable;
        }
        return jNamingManager;
    }

    private JNamingManager __getNamingManager() {
        return this.__getnamingManager();
    }

    public void setNamingManager(JNamingManager jNamingManager) {
        if (!this.__MsetNamingManager$org_ow2_jonas_naming_JNamingManager) {
            this.__setNamingManager(jNamingManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setNamingManager$org_ow2_jonas_naming_JNamingManager", new Object[]{jNamingManager});
            this.__setNamingManager(jNamingManager);
            this.__IM.onExit((Object)this, "setNamingManager$org_ow2_jonas_naming_JNamingManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setNamingManager$org_ow2_jonas_naming_JNamingManager", throwable);
            throw throwable;
        }
    }

    private void __setNamingManager(JNamingManager namingManager) {
        this.__setnamingManager(namingManager);
    }

    public void setJmxSecured(boolean bl) {
        if (!this.__MsetJmxSecured$boolean) {
            this.__setJmxSecured(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxSecured$boolean", new Object[]{new Boolean(bl)});
            this.__setJmxSecured(bl);
            this.__IM.onExit((Object)this, "setJmxSecured$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxSecured$boolean", throwable);
            throw throwable;
        }
    }

    private void __setJmxSecured(boolean jmxSecured) {
        this.__setjmxSecured(jmxSecured);
    }

    public void setAuthenticationMethod(String string) {
        if (!this.__MsetAuthenticationMethod$java_lang_String) {
            this.__setAuthenticationMethod(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAuthenticationMethod$java_lang_String", new Object[]{string});
            this.__setAuthenticationMethod(string);
            this.__IM.onExit((Object)this, "setAuthenticationMethod$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAuthenticationMethod$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setAuthenticationMethod(String authenticationMethod) {
        this.__setauthenticationMethod(authenticationMethod);
    }

    public void setAuthenticationParameter(String string) {
        if (!this.__MsetAuthenticationParameter$java_lang_String) {
            this.__setAuthenticationParameter(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAuthenticationParameter$java_lang_String", new Object[]{string});
            this.__setAuthenticationParameter(string);
            this.__IM.onExit((Object)this, "setAuthenticationParameter$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAuthenticationParameter$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setAuthenticationParameter(String authenticationParameter) {
        this.__setauthenticationParameter(authenticationParameter);
    }

    public void setAuthorizationMethod(String string) {
        if (!this.__MsetAuthorizationMethod$java_lang_String) {
            this.__setAuthorizationMethod(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAuthorizationMethod$java_lang_String", new Object[]{string});
            this.__setAuthorizationMethod(string);
            this.__IM.onExit((Object)this, "setAuthorizationMethod$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAuthorizationMethod$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setAuthorizationMethod(String authorizationMethod) {
        this.__setauthorizationMethod(authorizationMethod);
    }

    public void setAuthorizationParameter(String string) {
        if (!this.__MsetAuthorizationParameter$java_lang_String) {
            this.__setAuthorizationParameter(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAuthorizationParameter$java_lang_String", new Object[]{string});
            this.__setAuthorizationParameter(string);
            this.__IM.onExit((Object)this, "setAuthorizationParameter$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAuthorizationParameter$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setAuthorizationParameter(String authorizationParameter) {
        this.__setauthorizationParameter(authorizationParameter);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("authorizationParameter")) {
                this.__FauthorizationParameter = true;
            }
            if (set.contains("authorizationMethod")) {
                this.__FauthorizationMethod = true;
            }
            if (set.contains("connectorServers")) {
                this.__FconnectorServers = true;
            }
            if (set.contains("namingManager")) {
                this.__FnamingManager = true;
            }
            if (set.contains("authenticationParameter")) {
                this.__FauthenticationParameter = true;
            }
            if (set.contains("registryService")) {
                this.__FregistryService = true;
            }
            if (set.contains("connectorObjectNames")) {
                this.__FconnectorObjectNames = true;
            }
            if (set.contains("authenticationMethod")) {
                this.__FauthenticationMethod = true;
            }
            if (set.contains("jmxSecured")) {
                this.__FjmxSecured = true;
            }
            if (set.contains("connectorServerURLs")) {
                this.__FconnectorServerURLs = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initializeMX4JLoggingSystem")) {
                this.__MinitializeMX4JLoggingSystem = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getConnectorServerURLs")) {
                this.__MgetConnectorServerURLs = true;
            }
            if (set.contains("setRegistryService$org_ow2_jonas_registry_RegistryService")) {
                this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("getNamingManager")) {
                this.__MgetNamingManager = true;
            }
            if (set.contains("setNamingManager$org_ow2_jonas_naming_JNamingManager")) {
                this.__MsetNamingManager$org_ow2_jonas_naming_JNamingManager = true;
            }
            if (set.contains("setJmxSecured$boolean")) {
                this.__MsetJmxSecured$boolean = true;
            }
            if (set.contains("setAuthenticationMethod$java_lang_String")) {
                this.__MsetAuthenticationMethod$java_lang_String = true;
            }
            if (set.contains("setAuthenticationParameter$java_lang_String")) {
                this.__MsetAuthenticationParameter$java_lang_String = true;
            }
            if (set.contains("setAuthorizationMethod$java_lang_String")) {
                this.__MsetAuthorizationMethod$java_lang_String = true;
            }
            if (set.contains("setAuthorizationParameter$java_lang_String")) {
                this.__MsetAuthorizationParameter$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

