/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.ws.commons.schema.XmlSchema;

public class AxisService2WSDL11
implements Java2WSDLConstants {
    private AxisService axisService;
    private String serviceName;
    private String targetNamespace;
    private OMElement definition;
    private OMNamespace soap;
    private OMNamespace soap12;
    private OMNamespace http;
    private OMNamespace mime;
    private OMNamespace tns;
    private OMNamespace wsdl;
    private OMNamespace wsaw;
    private String style = "document";
    private String use = "literal";
    private HashMap policiesInDefinitions;
    private ExternalPolicySerializer serializer;
    private HashMap messagesMap;

    public AxisService2WSDL11(AxisService service) throws Exception {
        this.axisService = service;
        this.serviceName = service.getName();
        this.init();
    }

    private void init() throws AxisFault {
        this.targetNamespace = this.axisService.getTargetNamespace();
        this.serializer = new ExternalPolicySerializer();
        AxisConfiguration configuration = this.axisService.getAxisConfiguration();
        if (configuration != null) {
            this.serializer.setAssertionsToFilter(configuration.getLocalPolicyAssertions());
        }
    }

    public AxisService2WSDL11(AxisService service, String serviceName) throws Exception {
        this.axisService = service;
        this.serviceName = serviceName;
        this.init();
    }

    public OMElement generateOM() throws Exception {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        this.wsdl = fac.createOMNamespace("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        OMElement ele = fac.createOMElement("definitions", this.wsdl);
        this.setDefinitionElement(ele);
        this.policiesInDefinitions = new HashMap();
        HashMap<String, String> namespaceMap = this.axisService.getNamespaceMap();
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, String>();
        }
        WSDLSerializationUtil.populateNamespaces((OMElement)ele, (Map)namespaceMap);
        this.soap = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.soap12 = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        this.http = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/http/", "http");
        this.mime = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        this.wsaw = ele.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        String prefix = WSDLSerializationUtil.getPrefix((String)this.axisService.getTargetNamespace(), namespaceMap);
        if (prefix == null || "".equals(prefix)) {
            prefix = "axis2";
        }
        namespaceMap.put(prefix, this.axisService.getTargetNamespace());
        this.tns = ele.declareNamespace(this.axisService.getTargetNamespace(), prefix);
        boolean disableREST = false;
        Parameter disableRESTParameter = this.axisService.getParameter("disableREST");
        if (disableRESTParameter != null && JavaUtils.isTrueExplicitly((Object)disableRESTParameter.getValue())) {
            disableREST = true;
        }
        boolean disableSOAP11 = false;
        Parameter disableSOAP11Parameter = this.axisService.getParameter("disableSOAP11");
        if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly((Object)disableSOAP11Parameter.getValue())) {
            disableSOAP11 = true;
        }
        boolean disableSOAP12 = false;
        Parameter disableSOAP12Parameter = this.axisService.getParameter("disableSOAP12");
        if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly((Object)disableSOAP12Parameter.getValue())) {
            disableSOAP12 = true;
        }
        WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)this.axisService, (OMElement)ele, (OMFactory)fac, (OMNamespace)this.wsdl);
        ele.addAttribute("targetNamespace", this.axisService.getTargetNamespace(), null);
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        ele.addChild((OMNode)wsdlTypes);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            String targetNamespace = schema.getTargetNamespace();
            if ("http://www.w3.org/XML/1998/namespace".equals(targetNamespace)) continue;
            schema.write((Writer)writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            wsdlTypes.addChild(XMLUtils.toOM((Reader)new StringReader(schemaString)));
        }
        this.generateMessages(fac, ele);
        this.generatePortType(fac, ele);
        this.generateService(fac, ele, disableREST, disableSOAP12, disableSOAP11);
        this.addPoliciesToDefinitionElement(this.policiesInDefinitions.values().iterator(), this.definition);
        return ele;
    }

    private void generateMessages(OMFactory fac, OMElement defintions) {
        HashSet<String> faultMessageNames = new HashSet<String>();
        this.messagesMap = new HashMap();
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                this.writeMessage(inaxisMessage, fac, defintions);
                this.generateHeaderMessages(inaxisMessage, fac, defintions);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                this.writeMessage(outAxisMessage, fac, defintions);
                this.generateHeaderMessages(outAxisMessage, fac, defintions);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (Object faultyMessage : faultyMessages) {
                AxisMessage axisMessage = (AxisMessage)faultyMessage;
                String name = axisMessage.getName();
                if (!faultMessageNames.add(name)) continue;
                this.writeMessage(axisMessage, fac, defintions);
                this.generateHeaderMessages(axisMessage, fac, defintions);
            }
        }
    }

    private void generateHeaderMessages(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        ArrayList extList = axismessage.getSoapHeaders();
        for (Object anExtList : extList) {
            SOAPHeaderMessage header = (SOAPHeaderMessage)anExtList;
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", header.getMessage().getLocalPart(), null);
            defintions.addChild((OMNode)messageElement);
            OMElement messagePart = fac.createOMElement("part", this.wsdl);
            messageElement.addChild((OMNode)messagePart);
            messagePart.addAttribute("name", header.part(), null);
            if (header.getElement() == null) {
                throw new RuntimeException("element is null for " + header.getMessage());
            }
            messagePart.addAttribute("element", WSDLSerializationUtil.getPrefix((String)header.getElement().getNamespaceURI(), (Map)this.axisService.getNamespaceMap()) + ":" + header.getElement().getLocalPart(), null);
        }
    }

    private void writeMessage(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        if (this.messagesMap.get(axismessage.getName()) == null) {
            this.messagesMap.put(axismessage.getName(), axismessage);
            QName schemaElementName = axismessage.getElementQName();
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", axismessage.getName(), null);
            defintions.addChild((OMNode)messageElement);
            if (schemaElementName != null) {
                OMElement messagePart = fac.createOMElement("part", this.wsdl);
                messageElement.addChild((OMNode)messagePart);
                if (axismessage.getMessagePartName() != null) {
                    messagePart.addAttribute("name", axismessage.getMessagePartName(), null);
                } else {
                    messagePart.addAttribute("name", axismessage.getPartName(), null);
                }
                messagePart.addAttribute("element", WSDLSerializationUtil.getPrefix((String)schemaElementName.getNamespaceURI(), (Map)this.axisService.getNamespaceMap()) + ":" + schemaElementName.getLocalPart(), null);
            }
        }
    }

    private void generatePortType(OMFactory fac, OMElement defintions) throws Exception {
        OMElement portType = fac.createOMElement("portType", this.wsdl);
        defintions.addChild((OMNode)portType);
        portType.addAttribute("name", this.serviceName + "PortType", null);
        this.addPolicyAsExtAttribute((AxisDescription)this.axisService, portType, fac);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)axisOperation, (OMElement)operation, (OMFactory)fac, (OMNamespace)this.wsdl);
            portType.addChild((OMNode)operation);
            operation.addAttribute("name", operationName, null);
            this.addPolicyAsExtAttribute((AxisDescription)axisOperation, operation, fac);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                OMElement input = fac.createOMElement("input", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)inaxisMessage, (OMElement)input, (OMFactory)fac, (OMNamespace)this.wsdl);
                input.addAttribute("message", this.tns.getPrefix() + ":" + inaxisMessage.getName(), null);
                this.addPolicyAsExtAttribute((AxisDescription)inaxisMessage, input, fac);
                WSDLSerializationUtil.addWSAWActionAttribute((OMElement)input, (String)axisOperation.getInputAction(), (OMNamespace)this.wsaw);
                operation.addChild((OMNode)input);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)outAxisMessage, (OMElement)output, (OMFactory)fac, (OMNamespace)this.wsdl);
                output.addAttribute("message", this.tns.getPrefix() + ":" + outAxisMessage.getName(), null);
                this.addPolicyAsExtAttribute((AxisDescription)outAxisMessage, output, fac);
                WSDLSerializationUtil.addWSAWActionAttribute((OMElement)output, (String)axisOperation.getOutputAction(), (OMNamespace)this.wsaw);
                operation.addChild((OMNode)output);
            }
            if ((faultMessages = axisOperation.getFaultMessages()) == null) continue;
            for (Object faultMessage : faultMessages) {
                AxisMessage faultyMessage = (AxisMessage)faultMessage;
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)faultyMessage, (OMElement)fault, (OMFactory)fac, (OMNamespace)this.wsdl);
                fault.addAttribute("message", this.tns.getPrefix() + ":" + faultyMessage.getName(), null);
                fault.addAttribute("name", faultyMessage.getName(), null);
                WSDLSerializationUtil.addWSAWActionAttribute((OMElement)fault, (String)axisOperation.getFaultAction(faultyMessage.getName()), (OMNamespace)this.wsaw);
                operation.addChild((OMNode)fault);
            }
        }
    }

    public void generateService(OMFactory fac, OMElement defintions, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11) throws Exception {
        OMElement service = fac.createOMElement("service", this.wsdl);
        defintions.addChild((OMNode)service);
        service.addAttribute("name", this.serviceName, null);
        if (!disableSOAP11) {
            this.generateSoap11Port(fac, defintions, service);
        }
        if (!disableSOAP12) {
            this.generateSoap12Port(fac, defintions, service);
        }
        this.addPolicyAsExtElement(6, this.axisService.getPolicyInclude(), service);
        if (!disableREST) {
            this.generateHttpPort(fac, this.definition, service);
        }
    }

    private void writeSoapHeaders(AxisMessage inaxisMessage, OMFactory fac, OMElement input, OMNamespace soapNameSpace) throws Exception {
        ArrayList extElementList = inaxisMessage.getSoapHeaders();
        if (extElementList != null) {
            for (SOAPHeaderMessage soapheader : extElementList) {
                this.addSOAPHeader(fac, input, soapheader, soapNameSpace);
            }
        }
    }

    private void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, String att2Name, String att2Value, OMNamespace soapNameSpace) {
        OMElement soapbinding = fac.createOMElement(name, soapNameSpace);
        element.addChild((OMNode)soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        if (att2Name != null) {
            soapbinding.addAttribute(att2Name, att2Value, null);
        }
    }

    private void setDefinitionElement(OMElement defintion) {
        this.definition = defintion;
    }

    private void addSOAPHeader(OMFactory fac, OMElement element, SOAPHeaderMessage header, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement("header", soapNameSpace);
        element.addChild((OMNode)extElement);
        String use = header.getUse();
        if (use != null) {
            extElement.addAttribute("use", use, null);
        }
        if (header.part() != null) {
            extElement.addAttribute("part", header.part(), null);
        }
        if (header.getMessage() != null) {
            extElement.addAttribute("message", WSDLSerializationUtil.getPrefix((String)this.targetNamespace, (Map)this.axisService.getNamespaceMap()) + ":" + header.getMessage().getLocalPart(), null);
        }
    }

    private void addPolicyAsExtElement(int type, PolicyInclude policyInclude, OMElement parentElement) throws Exception {
        ArrayList elementList = policyInclude.getPolicyElements(type);
        for (Object policyElement : elementList) {
            Policy p;
            OMElement child;
            if (policyElement instanceof Policy) {
                child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)((PolicyComponent)policyElement), (ExternalPolicySerializer)this.serializer);
                parentElement.addChild((OMNode)child);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)((PolicyComponent)policyElement));
            OMElement firstChildElem = parentElement.getFirstElement();
            if (firstChildElem == null) {
                parentElement.addChild((OMNode)child);
            } else {
                firstChildElem.insertSiblingBefore((OMNode)child);
            }
            PolicyRegistry reg = policyInclude.getPolicyRegistry();
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = reg.lookup(key)) == null) {
                throw new Exception("Policy not found for uri : " + key);
            }
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    private void addPoliciesToDefinitionElement(Iterator iterator, OMElement definitionElement) throws Exception {
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            OMElement policyElement = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policy, (ExternalPolicySerializer)this.serializer);
            OMNode firstChild = this.definition.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore((OMNode)policyElement);
                continue;
            }
            definitionElement.addChild((OMNode)policyElement);
        }
    }

    private void addPolicyToDefinitionElement(String key, Policy policy) {
        this.policiesInDefinitions.put(key, policy);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    private void generateSoap11Port(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            String version;
            AxisBinding axisBinding;
            String type;
            if (!axisEndpoint.isActive() || !"http://schemas.xmlsoap.org/soap/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)port, (String)"address", (String)"location", (String)(endpointURL == null ? "" : endpointURL), (OMNamespace)this.soap);
            this.generateEPRElement(fac, port, endpointURL);
            this.addPolicyAsExtElement((AxisDescription)axisEndpoint, port);
            this.generateSoap11Binding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateSoap12Port(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            String version;
            AxisBinding axisBinding;
            String type;
            if (!axisEndpoint.isActive() || !"http://schemas.xmlsoap.org/soap/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://www.w3.org/2003/05/soap-envelope".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)port, (String)"address", (String)"location", (String)(endpointURL == null ? "" : endpointURL), (OMNamespace)this.soap12);
            this.generateEPRElement(fac, port, endpointURL);
            this.addPolicyAsExtElement((AxisDescription)axisEndpoint, port);
            this.generateSoap12Binding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateHttpPort(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            AxisBinding axisBinding;
            String type;
            if (!axisEndpoint.isActive() || !"http://www.w3.org/ns/wsdl/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType())) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            OMElement extElement = fac.createOMElement("address", this.http);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            extElement.addAttribute("location", endpointURL == null ? "" : endpointURL, null);
            port.addChild((OMNode)extElement);
            this.addPolicyAsExtElement((AxisDescription)axisEndpoint, port);
            this.generateHttpBinding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateSoap11Binding(OMFactory fac, OMElement defintions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, defintions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = defintions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore((OMNode)binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        this.addPolicyAsExtElement((AxisDescription)axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap);
        if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        }
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement((AxisDescription)axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisBindingOperation.getFaults()) == null) continue;
            for (Object faultyMessage1 : faultyMessages) {
                AxisBindingMessage bindingFaultyMessage = (AxisBindingMessage)faultyMessage1;
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap);
            }
        }
    }

    private void generateSoap12Binding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, definitions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore((OMNode)binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        this.addPolicyAsExtElement((AxisDescription)axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap12);
        if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        }
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement((AxisDescription)axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap12);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisBindingOperation.getFaults()) == null) continue;
            for (Object faultyMessage1 : faultyMessages) {
                AxisBindingMessage bindingFaultyMessage = (AxisBindingMessage)faultyMessage1;
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap12);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap12);
            }
        }
    }

    private void generateHttpBinding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, definitions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore((OMNode)binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.serviceName + "PortType", null);
        OMElement httpBinding = fac.createOMElement("binding", this.http);
        binding.addChild((OMNode)httpBinding);
        httpBinding.addAttribute("verb", "POST", null);
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            OMElement httpOperation = fac.createOMElement("operation", this.http);
            operation.addChild((OMNode)httpOperation);
            httpOperation.addAttribute("location", this.serviceName + "/" + axisOperation.getName().getLocalPart(), null);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                OMElement inputelement = fac.createOMElement("content", this.mime);
                input.addChild((OMNode)inputelement);
                inputelement.addAttribute("type", "text/xml", null);
                inputelement.addAttribute("part", axisOperation.getName().getLocalPart(), null);
                operation.addChild((OMNode)input);
            }
            if (!"http://www.w3.org/ns/wsdl/out-only".equals(MEP) && !"http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) && !"http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) && !"http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) && !"http://www.w3.org/ns/wsdl/in-out".equals(MEP) || (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"Out")) == null || (outAxisMessage = axisBindingOutMessage.getAxisMessage()) == null) continue;
            OMElement output = fac.createOMElement("output", this.wsdl);
            OMElement outElement = fac.createOMElement("content", this.mime);
            outElement.addChild((OMNode)outElement);
            outElement.addAttribute("type", "text/xml", null);
            outElement.addAttribute("part", axisOperation.getName().getLocalPart(), null);
            output.addChild((OMNode)outElement);
            operation.addChild((OMNode)output);
        }
    }

    private void addPolicyAsExtElement(AxisDescription axisDescription, OMElement wsdlElement) throws Exception {
        PolicySubject policySubject = axisDescription.getPolicySubject();
        Collection attachPolicyComponents = policySubject.getAttachedPolicyComponents();
        for (Object policyElement : attachPolicyComponents) {
            PolicyLocator locator;
            Policy p;
            if (policyElement instanceof Policy) {
                PolicyReference policyReference = PolicyUtil.createPolicyReference((Policy)((Policy)policyElement));
                OMElement policyRefElement = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyReference, (ExternalPolicySerializer)this.serializer);
                OMElement firstChildElem = wsdlElement.getFirstElement();
                if (firstChildElem == null) {
                    wsdlElement.addChild((OMNode)policyRefElement);
                } else {
                    firstChildElem.insertSiblingBefore((OMNode)policyRefElement);
                }
                String key = policyReference.getURI();
                if (key.startsWith("#")) {
                    key = key.substring(key.indexOf("#") + 1);
                }
                this.addPolicyToDefinitionElement(key, (Policy)policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            OMElement child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)((PolicyComponent)policyElement), (ExternalPolicySerializer)this.serializer);
            OMElement firstChildElem = wsdlElement.getFirstElement();
            if (firstChildElem == null) {
                wsdlElement.addChild((OMNode)child);
            } else {
                firstChildElem.insertSiblingBefore((OMNode)child);
            }
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = (locator = new PolicyLocator(this.axisService)).lookup(key)) == null) {
                throw new Exception("Policy not found for uri : " + key);
            }
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addPolicyAsExtAttribute(AxisDescription axisDescription, OMElement element, OMFactory factory) throws Exception {
        String uri;
        PolicySubject policySubject = axisDescription.getPolicySubject();
        ArrayList<Object> policyURIs = new ArrayList<Object>();
        for (PolicyComponent policyElement : policySubject.getAttachedPolicyComponents()) {
            void var8_14;
            if (policyElement instanceof Policy) {
                void var8_11;
                Policy p = (Policy)policyElement;
                if (p.getId() != null) {
                    String string = "#" + p.getId();
                } else if (p.getName() != null) {
                    String string = p.getName();
                } else {
                    throw new RuntimeException("Can't add the Policy as an extensibility attribute since it doesn't have a id or a name attribute");
                }
                policyURIs.add(var8_11);
                this.addPolicyToDefinitionElement((String)var8_11, p);
                continue;
            }
            uri = ((PolicyReference)policyElement).getURI();
            PolicyLocator locator = new PolicyLocator(this.axisService);
            if (uri.startsWith("#")) {
                String string = uri.substring(uri.indexOf(35) + 1);
            } else {
                String string = uri;
            }
            Policy p = locator.lookup((String)var8_14);
            if (p == null) {
                throw new RuntimeException("Cannot resolve " + uri + " to a Policy");
            }
            policyURIs.add(uri);
            this.addPolicyToDefinitionElement((String)var8_14, p);
        }
        if (!policyURIs.isEmpty()) {
            String value = null;
            for (Object e : policyURIs) {
                uri = (String)e;
                value = value == null ? uri : value + " " + uri;
            }
            OMNamespace ns = factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            OMAttribute oMAttribute = factory.createOMAttribute("PolicyURIs", ns, value);
            element.addAttribute(oMAttribute);
        }
    }

    private boolean isAlreadyAdded(AxisBinding axisBinding, OMElement definitionElement) {
        QName bindingName = axisBinding.getName();
        QName name = new QName("name");
        Iterator iterator = definitionElement.getChildrenWithName(new QName(this.wsdl.getNamespaceURI(), "binding"));
        while (iterator.hasNext()) {
            OMElement element = (OMElement)iterator.next();
            String value = element.getAttributeValue(name);
            if (!bindingName.getLocalPart().equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getEndpointURL(AxisEndpoint axisEndpoint) {
        return this.axisService.getEndpointURL();
    }

    private void generateIdentityElement(OMFactory fac, OMElement epr, Parameter wsaIdParam) {
        OMElement identity = fac.createOMElement(AddressingConstants.QNAME_IDENTITY);
        OMElement keyInfo = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_KEY_INFO);
        OMElement x509Data = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_X509_DATA);
        OMElement x509cert = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_X509_CERT);
        x509cert.setText((String)wsaIdParam.getValue());
        x509Data.addChild((OMNode)x509cert);
        keyInfo.addChild((OMNode)x509Data);
        identity.addChild((OMNode)keyInfo);
        epr.addChild((OMNode)identity);
    }

    private void generateEPRElement(OMFactory fac, OMElement port, String endpointURL) {
        Parameter parameter = this.axisService.getParameter("WSAddressingAndIdentity");
        if (parameter == null || parameter.getValue() == null) {
            return;
        }
        OMElement wsaEpr = fac.createOMElement(AddressingConstants.Final.WSA_ENDPOINT_REFERENCE);
        OMElement address = fac.createOMElement(AddressingConstants.Final.WSA_ADDRESS);
        address.setText(endpointURL == null ? "" : endpointURL);
        wsaEpr.addChild((OMNode)address);
        this.generateIdentityElement(fac, wsaEpr, parameter);
        port.addChild((OMNode)wsaEpr);
    }

    private void generateSOAP11Binding(OMFactory fac, OMElement defintions) throws Exception {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.axisService.getName() + "SOAP11Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        this.addPolicyAsExtElement(3, this.axisService.getPolicyInclude(), binding);
        this.addPolicyAsExtElement(9, this.axisService.getPolicyInclude(), binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap);
        if (this.axisService.getWSAddressingFlag().equals("optional")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        } else if (this.axisService.getWSAddressingFlag().equals("required")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        }
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap);
            this.addPolicyAsExtElement(11, axisOperation.getPolicyInclude(), operation);
            this.addPolicyAsExtElement(4, axisOperation.getPolicyInclude(), operation);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", operationName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap);
                this.addPolicyAsExtElement(14, inaxisMessage.getPolicyInclude(), input);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap);
                this.addPolicyAsExtElement(15, outAxisMessage.getPolicyInclude(), output);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessage = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap);
            }
        }
    }

    private void generateSOAP12Binding(OMFactory fac, OMElement defintions) throws Exception {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.axisService.getName() + "SOAP12Binding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        this.addPolicyAsExtElement(3, this.axisService.getPolicyInclude(), binding);
        this.addPolicyAsExtElement(9, this.axisService.getPolicyInclude(), binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap12);
        if (this.axisService.getWSAddressingFlag().equals("optional")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        } else if (this.axisService.getWSAddressingFlag().equals("required")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        }
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap12);
            this.addPolicyAsExtElement(11, axisOperation.getPolicyInclude(), operation);
            this.addPolicyAsExtElement(4, axisOperation.getPolicyInclude(), operation);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                this.addPolicyAsExtElement(14, inaxisMessage.getPolicyInclude(), input);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                this.addPolicyAsExtElement(15, outAxisMessage.getPolicyInclude(), output);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (int i = 0; i < faultyMessages.size(); ++i) {
                AxisMessage faultyMessage = (AxisMessage)faultyMessages.get(i);
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap12);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap12);
            }
        }
    }

    private void generateHTTPBinding(OMFactory fac, OMElement defintions) throws Exception {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        defintions.addChild((OMNode)binding);
        binding.addAttribute("name", this.axisService.getName() + "HttpBinding", null);
        binding.addAttribute("type", this.tns.getPrefix() + ":" + this.axisService.getName() + "PortType", null);
        OMElement httpBinding = fac.createOMElement("binding", this.http);
        binding.addChild((OMNode)httpBinding);
        httpBinding.addAttribute("verb", "POST", null);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            OMElement httpOperation = fac.createOMElement("operation", this.http);
            operation.addChild((OMNode)httpOperation);
            httpOperation.addAttribute("location", this.axisService.getName() + "/" + axisOperation.getName().getLocalPart(), null);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                OMElement inputelement = fac.createOMElement("content", this.mime);
                input.addChild((OMNode)inputelement);
                inputelement.addAttribute("type", "text/xml", null);
                inputelement.addAttribute("part", axisOperation.getName().getLocalPart(), null);
                operation.addChild((OMNode)input);
            }
            if (!"http://www.w3.org/ns/wsdl/out-only".equals(MEP) && !"http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) && !"http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) && !"http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) && !"http://www.w3.org/ns/wsdl/in-out".equals(MEP) || (outAxisMessage = axisOperation.getMessage("Out")) == null) continue;
            OMElement output = fac.createOMElement("output", this.wsdl);
            OMElement outElement = fac.createOMElement("content", this.mime);
            outElement.addChild((OMNode)outElement);
            outElement.addAttribute("type", "text/xml", null);
            outElement.addAttribute("part", axisOperation.getName().getLocalPart(), null);
            output.addChild((OMNode)outElement);
            operation.addChild((OMNode)output);
        }
    }
}

