/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.ClassStrategy;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.DiscriminatorMappingInfo;
import org.apache.openjpa.jdbc.meta.DiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldMappingInfo;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.JDBCOrder;
import org.apache.openjpa.jdbc.meta.JDBCRelatedFieldOrder;
import org.apache.openjpa.jdbc.meta.JDBCValueOrder;
import org.apache.openjpa.jdbc.meta.MappingDefaults;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.meta.RuntimeStrategyInstaller;
import org.apache.openjpa.jdbc.meta.SequenceMapping;
import org.apache.openjpa.jdbc.meta.StrategyInstaller;
import org.apache.openjpa.jdbc.meta.ValueHandler;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionMappingInfo;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.BlobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.ByteArrayValueHandler;
import org.apache.openjpa.jdbc.meta.strats.CharArrayStreamValueHandler;
import org.apache.openjpa.jdbc.meta.strats.CharArrayValueHandler;
import org.apache.openjpa.jdbc.meta.strats.ClassNameDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.ClobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.ElementEmbedValueHandler;
import org.apache.openjpa.jdbc.meta.strats.EmbedFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.EmbeddedClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.FlatClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.FullClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerCollectionTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerHandlerMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerRelationMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.ImmutableValueHandler;
import org.apache.openjpa.jdbc.meta.strats.LobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedBlobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedByteArrayFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedCharArrayFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedClobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.NanoPrecisionTimestampVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NumberVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.ObjectIdClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.ObjectIdValueHandler;
import org.apache.openjpa.jdbc.meta.strats.PrimitiveFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationCollectionInverseKeyFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationCollectionTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationHandlerMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationMapInverseKeyFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationRelationMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.StateComparisonVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.StringFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.SubclassJoinDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.SuperclassDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.SuperclassVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.TimestampVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.UntypedPCValueHandler;
import org.apache.openjpa.jdbc.meta.strats.ValueMapDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.VerticalClassStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.Order;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.MetaDataException;

public class MappingRepository
extends MetaDataRepository {
    private static final Localizer _loc = Localizer.forPackage(MappingRepository.class);
    private transient DBDictionary _dict = null;
    private transient MappingDefaults _defaults = null;
    private Map _results = new HashMap();
    private SchemaGroup _schema = null;
    private StrategyInstaller _installer = null;

    public MappingRepository() {
        this.setValidate(2, true);
    }

    public DBDictionary getDBDictionary() {
        return this._dict;
    }

    public MappingDefaults getMappingDefaults() {
        return this._defaults;
    }

    public void setMappingDefaults(MappingDefaults defaults) {
        this._defaults = defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaGroup getSchemaGroup() {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                if (this._schema == null) {
                    this._schema = ((JDBCConfiguration)this.getConfiguration()).getSchemaFactoryInstance().readSchema();
                }
                return this._schema;
            }
        }
        if (this._schema == null) {
            this._schema = ((JDBCConfiguration)this.getConfiguration()).getSchemaFactoryInstance().readSchema();
        }
        return this._schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchemaGroup(SchemaGroup schema) {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                this._schema = schema;
            }
        } else {
            this._schema = schema;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StrategyInstaller getStrategyInstaller() {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                if (this._installer == null) {
                    this._installer = new RuntimeStrategyInstaller(this);
                }
                return this._installer;
            }
        }
        if (this._installer == null) {
            this._installer = new RuntimeStrategyInstaller(this);
        }
        return this._installer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrategyInstaller(StrategyInstaller installer) {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                this._installer = installer;
            }
        } else {
            this._installer = installer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResultMapping getQueryResultMapping(Class cls, String name, ClassLoader envLoader, boolean mustExist) {
        QueryResultMapping res = null;
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                res = this.getQueryResultMappingInternal(cls, name, envLoader);
            }
        } else {
            res = this.getQueryResultMappingInternal(cls, name, envLoader);
        }
        if (res == null && mustExist) {
            throw new MetaDataException(_loc.get("no-query-res", cls, name));
        }
        return res;
    }

    private QueryResultMapping getQueryResultMappingInternal(Class cls, String name, ClassLoader envLoader) {
        if (name == null) {
            return null;
        }
        Object key = MappingRepository.getQueryResultKey(cls, name);
        QueryResultMapping res = (QueryResultMapping)this._results.get(key);
        if (res != null) {
            return res;
        }
        if (cls != null && this.getMetaData(cls, envLoader, false) != null && (res = (QueryResultMapping)this._results.get(key)) != null) {
            return res;
        }
        if ((this.getSourceMode() & 4) == 0) {
            return null;
        }
        if (cls == null) {
            cls = this.getMetaDataFactory().getResultSetMappingScope(name, envLoader);
        }
        this.getMetaDataFactory().load(cls, 3, envLoader);
        return (QueryResultMapping)this._results.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResultMapping[] getQueryResultMappings() {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                Collection values = this._results.values();
                return values.toArray(new QueryResultMapping[values.size()]);
            }
        }
        Collection values = this._results.values();
        return values.toArray(new QueryResultMapping[values.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResultMapping getCachedQueryResultMapping(Class cls, String name) {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                return (QueryResultMapping)this._results.get(MappingRepository.getQueryResultKey(cls, name));
            }
        }
        return (QueryResultMapping)this._results.get(MappingRepository.getQueryResultKey(cls, name));
    }

    public QueryResultMapping addQueryResultMapping(Class cls, String name) {
        if (this._locking) {
            return this.addQueryResultMappingLocking(cls, name);
        }
        return this.addQueryResultMappingInternal(cls, name);
    }

    private synchronized QueryResultMapping addQueryResultMappingLocking(Class cls, String name) {
        return this.addQueryResultMappingInternal(cls, name);
    }

    private QueryResultMapping addQueryResultMappingInternal(Class cls, String name) {
        QueryResultMapping res = new QueryResultMapping(name, this);
        res.setDefiningType(cls);
        this._results.put(MappingRepository.getQueryResultKey(res), res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeQueryResultMapping(QueryResultMapping res) {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                return this._results.remove(MappingRepository.getQueryResultKey(res)) != null;
            }
        }
        return this._results.remove(MappingRepository.getQueryResultKey(res)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeQueryResultMapping(Class cls, String name) {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                if (name == null) {
                    return false;
                }
                return this._results.remove(MappingRepository.getQueryResultKey(cls, name)) != null;
            }
        }
        if (name == null) {
            return false;
        }
        return this._results.remove(MappingRepository.getQueryResultKey(cls, name)) != null;
    }

    private static Object getQueryResultKey(QueryResultMapping res) {
        if (res == null) {
            return null;
        }
        return MappingRepository.getQueryResultKey(res.getDefiningType(), res.getName());
    }

    private static Object getQueryResultKey(Class cls, String name) {
        return MappingRepository.getQueryKey(cls, name);
    }

    public ClassMapping getMapping(Class cls, ClassLoader envLoader, boolean mustExist) {
        return (ClassMapping)super.getMetaData(cls, envLoader, mustExist);
    }

    public ClassMapping[] getMappings() {
        return (ClassMapping[])super.getMetaDatas();
    }

    public ClassMapping getMapping(Object oid, ClassLoader envLoader, boolean mustExist) {
        return (ClassMapping)super.getMetaData(oid, envLoader, mustExist);
    }

    public ClassMapping[] getImplementorMappings(Class cls, ClassLoader envLoader, boolean mustExist) {
        return (ClassMapping[])super.getImplementorMetaDatas(cls, envLoader, mustExist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this._locking) {
            MappingRepository mappingRepository = this;
            synchronized (mappingRepository) {
                super.clear();
                this._schema = null;
                this._results.clear();
            }
        } else {
            super.clear();
            this._schema = null;
            this._results.clear();
        }
    }

    protected void prepareMapping(ClassMetaData meta) {
        ClassMapping baseMapping;
        ClassMapping mapping = (ClassMapping)meta;
        ClassMapping sup = mapping.getPCSuperclassMapping();
        if (sup != null && (mapping.getResolve() & 2) != 0) {
            return;
        }
        if (!(mapping.getDescribedType().isInterface() || mapping.isEmbeddedOnly() || this.hasInheritanceStrategy(mapping) || (baseMapping = this.findBaseClassMapping(mapping)) == null)) {
            this.setDefaultInheritanceStrategy(baseMapping);
        }
        this.getStrategyInstaller().installStrategy(mapping);
        mapping.defineSuperclassFields(mapping.getJoinablePCSuperclassMapping() == null);
        mapping.resolveNonRelationMappings();
    }

    protected ClassMetaData newClassMetaData(Class type) {
        return new ClassMapping(type, this);
    }

    protected ClassMetaData[] newClassMetaDataArray(int length) {
        return new ClassMapping[length];
    }

    protected FieldMetaData newFieldMetaData(String name, Class type, ClassMetaData owner) {
        return new FieldMapping(name, type, (ClassMapping)owner);
    }

    protected FieldMetaData[] newFieldMetaDataArray(int length) {
        return new FieldMapping[length];
    }

    protected ClassMetaData newEmbeddedClassMetaData(ValueMetaData owner) {
        return new ClassMapping(owner);
    }

    protected ValueMetaData newValueMetaData(FieldMetaData owner) {
        return new ValueMappingImpl((FieldMapping)owner);
    }

    protected SequenceMetaData newSequenceMetaData(String name) {
        return new SequenceMapping(name, this);
    }

    protected Order newValueOrder(FieldMetaData owner, boolean asc) {
        return new JDBCValueOrder((FieldMapping)owner, asc);
    }

    protected Order newRelatedFieldOrder(FieldMetaData owner, FieldMetaData rel, boolean asc) {
        return new JDBCRelatedFieldOrder((FieldMapping)owner, (FieldMapping)rel, asc);
    }

    protected Order[] newOrderArray(int size) {
        return new JDBCOrder[size];
    }

    protected Version newVersion(ClassMapping cls) {
        return new Version(cls);
    }

    protected Discriminator newDiscriminator(ClassMapping cls) {
        return new Discriminator(cls);
    }

    protected ClassMappingInfo newMappingInfo(ClassMapping cls) {
        ClassMappingInfo info = new ClassMappingInfo();
        info.setClassName(cls.getDescribedType().getName());
        return info;
    }

    protected FieldMappingInfo newMappingInfo(FieldMapping fm) {
        return new FieldMappingInfo();
    }

    protected ValueMappingInfo newMappingInfo(ValueMapping vm) {
        return new ValueMappingInfo();
    }

    protected VersionMappingInfo newMappingInfo(Version version) {
        return new VersionMappingInfo();
    }

    protected DiscriminatorMappingInfo newMappingInfo(Discriminator disc) {
        return new DiscriminatorMappingInfo();
    }

    protected ClassStrategy namedStrategy(ClassMapping cls) {
        String name = cls.getMappingInfo().getStrategy();
        return this.instantiateClassStrategy(name, cls);
    }

    protected ClassStrategy instantiateClassStrategy(String name, ClassMapping cls) {
        if (name == null) {
            return null;
        }
        if ("none".equals(name)) {
            return NoneClassStrategy.getInstance();
        }
        String props = Configurations.getProperties(name);
        name = Configurations.getClassName(name);
        Class strat = null;
        if ("full".equals(name)) {
            strat = FullClassStrategy.class;
        } else if ("flat".equals(name)) {
            strat = FlatClassStrategy.class;
        } else if ("vertical".equals(name)) {
            strat = VerticalClassStrategy.class;
        }
        try {
            if (strat == null) {
                strat = JavaTypes.classForName(name, cls, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(ClassStrategy.class)));
            }
            ClassStrategy strategy = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(strat));
            Configurations.configureInstance((Object)strategy, (Configuration)this.getConfiguration(), props);
            return strategy;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("bad-cls-strategy", cls, name), (Throwable)e);
        }
    }

    protected FieldStrategy namedStrategy(FieldMapping field, boolean installHandlers) {
        String name = field.getMappingInfo().getStrategy();
        if (name == null) {
            return null;
        }
        if ("none".equals(name)) {
            return NoneFieldStrategy.getInstance();
        }
        String props = Configurations.getProperties(name);
        name = Configurations.getClassName(name);
        try {
            Class c = JavaTypes.classForName(name, field, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(FieldStrategy.class)));
            if (FieldStrategy.class.isAssignableFrom(c)) {
                FieldStrategy strat = (FieldStrategy)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(c));
                Configurations.configureInstance((Object)strat, (Configuration)this.getConfiguration(), props);
                return strat;
            }
            if (installHandlers) {
                ValueHandler vh = (ValueHandler)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(c));
                Configurations.configureInstance((Object)vh, (Configuration)this.getConfiguration(), props);
                field.setHandler(vh);
            }
            return new HandlerFieldStrategy();
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("bad-field-strategy", field, name), (Throwable)e);
        }
    }

    protected DiscriminatorStrategy namedStrategy(Discriminator discrim) {
        String name = discrim.getMappingInfo().getStrategy();
        if (name == null) {
            return null;
        }
        ClassMapping cls = discrim.getClassMapping();
        while (cls.getJoinablePCSuperclassMapping() != null) {
            cls = cls.getJoinablePCSuperclassMapping();
        }
        Discriminator base = cls.getDiscriminator();
        if (base != discrim && base.getStrategy() != null && name.equals(base.getStrategy().getAlias())) {
            return null;
        }
        return this.instantiateDiscriminatorStrategy(name, discrim);
    }

    protected DiscriminatorStrategy instantiateDiscriminatorStrategy(String name, Discriminator discrim) {
        if ("none".equals(name)) {
            return NoneDiscriminatorStrategy.getInstance();
        }
        String props = Configurations.getProperties(name);
        name = Configurations.getClassName(name);
        Class strat = null;
        if ("class-name".equals(name)) {
            strat = ClassNameDiscriminatorStrategy.class;
        } else if ("value-map".equals(name)) {
            strat = ValueMapDiscriminatorStrategy.class;
        } else if ("subclass-join".equals(name)) {
            strat = SubclassJoinDiscriminatorStrategy.class;
        }
        try {
            if (strat == null) {
                strat = JavaTypes.classForName(name, discrim.getClassMapping(), AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(DiscriminatorStrategy.class)));
            }
            DiscriminatorStrategy strategy = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(strat));
            Configurations.configureInstance((Object)strategy, (Configuration)this.getConfiguration(), props);
            return strategy;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("bad-discrim-strategy", discrim.getClassMapping(), name), (Throwable)e);
        }
    }

    protected VersionStrategy namedStrategy(Version version) {
        String name = version.getMappingInfo().getStrategy();
        if (name == null) {
            return null;
        }
        ClassMapping cls = version.getClassMapping();
        while (cls.getJoinablePCSuperclassMapping() != null) {
            cls = cls.getJoinablePCSuperclassMapping();
        }
        Version base = cls.getVersion();
        if (base != version && base.getStrategy() != null && name.equals(base.getStrategy().getAlias())) {
            return null;
        }
        return this.instantiateVersionStrategy(name, version);
    }

    protected VersionStrategy instantiateVersionStrategy(String name, Version version) {
        if ("none".equals(name)) {
            return NoneVersionStrategy.getInstance();
        }
        String props = Configurations.getProperties(name);
        name = Configurations.getClassName(name);
        Class strat = null;
        if ("version-number".equals(name)) {
            strat = NumberVersionStrategy.class;
        } else if ("timestamp".equals(name)) {
            strat = TimestampVersionStrategy.class;
        } else if ("nano-timestamp".equals(name)) {
            strat = NanoPrecisionTimestampVersionStrategy.class;
        } else if ("state-comparison".equals(name)) {
            strat = StateComparisonVersionStrategy.class;
        }
        try {
            if (strat == null) {
                strat = JavaTypes.classForName(name, version.getClassMapping(), AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(VersionStrategy.class)));
            }
        }
        catch (Exception e) {
            throw new MetaDataException(_loc.get("bad-version-strategy", version.getClassMapping(), name), (Throwable)e);
        }
        return this.instantiateVersionStrategy(strat, version, props);
    }

    protected VersionStrategy instantiateVersionStrategy(Class strat, Version version, String props) {
        try {
            VersionStrategy strategy = (VersionStrategy)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(strat));
            Configurations.configureInstance((Object)strategy, (Configuration)this.getConfiguration(), props);
            return strategy;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("bad-version-strategy", version.getClassMapping(), strat + ""), (Throwable)e);
        }
    }

    protected ClassStrategy defaultStrategy(ClassMapping cls) {
        return this.defaultStrategy(cls, this.getStrategyInstaller().isAdapting());
    }

    protected ClassStrategy defaultStrategy(ClassMapping cls, boolean adapting) {
        ValueMapping embed = cls.getEmbeddingMapping();
        if (embed != null) {
            if (embed.getType() != cls.getDescribedType() || embed.getFieldMapping().getStrategy() == NoneFieldStrategy.getInstance()) {
                return NoneClassStrategy.getInstance();
            }
            if (embed.getTypeCode() == 29) {
                return new ObjectIdClassStrategy();
            }
            return new EmbeddedClassStrategy();
        }
        if (cls.isEmbeddedOnly()) {
            return NoneClassStrategy.getInstance();
        }
        Object strat = this._defaults.getStrategy(cls, adapting);
        if (strat instanceof String) {
            return this.instantiateClassStrategy((String)strat, cls);
        }
        if (strat != null) {
            return (ClassStrategy)strat;
        }
        ClassStrategy hstrat = null;
        for (ClassMapping base = cls; base != null && hstrat == null; base = base.getMappedPCSuperclassMapping()) {
            hstrat = this.instantiateClassStrategy(base.getMappingInfo().getHierarchyStrategy(), cls);
        }
        if (hstrat instanceof FullClassStrategy && !cls.isManagedInterface() && Modifier.isAbstract(cls.getDescribedType().getModifiers())) {
            return NoneClassStrategy.getInstance();
        }
        ClassMapping sup = cls.getMappedPCSuperclassMapping();
        if (sup == null) {
            return new FullClassStrategy();
        }
        if (hstrat != null) {
            return hstrat;
        }
        return new FlatClassStrategy();
    }

    protected FieldStrategy defaultStrategy(FieldMapping field, boolean installHandlers) {
        return this.defaultStrategy(field, installHandlers, this.getStrategyInstaller().isAdapting());
    }

    protected FieldStrategy defaultStrategy(FieldMapping field, boolean installHandlers, boolean adapting) {
        Object strat;
        if (field.getManagement() != 3 || field.isVersion()) {
            return NoneFieldStrategy.getInstance();
        }
        if (field.getDefiningMapping().getStrategy() == NoneClassStrategy.getInstance()) {
            return NoneFieldStrategy.getInstance();
        }
        ValueHandler handler = this.namedHandler(field);
        if (handler != null) {
            if (installHandlers) {
                field.setHandler(handler);
            }
            return new HandlerFieldStrategy();
        }
        if (field.isSerialized()) {
            if (this._dict.maxEmbeddedBlobSize != -1) {
                return new MaxEmbeddedBlobFieldStrategy();
            }
        } else {
            strat = this.mappedStrategy(field, field.getType(), adapting);
            if (strat instanceof FieldStrategy) {
                return (FieldStrategy)strat;
            }
            if (strat != null) {
                if (installHandlers) {
                    field.setHandler((ValueHandler)strat);
                }
                return new HandlerFieldStrategy();
            }
        }
        if (!(field.isSerialized() || field.getType() != byte[].class && field.getType() != Byte[].class)) {
            if (this._dict.maxEmbeddedBlobSize != -1) {
                return new MaxEmbeddedByteArrayFieldStrategy();
            }
        } else if (!(field.isSerialized() || field.getType() != char[].class && field.getType() != Character[].class)) {
            if (this._dict.maxEmbeddedClobSize != -1 && this.isClob(field, false)) {
                return new MaxEmbeddedCharArrayFieldStrategy();
            }
        } else if (!field.isSerialized() && (strat = this.defaultTypeStrategy(field, installHandlers, adapting)) != null) {
            return strat;
        }
        if ((handler = this.defaultHandler(field, adapting)) != null) {
            if (installHandlers) {
                field.setHandler(handler);
            }
            return new HandlerFieldStrategy();
        }
        if (installHandlers) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn(_loc.get("no-field-strategy", field));
            }
            field.setSerialized(true);
        }
        if (this._dict.maxEmbeddedBlobSize == -1) {
            if (installHandlers) {
                field.setHandler(BlobValueHandler.getInstance());
            }
            return new HandlerFieldStrategy();
        }
        return new MaxEmbeddedBlobFieldStrategy();
    }

    protected FieldStrategy defaultTypeStrategy(FieldMapping field, boolean installHandlers, boolean adapting) {
        switch (field.getTypeCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return new PrimitiveFieldStrategy();
            }
            case 9: {
                if (!this.isClob(field, false)) {
                    return new StringFieldStrategy();
                }
                if (this._dict.maxEmbeddedClobSize == -1) break;
                return new MaxEmbeddedClobFieldStrategy();
            }
            case 15: {
                if (field.isEmbeddedPC()) {
                    return new EmbedFieldStrategy();
                }
                if (!field.getTypeMapping().isMapped() && this.useUntypedPCHandler(field)) break;
                return new RelationFieldStrategy();
            }
            case 11: 
            case 12: {
                ValueMapping elem = field.getElementMapping();
                ValueHandler ehandler = this.namedHandler(elem);
                if (ehandler == null) {
                    ehandler = this.defaultHandler(elem);
                }
                if (ehandler != null) {
                    return this.handlerCollectionStrategy(field, ehandler, installHandlers);
                }
                if (elem.getTypeCode() != 15 || elem.isSerialized() || elem.isEmbeddedPC()) break;
                if (this.useInverseKeyMapping(field)) {
                    return new RelationCollectionInverseKeyFieldStrategy();
                }
                return new RelationCollectionTableFieldStrategy();
            }
            case 13: {
                boolean vrel;
                ValueMapping val;
                ValueHandler vhandler;
                ValueMapping key = field.getKeyMapping();
                ValueHandler khandler = this.namedHandler(key);
                if (khandler == null) {
                    khandler = this.defaultHandler(key);
                }
                if ((vhandler = this.namedHandler(val = field.getElementMapping())) == null) {
                    vhandler = this.defaultHandler(val);
                }
                boolean krel = khandler == null && key.getTypeCode() == 15 && !key.isSerialized() && !key.isEmbeddedPC();
                boolean bl = vrel = vhandler == null && val.getTypeCode() == 15 && !val.isSerialized() && !val.isEmbeddedPC();
                if (!krel && vrel && key.getValueMappedBy() != null) {
                    if (this.useInverseKeyMapping(field)) {
                        return new RelationMapInverseKeyFieldStrategy();
                    }
                    return new RelationMapTableFieldStrategy();
                }
                if (!krel && khandler == null || !vrel && vhandler == null) break;
                return this.handlerMapStrategy(field, khandler, vhandler, krel, vrel, installHandlers);
            }
            case 30: 
            case 31: {
                return new LobFieldStrategy();
            }
        }
        return null;
    }

    protected FieldStrategy handlerCollectionStrategy(FieldMapping field, ValueHandler ehandler, boolean installHandlers) {
        if (this.getConfiguration().getCompatibilityInstance().getStoreMapCollectionInEntityAsBlob()) {
            return null;
        }
        if (installHandlers) {
            field.getElementMapping().setHandler(ehandler);
        }
        return new HandlerCollectionTableFieldStrategy();
    }

    protected FieldStrategy handlerMapStrategy(FieldMapping field, ValueHandler khandler, ValueHandler vhandler, boolean krel, boolean vrel, boolean installHandlers) {
        if (this.getConfiguration().getCompatibilityInstance().getStoreMapCollectionInEntityAsBlob()) {
            return null;
        }
        if (installHandlers) {
            field.getKeyMapping().setHandler(khandler);
            field.getElementMapping().setHandler(vhandler);
        }
        if (!krel && !vrel) {
            return new HandlerHandlerMapTableFieldStrategy();
        }
        if (!krel && vrel) {
            return new HandlerRelationMapTableFieldStrategy();
        }
        if (krel && !vrel) {
            return new RelationHandlerMapTableFieldStrategy();
        }
        return new RelationRelationMapTableFieldStrategy();
    }

    private boolean useInverseKeyMapping(FieldMapping field) {
        FieldMapping mapped = field.getMappedByMapping();
        if (mapped != null) {
            if (mapped.getTypeCode() == 15) {
                return true;
            }
            if (mapped.getElement().getTypeCode() == 15) {
                return false;
            }
            throw new MetaDataException(_loc.get("bad-mapped-by", field, mapped));
        }
        FieldMappingInfo info = field.getMappingInfo();
        ValueMapping elem = field.getElementMapping();
        return info.getTableName() == null && info.getColumns().isEmpty() && !elem.getValueInfo().getColumns().isEmpty();
    }

    private Object mappedStrategy(ValueMapping val, Class type, boolean adapting) {
        if (type == null || type == Object.class) {
            return null;
        }
        Object strat = this._defaults.getStrategy(val, type, adapting);
        if (strat == null) {
            return this.mappedStrategy(val, type.getSuperclass(), adapting);
        }
        if (!(strat instanceof String)) {
            return strat;
        }
        String name = (String)strat;
        if ("none".equals(name)) {
            return NoneFieldStrategy.getInstance();
        }
        String props = Configurations.getProperties(name);
        name = Configurations.getClassName(name);
        try {
            Class c = JavaTypes.classForName(name, val, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(FieldStrategy.class)));
            Object o = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(c));
            Configurations.configureInstance(o, (Configuration)this.getConfiguration(), props);
            return o;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("bad-mapped-strategy", val, name), (Throwable)e);
        }
    }

    protected ValueHandler namedHandler(ValueMapping val) {
        String name = val.getValueInfo().getStrategy();
        if (name == null) {
            return null;
        }
        String props = Configurations.getProperties(name);
        name = Configurations.getClassName(name);
        try {
            Class c = JavaTypes.classForName(name, val, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(ValueHandler.class)));
            if (ValueHandler.class.isAssignableFrom(c)) {
                ValueHandler vh = (ValueHandler)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(c));
                Configurations.configureInstance((Object)vh, (Configuration)this.getConfiguration(), props);
                return vh;
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("bad-value-handler", val, name), (Throwable)e);
        }
    }

    protected ValueHandler defaultHandler(ValueMapping val) {
        return this.defaultHandler(val, this.getStrategyInstaller().isAdapting());
    }

    protected ValueHandler defaultHandler(ValueMapping val, boolean adapting) {
        if (val.isSerialized()) {
            if (this._dict.maxEmbeddedBlobSize != -1) {
                this.warnMaxEmbedded(val, this._dict.maxEmbeddedBlobSize);
            }
            return BlobValueHandler.getInstance();
        }
        Object handler = this.mappedStrategy(val, val.getType(), adapting);
        if (handler instanceof ValueHandler) {
            return (ValueHandler)handler;
        }
        if (val.getType() == byte[].class || val.getType() == Byte[].class) {
            if (this._dict.maxEmbeddedBlobSize != -1) {
                this.warnMaxEmbedded(val, this._dict.maxEmbeddedBlobSize);
            }
            return ByteArrayValueHandler.getInstance();
        }
        if (val.getType() == char[].class || val.getType() == Character[].class) {
            if (this.isClob(val, true)) {
                return CharArrayStreamValueHandler.getInstance();
            }
            return CharArrayValueHandler.getInstance();
        }
        switch (val.getTypeCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                return ImmutableValueHandler.getInstance();
            }
            case 9: {
                if (this.isClob(val, true)) {
                    return ClobValueHandler.getInstance();
                }
                return ImmutableValueHandler.getInstance();
            }
            case 15: {
                if (val.getTypeMapping().isMapped() || !this.useUntypedPCHandler(val)) break;
                return UntypedPCValueHandler.getInstance();
            }
            case 27: {
                return UntypedPCValueHandler.getInstance();
            }
            case 29: {
                return new ObjectIdValueHandler();
            }
        }
        if (!this.getConfiguration().getCompatibilityInstance().getStoreMapCollectionInEntityAsBlob() && val.isEmbeddedPC()) {
            return new ElementEmbedValueHandler();
        }
        return null;
    }

    private boolean useUntypedPCHandler(ValueMapping val) {
        ClassMapping rel = val.getTypeMapping();
        return rel.getIdentityType() == 0 || rel.getIdentityType() == 2 && (rel.getPrimaryKeyFields().length == 0 || !rel.isOpenJPAIdentity() && Modifier.isAbstract(rel.getObjectIdType().getModifiers()));
    }

    private boolean isClob(ValueMapping val, boolean warn) {
        List cols = val.getValueInfo().getColumns();
        if (cols.size() != 1) {
            return false;
        }
        Column col = (Column)cols.get(0);
        if (col.getSize() != -1 && col.getType() != 2005) {
            return false;
        }
        if (this._dict.getPreferredType(2005) != 2005) {
            return false;
        }
        if (warn && this._dict.maxEmbeddedClobSize != -1) {
            this.warnMaxEmbedded(val, this._dict.maxEmbeddedClobSize);
        }
        return true;
    }

    private void warnMaxEmbedded(ValueMapping val, int size) {
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn(_loc.get("max-embed-lob", val, String.valueOf(size)));
        }
    }

    protected DiscriminatorStrategy defaultStrategy(Discriminator discrim) {
        return this.defaultStrategy(discrim, this.getStrategyInstaller().isAdapting());
    }

    protected DiscriminatorStrategy defaultStrategy(Discriminator discrim, boolean adapting) {
        ClassMapping cls = discrim.getClassMapping();
        if (cls.getEmbeddingMetaData() != null) {
            return NoneDiscriminatorStrategy.getInstance();
        }
        if (cls.getJoinablePCSuperclassMapping() == null && (cls.getStrategy() == NoneClassStrategy.getInstance() || Modifier.isFinal(discrim.getClassMapping().getDescribedType().getModifiers()))) {
            return NoneDiscriminatorStrategy.getInstance();
        }
        Object strat = this._defaults.getStrategy(discrim, adapting);
        if (strat instanceof String) {
            return this.instantiateDiscriminatorStrategy((String)strat, discrim);
        }
        if (strat != null) {
            return (DiscriminatorStrategy)strat;
        }
        if (cls.getJoinablePCSuperclassMapping() != null) {
            return new SuperclassDiscriminatorStrategy();
        }
        if (discrim.getMappingInfo().getValue() != null) {
            return new ValueMapDiscriminatorStrategy();
        }
        if (cls.getMappedPCSuperclassMapping() != null) {
            return NoneDiscriminatorStrategy.getInstance();
        }
        if (adapting || this._defaults.defaultMissingInfo()) {
            return new ClassNameDiscriminatorStrategy();
        }
        DBDictionary dict = ((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance();
        if (dict.joinSyntax == 1) {
            return NoneDiscriminatorStrategy.getInstance();
        }
        return new SubclassJoinDiscriminatorStrategy();
    }

    protected VersionStrategy defaultStrategy(Version version) {
        return this.defaultStrategy(version, this.getStrategyInstaller().isAdapting());
    }

    protected VersionStrategy defaultStrategy(Version version, boolean adapting) {
        ClassMapping cls = version.getClassMapping();
        if (cls.getEmbeddingMetaData() != null) {
            return NoneVersionStrategy.getInstance();
        }
        if (cls.getJoinablePCSuperclassMapping() == null && cls.getStrategy() == NoneClassStrategy.getInstance()) {
            return NoneVersionStrategy.getInstance();
        }
        Object strat = this._defaults.getStrategy(version, adapting);
        if (strat instanceof String) {
            return this.instantiateVersionStrategy((String)strat, version);
        }
        if (strat != null) {
            return (VersionStrategy)strat;
        }
        if (cls.getJoinablePCSuperclassMapping() != null) {
            return new SuperclassVersionStrategy();
        }
        FieldMapping vfield = version.getClassMapping().getVersionFieldMapping();
        if (vfield != null) {
            return this.defaultStrategy(version, vfield);
        }
        if (adapting || this._defaults.defaultMissingInfo()) {
            return new NumberVersionStrategy();
        }
        return NoneVersionStrategy.getInstance();
    }

    protected VersionStrategy defaultStrategy(Version vers, FieldMapping vfield) {
        switch (vfield.getTypeCode()) {
            case 14: 
            case 28: {
                return JavaVersions.VERSION >= 5 ? new NanoPrecisionTimestampVersionStrategy() : new TimestampVersionStrategy();
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                return new NumberVersionStrategy();
            }
        }
        return NoneVersionStrategy.getInstance();
    }

    public void endConfiguration() {
        super.endConfiguration();
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
        this._dict = conf.getDBDictionaryInstance();
        if (this._defaults == null) {
            this._defaults = conf.getMappingDefaultsInstance();
        }
        if (this._schema != null && this._schema instanceof Configurable) {
            ((Configurable)((Object)this._schema)).setConfiguration(conf);
            ((Configurable)((Object)this._schema)).startConfiguration();
            ((Configurable)((Object)this._schema)).endConfiguration();
        }
    }

    protected ClassMapping findBaseClassMapping(ClassMapping mapping) {
        ClassMapping baseMapping;
        block6: {
            ClassMapping sup;
            block7: {
                baseMapping = null;
                sup = mapping.getPCSuperclassMapping();
                if (sup != null) break block7;
                if (mapping.getPCSubclasses().length > 0) {
                    baseMapping = mapping;
                } else {
                    Collection classes = this.loadPersistentTypes(false, mapping.getEnvClassLoader());
                    for (Class cls : classes) {
                        for (Class supcl = cls.getSuperclass(); supcl != null && !supcl.getClass().equals(Object.class); supcl = supcl.getSuperclass()) {
                            if (supcl.isInterface() || !supcl.equals(mapping.getDescribedType())) continue;
                            baseMapping = mapping;
                            break;
                        }
                        if (baseMapping == null) continue;
                        break block6;
                    }
                }
                break block6;
            }
            if (sup.getDescribedType().isInterface()) break block6;
            ClassMapping supcm = sup;
            while (supcm != null && !supcm.getDescribedType().isInterface() && !supcm.isEmbeddedOnly()) {
                ClassMapping supcm2 = supcm.getPCSuperclassMapping();
                if (supcm2 == null) {
                    baseMapping = supcm;
                }
                supcm = supcm2;
            }
        }
        return baseMapping;
    }

    protected void setDefaultInheritanceStrategy(ClassMapping mapping) {
        ClassMappingInfo info = mapping.getMappingInfo();
        if (info != null && info.getHierarchyStrategy() == null) {
            info.setHierarchyStrategy("flat");
        }
    }

    protected boolean hasInheritanceStrategy(ClassMapping mapping) {
        ClassMappingInfo info = mapping.getMappingInfo();
        return info != null && info.getHierarchyStrategy() != null;
    }
}

