/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.DoubleValue;
import org.apache.openjpa.lib.conf.FileValue;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringListValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.conf.ValueListener;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openjpa.lib.log.NoneLogFactory;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.ParseException;
import org.apache.openjpa.lib.util.Services;
import org.apache.openjpa.lib.util.StringDistance;
import serp.util.Strings;

public class ConfigurationImpl
implements Configuration,
Externalizable,
ValueListener {
    private static final String SEP = J2DoPrivHelper.getLineSeparator();
    private static final Localizer _loc = Localizer.forPackage(ConfigurationImpl.class);
    public ObjectValue logFactoryPlugin;
    public StringValue id;
    private String _product = null;
    private int _readOnlyState = 0;
    private Map _props = null;
    private boolean _globals = false;
    private String _auto = null;
    private final List _vals = new ArrayList();
    private PropertyChangeSupport _changeSupport = null;
    private PropertyDescriptor[] _pds = null;
    private MethodDescriptor[] _mds = null;

    public ConfigurationImpl() {
        this(true);
    }

    public ConfigurationImpl(boolean loadGlobals) {
        this.setProductName("openjpa");
        this.logFactoryPlugin = this.addPlugin("Log", true);
        String[] aliases = new String[]{"true", LogFactoryImpl.class.getName(), "openjpa", LogFactoryImpl.class.getName(), "commons", "org.apache.openjpa.lib.log.CommonsLogFactory", "log4j", "org.apache.openjpa.lib.log.Log4JLogFactory", "none", NoneLogFactory.class.getName(), "false", NoneLogFactory.class.getName()};
        this.logFactoryPlugin.setAliases(aliases);
        this.logFactoryPlugin.setDefault(aliases[0]);
        this.logFactoryPlugin.setString(aliases[0]);
        this.logFactoryPlugin.setInstantiatingGetter("getLogFactory");
        this.id = this.addString("Id");
        if (loadGlobals) {
            this.loadGlobals();
        }
    }

    public boolean loadGlobals() {
        MultiClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        loader.addClassLoader(AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
        loader.addClassLoader(this.getClass().getClassLoader());
        ConfigurationProvider provider = ProductDerivations.loadGlobals(loader);
        if (provider != null) {
            provider.setInto(this);
        }
        try {
            this.fromProperties(new HashMap<Object, Object>((Properties)AccessController.doPrivileged(J2DoPrivHelper.getPropertiesAction())));
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this._globals = true;
        if (provider == null) {
            Log log = this.getConfigurationLog();
            if (log.isTraceEnabled()) {
                log.trace(_loc.get("no-default-providers"));
            }
            return false;
        }
        return true;
    }

    public String getProductName() {
        return this._product;
    }

    public void setProductName(String name) {
        this._product = name;
    }

    public LogFactory getLogFactory() {
        if (this.logFactoryPlugin.get() == null) {
            this.logFactoryPlugin.instantiate(LogFactory.class, this);
        }
        return (LogFactory)this.logFactoryPlugin.get();
    }

    public void setLogFactory(LogFactory logFactory) {
        this.logFactoryPlugin.set(logFactory);
    }

    public String getLog() {
        return this.logFactoryPlugin.getString();
    }

    public void setLog(String log) {
        this.logFactoryPlugin.setString(log);
    }

    public Log getLog(String category) {
        return this.getLogFactory().getLog(category);
    }

    public String getId() {
        return this.id.get();
    }

    public void setId(String id) {
        this.id.set(id);
    }

    public Log getConfigurationLog() {
        return this.getLog("openjpa.Runtime");
    }

    public Value[] getValues() {
        return this._vals.toArray(new Value[this._vals.size()]);
    }

    public Value getValue(String property) {
        if (property == null) {
            return null;
        }
        for (int i = this._vals.size() - 1; i >= 0; --i) {
            Value val = (Value)this._vals.get(i);
            if (!val.getProperty().equals(property)) continue;
            return val;
        }
        return null;
    }

    public void setReadOnly(int newState) {
        if (newState >= this._readOnlyState) {
            this._readOnlyState = newState;
        }
    }

    public void instantiateAll() {
        StringWriter errs = null;
        PrintWriter stack = null;
        for (int i = 0; i < this._vals.size(); ++i) {
            Value val = (Value)this._vals.get(i);
            String getterName = val.getInstantiatingGetter();
            if (getterName == null) continue;
            Cloneable getterTarget = this;
            if (getterName.startsWith("this.")) {
                getterName = getterName.substring("this.".length());
                getterTarget = val;
            }
            try {
                Method getter = getterTarget.getClass().getMethod(getterName, null);
                getter.invoke((Object)getterTarget, (Object[])null);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (errs == null) {
                    errs = new StringWriter();
                    stack = new PrintWriter(errs);
                } else {
                    errs.write(SEP);
                }
                t.printStackTrace(stack);
                stack.flush();
            }
        }
        if (errs != null) {
            throw new RuntimeException(_loc.get("get-prop-errs", errs.toString()).getMessage());
        }
    }

    public boolean isReadOnly() {
        return this._readOnlyState == 2;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void valueChanged(Value val) {
        if (this._changeSupport == null && this._props == null) {
            return;
        }
        String newString = val.getString();
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(val.getProperty(), null, newString);
        }
        if (this._props != null) {
            if (newString == null) {
                Configurations.removeProperty(val.getProperty(), this._props);
            } else if (Configurations.containsProperty(val.getProperty(), this._props) || val.getDefault() == null || !val.getDefault().equals(newString)) {
                this.put(this._props, val, newString);
            }
        }
    }

    public final void close() {
        ProductDerivations.beforeClose(this);
        this.preClose();
        for (int i = 0; i < this._vals.size(); ++i) {
            ObjectValue val;
            if (this._vals.get(i) instanceof Closeable) {
                try {
                    ((Closeable)this._vals.get(i)).close();
                }
                catch (Exception e) {}
                continue;
            }
            if (!(this._vals.get(i) instanceof ObjectValue) || !((val = (ObjectValue)this._vals.get(i)).get() instanceof Closeable)) continue;
            try {
                ((Closeable)val.get()).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void preClose() {
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        return new BeanInfo[0];
    }

    public BeanDescriptor getBeanDescriptor() {
        return new BeanDescriptor(this.getClass());
    }

    public int getDefaultEventIndex() {
        return 0;
    }

    public int getDefaultPropertyIndex() {
        return 0;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return new EventSetDescriptor[0];
    }

    public Image getIcon(int kind) {
        return null;
    }

    public synchronized MethodDescriptor[] getMethodDescriptors() {
        if (this._mds != null) {
            return this._mds;
        }
        PropertyDescriptor[] pds = this.getPropertyDescriptors();
        ArrayList<MethodDescriptor> descs = new ArrayList<MethodDescriptor>();
        for (int i = 0; i < pds.length; ++i) {
            Method write = pds[i].getWriteMethod();
            Method read = pds[i].getReadMethod();
            if (read == null || write == null) continue;
            descs.add(new MethodDescriptor(write));
            descs.add(new MethodDescriptor(read));
        }
        this._mds = descs.toArray(new MethodDescriptor[descs.size()]);
        return this._mds;
    }

    public synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (this._pds != null) {
            return this._pds;
        }
        this._pds = new PropertyDescriptor[this._vals.size()];
        ArrayList<String> failures = null;
        for (int i = 0; i < this._vals.size(); ++i) {
            Value val = (Value)this._vals.get(i);
            try {
                this._pds[i] = this.getPropertyDescriptor(val);
                continue;
            }
            catch (MissingResourceException mre) {
                if (failures == null) {
                    failures = new ArrayList<String>();
                }
                failures.add(val.getProperty());
                continue;
            }
            catch (IntrospectionException ie) {
                if (failures == null) {
                    failures = new ArrayList();
                }
                failures.add(val.getProperty());
            }
        }
        if (failures != null) {
            throw new ParseException(_loc.get("invalid-property-descriptors", failures));
        }
        return this._pds;
    }

    private PropertyDescriptor getPropertyDescriptor(Value val) throws IntrospectionException {
        String cat;
        PropertyDescriptor pd;
        String prop = val.getProperty();
        prop = prop.substring(prop.lastIndexOf(46) + 1);
        try {
            pd = new PropertyDescriptor(Introspector.decapitalize(prop), this.getClass());
        }
        catch (IntrospectionException ie) {
            pd = new PropertyDescriptor(Introspector.decapitalize(prop), null, null);
        }
        pd.setDisplayName(this.findLocalized(prop + "-name", true, val.getScope()));
        pd.setShortDescription(this.findLocalized(prop + "-desc", true, val.getScope()));
        pd.setExpert("true".equals(this.findLocalized(prop + "-expert", false, val.getScope())));
        try {
            pd.setReadMethod(this.getClass().getMethod("get" + StringUtils.capitalize(prop), null));
            pd.setWriteMethod(this.getClass().getMethod("set" + StringUtils.capitalize(prop), pd.getReadMethod().getReturnType()));
        }
        catch (Throwable t) {
            // empty catch block
        }
        String type = this.findLocalized(prop + "-type", true, val.getScope());
        if (type != null) {
            pd.setValue("propertyType", type);
        }
        if ((cat = this.findLocalized(prop + "-cat", false, val.getScope())) != null) {
            pd.setValue("propertyCategory", cat);
        }
        pd.setValue("xmlName", ConfigurationImpl.toXMLName(prop));
        String order = this.findLocalized(prop + "-displayorder", false, val.getScope());
        if (order != null) {
            pd.setValue("propertyCategoryOrder", order);
        }
        TreeSet<String> allowed = new TreeSet<String>();
        List<String> aliases = Collections.EMPTY_LIST;
        if (val.getAliases() != null) {
            aliases = Arrays.asList(val.getAliases());
            for (int i = 0; i < aliases.size(); i += 2) {
                allowed.add(aliases.get(i));
            }
        }
        String[] vals = Strings.split(this.findLocalized(prop + "-values", false, val.getScope()), ",", 0);
        for (int i = 0; i < vals.length; ++i) {
            if (aliases.contains(vals[i])) continue;
            allowed.add(vals[i]);
        }
        try {
            Class<?> intf = Class.forName(this.findLocalized(prop + "-interface", true, val.getScope()), false, this.getClass().getClassLoader());
            pd.setValue("propertyInterface", intf.getName());
            String[] impls = Services.getImplementors(intf);
            for (int i = 0; i < impls.length; ++i) {
                if (aliases.contains(impls[i])) continue;
                allowed.add(impls[i]);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!allowed.isEmpty()) {
            pd.setValue("allowedValues", allowed.toArray(new String[allowed.size()]));
        }
        return pd;
    }

    private String findLocalized(String key, boolean fatal, Class scope) {
        Localizer loc = null;
        if (scope != null) {
            loc = Localizer.forPackage(scope);
            try {
                return loc.getFatal(key).getMessage();
            }
            catch (MissingResourceException mse) {
                // empty catch block
            }
        }
        for (Class<?> cls = this.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            loc = Localizer.forPackage(cls);
            try {
                return loc.getFatal(key).getMessage();
            }
            catch (MissingResourceException mse) {
                continue;
            }
        }
        if (fatal) {
            throw new MissingResourceException(key, this.getClass().getName(), key);
        }
        return null;
    }

    public Map toProperties(boolean storeDefaults) {
        Map clone = this._props == null ? new HashMap() : (this._props instanceof Properties ? (Map)((Properties)this._props).clone() : new HashMap(this._props));
        if (this._props == null || storeDefaults) {
            for (int i = 0; i < this._vals.size(); ++i) {
                String str;
                Value val = (Value)this._vals.get(i);
                if (this._props != null && Configurations.containsProperty(val.getProperty(), this._props) || (str = val.getString()) == null || !storeDefaults && str.equals(val.getDefault())) continue;
                this.put(clone, val, str);
            }
            if (this._props == null) {
                this._props = new HashMap(clone);
            }
        }
        return clone;
    }

    public void fromProperties(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(_loc.get("read-only").getMessage());
        }
        if (this._globals) {
            this._props = null;
            this._globals = false;
        }
        map = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof Properties ? (Map)((Properties)map).clone() : new LinkedHashMap(map));
        HashMap remaining = new HashMap(map);
        boolean ser = true;
        for (int i = 0; i < this._vals.size(); ++i) {
            Value val = (Value)this._vals.get(i);
            Object o = this.get(map, val, true);
            if (o == null) continue;
            if (o instanceof String) {
                if (!StringUtils.equals((String)o, val.getString())) {
                    val.setString((String)o);
                }
            } else {
                ser &= o instanceof Serializable;
                val.setObject(o);
            }
            Configurations.removeProperty(val.getProperty(), remaining);
        }
        Configurations.removeProperty("properties", remaining);
        for (Map.Entry entry : remaining.entrySet()) {
            Object key = entry.getKey();
            if (key == null) continue;
            this.warnInvalidProperty((String)key);
            map.remove(key);
        }
        if (this._props == null && ser) {
            this._props = map;
        }
    }

    private void put(Map map, Value val, Object o) {
        String key = val.getLoadKey();
        if (key == null) {
            key = "openjpa." + val.getProperty();
        }
        map.put(key, o);
    }

    private Object get(Map map, Value val, boolean setLoadKey) {
        String key = ProductDerivations.getConfigurationKey(val.getProperty(), map);
        if (map.containsKey(key) && setLoadKey) {
            val.setLoadKey(key);
        }
        return map.get(key);
    }

    private void warnInvalidProperty(String propName) {
        if (!this.isInvalidProperty(propName)) {
            return;
        }
        Log log = this.getConfigurationLog();
        if (log == null || !log.isWarnEnabled()) {
            return;
        }
        String closest = StringDistance.getClosestLevenshteinDistance(propName, this.newPropertyList(), 15);
        if (closest == null) {
            log.warn(_loc.get("invalid-property", propName));
        } else {
            log.warn(_loc.get("invalid-property-hint", propName, closest));
        }
    }

    private Collection newPropertyList() {
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        ArrayList<String> l = new ArrayList<String>(this._vals.size() * prefixes.length);
        for (int i = 0; i < this._vals.size(); ++i) {
            for (int j = 0; j < prefixes.length; ++j) {
                l.add(prefixes[j] + "." + ((Value)this._vals.get(i)).getProperty());
            }
        }
        return l;
    }

    protected boolean isInvalidProperty(String propName) {
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            if (!propName.toLowerCase().startsWith(prefixes[i]) || propName.length() <= prefixes[i].length() + 1 || propName.indexOf(46, prefixes[i].length()) != prefixes[i].length() || propName.indexOf(46, prefixes[i].length() + 1) != -1) continue;
            return true;
        }
        return false;
    }

    public void setProperties(String resourceName) throws IOException {
        ProductDerivations.load(resourceName, null, this.getClass().getClassLoader()).setInto(this);
        this._auto = resourceName;
    }

    public void setPropertiesFile(File file) throws IOException {
        ProductDerivations.load(file, null, this.getClass().getClassLoader()).setInto(this);
        this._auto = file.toString();
    }

    public String getPropertiesResource() {
        return this._auto;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ConfigurationImpl conf = (ConfigurationImpl)other;
        if (this._vals.size() != conf.getValues().length) {
            return false;
        }
        for (Value v : this._vals) {
            Value thatV;
            if (v.equals(thatV = conf.getValue(v.getProperty()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        Iterator values = this._vals.iterator();
        int hash = 0;
        while (values.hasNext()) {
            Value v = (Value)values.next();
            hash += v.hashCode();
        }
        return hash;
    }

    public static String toXMLName(String propName) {
        if (propName == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < propName.length(); ++i) {
            char c = propName.charAt(i);
            if (i != 0 && Character.isUpperCase(c) && (Character.isLowerCase(propName.charAt(i - 1)) || i > 1 && i < propName.length() - 1 && Character.isUpperCase(propName.charAt(i - 1)) && Character.isLowerCase(propName.charAt(i + 1)))) {
                buf.append('-');
            }
            if (i != 0 && (!Character.isLetter(c) && Character.isLetter(propName.charAt(i - 1)) || Character.isLetter(c) && !Character.isLetter(propName.charAt(i - 1)))) {
                buf.append('-');
            }
            buf.append(Character.toLowerCase(c));
        }
        return buf.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fromProperties((Map)in.readObject());
        this._props = (Map)in.readObject();
        this._globals = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.toProperties(true));
        out.writeObject(this._props);
        out.writeBoolean(this._globals);
    }

    public Object clone() {
        try {
            Constructor<?> cons = this.getClass().getConstructor(Boolean.TYPE);
            ConfigurationImpl clone = (ConfigurationImpl)cons.newInstance(Boolean.FALSE);
            clone.fromProperties(this.toProperties(true));
            clone._props = this._props == null ? null : new HashMap(this._props);
            clone._globals = this._globals;
            return clone;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public boolean removeValue(Value val) {
        if (!this._vals.remove(val)) {
            return false;
        }
        val.removeListener(this);
        return true;
    }

    public Value addValue(Value val) {
        this._vals.add(val);
        val.addListener(this);
        return val;
    }

    public StringValue addString(String property) {
        StringValue val = new StringValue(property);
        this.addValue(val);
        return val;
    }

    public FileValue addFile(String property) {
        FileValue val = new FileValue(property);
        this.addValue(val);
        return val;
    }

    public IntValue addInt(String property) {
        IntValue val = new IntValue(property);
        this.addValue(val);
        return val;
    }

    public DoubleValue addDouble(String property) {
        DoubleValue val = new DoubleValue(property);
        this.addValue(val);
        return val;
    }

    public BooleanValue addBoolean(String property) {
        BooleanValue val = new BooleanValue(property);
        this.addValue(val);
        val.setDefault("false");
        return val;
    }

    public StringListValue addStringList(String property) {
        StringListValue val = new StringListValue(property);
        this.addValue(val);
        return val;
    }

    public ObjectValue addObject(String property) {
        ObjectValue val = new ObjectValue(property);
        this.addValue(val);
        return val;
    }

    public PluginValue addPlugin(String property, boolean singleton) {
        PluginValue val = new PluginValue(property, singleton);
        this.addValue(val);
        return val;
    }

    public PluginListValue addPluginList(String property) {
        PluginListValue val = new PluginListValue(property);
        this.addValue(val);
        return val;
    }
}

