/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TcpFailureDetector
extends ChannelInterceptorBase {
    private static Log log = LogFactory.getLog(TcpFailureDetector.class);
    protected static byte[] TCP_FAIL_DETECT = new byte[]{79, -89, 115, 72, 121, -126, 67, -55, -97, 111, -119, -128, -95, 91, 7, 20, 125, -39, 82, 91, -21, -15, 67, -102, -73, 126, -66, -113, -127, 103, 30, -74, 55, 21, -66, -121, 69, 126, 76, -88, -65, 10, 77, 19, 83, 56, 21, 50, 85, -10, -108, -73, 58, -6, 64, 120, -111, 4, 125, -41, 114, -124, -64, -43};
    protected boolean performConnectTest = true;
    protected long connectTimeout = 1000L;
    protected boolean performSendTest = true;
    protected boolean performReadTest = false;
    protected long readTestTimeout = 5000L;
    protected Membership membership = null;
    protected HashMap removeSuspects = new HashMap();
    protected HashMap addSuspects = new HashMap();

    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        try {
            super.sendMessage(destination, msg, payload);
        }
        catch (ChannelException cx) {
            ChannelException.FaultyMember[] mbrs = cx.getFaultyMembers();
            for (int i = 0; i < mbrs.length; ++i) {
                if (mbrs[i].getCause() == null || mbrs[i].getCause() instanceof RemoteProcessException) continue;
                this.memberDisappeared(mbrs[i].getMember());
            }
            throw cx;
        }
    }

    public void messageReceived(ChannelMessage msg) {
        boolean process = true;
        if (this.okToProcess(msg.getOptions())) {
            boolean bl = process = msg.getMessage().getLength() != TCP_FAIL_DETECT.length || !Arrays.equals(TCP_FAIL_DETECT, msg.getMessage().getBytes());
        }
        if (process) {
            super.messageReceived(msg);
        } else if (log.isDebugEnabled()) {
            log.debug("Received a failure detector packet:" + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberAdded(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean notify = false;
        Membership membership = this.membership;
        synchronized (membership) {
            if (this.removeSuspects.containsKey(member)) {
                this.removeSuspects.remove(member);
            } else if (this.membership.getMember((MemberImpl)member) == null) {
                if (this.memberAlive(member)) {
                    this.membership.memberAlive((MemberImpl)member);
                    notify = true;
                } else {
                    this.addSuspects.put(member, new Long(System.currentTimeMillis()));
                }
            }
        }
        if (notify) {
            super.memberAdded(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberDisappeared(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean notify = false;
        boolean shutdown = Arrays.equals(member.getCommand(), Member.SHUTDOWN_PAYLOAD);
        if (!shutdown && log.isInfoEnabled()) {
            log.info("Received memberDisappeared[" + member + "] message. Will verify.");
        }
        Membership membership = this.membership;
        synchronized (membership) {
            if (shutdown || !this.memberAlive(member)) {
                this.membership.removeMember((MemberImpl)member);
                this.removeSuspects.remove(member);
                notify = true;
            } else {
                this.removeSuspects.put(member, new Long(System.currentTimeMillis()));
            }
        }
        if (notify) {
            if (log.isInfoEnabled()) {
                log.info("Verification complete. Member disappeared[" + member + "]");
            }
            super.memberDisappeared(member);
        } else if (log.isInfoEnabled()) {
            log.info("Verification complete. Member still alive[" + member + "]");
        }
    }

    public boolean hasMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.hasMembers();
    }

    public Member[] getMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMembers();
    }

    public Member getMember(Member mbr) {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMember(mbr);
    }

    public Member getLocalMember(boolean incAlive) {
        return super.getLocalMember(incAlive);
    }

    public void heartbeat() {
        super.heartbeat();
        this.checkMembers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMembers(boolean checkAll) {
        try {
            try {
                if (this.membership == null) {
                    this.setupMembership();
                }
                Membership membership = this.membership;
                synchronized (membership) {
                    if (!checkAll) {
                        this.performBasicCheck();
                    } else {
                        this.performForcedCheck();
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception x) {
                log.warn("Unable to perform heartbeat on the TcpFailureDetector.", x);
                Object var5_6 = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    protected void performForcedCheck() {
        Member[] members = super.getMembers();
        for (int i = 0; members != null && i < members.length; ++i) {
            if (this.memberAlive(members[i])) {
                if (this.membership.memberAlive((MemberImpl)members[i])) {
                    super.memberAdded(members[i]);
                }
                this.addSuspects.remove(members[i]);
                continue;
            }
            if (this.membership.getMember(members[i]) == null) continue;
            this.membership.removeMember((MemberImpl)members[i]);
            this.removeSuspects.remove(members[i]);
            super.memberDisappeared((MemberImpl)members[i]);
        }
    }

    protected void performBasicCheck() {
        MemberImpl m;
        int i;
        Member[] members = super.getMembers();
        for (int i2 = 0; members != null && i2 < members.length; ++i2) {
            if (!this.membership.memberAlive((MemberImpl)members[i2])) continue;
            if (this.memberAlive(members[i2])) {
                log.warn("Member added, even though we werent notified:" + members[i2]);
                super.memberAdded(members[i2]);
                continue;
            }
            this.membership.removeMember((MemberImpl)members[i2]);
        }
        MemberImpl[] keys = this.removeSuspects.keySet().toArray(new MemberImpl[this.removeSuspects.size()]);
        for (i = 0; i < keys.length; ++i) {
            m = keys[i];
            if (this.membership.getMember(m) == null || this.memberAlive(m)) continue;
            this.membership.removeMember(m);
            super.memberDisappeared(m);
            this.removeSuspects.remove(m);
            if (!log.isInfoEnabled()) continue;
            log.info("Suspect member, confirmed dead.[" + m + "]");
        }
        keys = this.addSuspects.keySet().toArray(new MemberImpl[this.addSuspects.size()]);
        for (i = 0; i < keys.length; ++i) {
            m = keys[i];
            if (this.membership.getMember(m) != null || !this.memberAlive(m)) continue;
            this.membership.memberAlive(m);
            super.memberAdded(m);
            this.addSuspects.remove(m);
            if (!log.isInfoEnabled()) continue;
            log.info("Suspect member, confirmed alive.[" + m + "]");
        }
    }

    protected synchronized void setupMembership() {
        if (this.membership == null) {
            this.membership = new Membership((MemberImpl)super.getLocalMember(true));
        }
    }

    protected boolean memberAlive(Member mbr) {
        return TcpFailureDetector.memberAlive(mbr, TCP_FAIL_DETECT, this.performSendTest, this.performReadTest, this.readTestTimeout, this.connectTimeout, this.getOptionFlag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean memberAlive(Member mbr, byte[] msgData, boolean sendTest, boolean readTest, long readTimeout, long conTimeout, int optionFlag) {
        block18: {
            block17: {
                if (Arrays.equals(mbr.getCommand(), Member.SHUTDOWN_PAYLOAD)) {
                    return false;
                }
                socket = new Socket();
                try {
                    try {
                        ia = InetAddress.getByAddress(mbr.getHost());
                        addr = new InetSocketAddress(ia, mbr.getPort());
                        socket.setSoTimeout((int)readTimeout);
                        socket.connect(addr, (int)conTimeout);
                        if (sendTest) {
                            data = new ChannelData(true);
                            data.setAddress(mbr);
                            data.setMessage(new XByteBuffer(msgData, false));
                            data.setTimestamp(System.currentTimeMillis());
                            options = optionFlag | 1;
                            options = readTest ? (options |= 2) : (options &= -3);
                            data.setOptions(options);
                            message = XByteBuffer.createDataPackage(data);
                            socket.getOutputStream().write(message);
                            if (readTest) {
                                length = socket.getInputStream().read(message);
                                var16_18 = length > 0;
                                var18_19 = null;
                                break block17;
                            }
                        }
                        var12_14 = true;
                        break block18;
                    }
                    catch (SocketTimeoutException sx) {
                        var18_21 = null;
                        try {
                            socket.close();
                            return false;
                        }
                        catch (Exception ignore) {
                            return false;
                        }
                    }
                    catch (ConnectException cx) {
                        var18_22 = null;
                        try {}
                        catch (Exception ignore) {
                            return false;
                        }
                        socket.close();
                        return false;
                    }
                    catch (Exception x) {
                        TcpFailureDetector.log.error("Unable to perform failure detection check, assuming member down.", x);
                        var18_23 = null;
                        try {}
                        catch (Exception ignore) {
                            return false;
                        }
                        socket.close();
                        return false;
                    }
                }
                catch (Throwable var17_31) {
                    var18_24 = null;
                    ** try [egrp 2[TRYBLOCK] [12 : 253->261)] { 
lbl58:
                    // 1 sources

                    socket.close();
                    throw var17_31;
lbl60:
                    // 1 sources

                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw var17_31;
                }
            }
            ** try [egrp 2[TRYBLOCK] [12 : 253->261)] { 
lbl65:
            // 1 sources

            socket.close();
            return var16_18;
lbl67:
            // 1 sources

            catch (Exception ignore) {
                // empty catch block
            }
            return var16_18;
        }
        var18_20 = null;
        try {}
        catch (Exception ignore) {
            // empty catch block
            return var12_14;
        }
        socket.close();
        return var12_14;
    }

    public boolean getPerformConnectTest() {
        return this.performConnectTest;
    }

    public long getReadTestTimeout() {
        return this.readTestTimeout;
    }

    public boolean getPerformSendTest() {
        return this.performSendTest;
    }

    public boolean getPerformReadTest() {
        return this.performReadTest;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setPerformConnectTest(boolean performConnectTest) {
        this.performConnectTest = performConnectTest;
    }

    public void setPerformReadTest(boolean performReadTest) {
        this.performReadTest = performReadTest;
    }

    public void setPerformSendTest(boolean performSendTest) {
        this.performSendTest = performSendTest;
    }

    public void setReadTestTimeout(long readTestTimeout) {
        this.readTestTimeout = readTestTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

